// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The details of the asset for which the subscription grant is created.
 */
public class SubscribedAsset private constructor(builder: Builder) {
    /**
     * The identifier of the asset for which the subscription grant is created.
     */
    public val assetId: kotlin.String = requireNotNull(builder.assetId) { "A non-null value must be provided for assetId" }
    /**
     * The revision of the asset for which the subscription grant is created.
     */
    public val assetRevision: kotlin.String = requireNotNull(builder.assetRevision) { "A non-null value must be provided for assetRevision" }
    /**
     * The failure cause included in the details of the asset for which the subscription grant is created.
     */
    public val failureCause: aws.sdk.kotlin.services.datazone.model.FailureCause? = builder.failureCause
    /**
     * The failure timestamp included in the details of the asset for which the subscription grant is created.
     */
    public val failureTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.failureTimestamp
    /**
     * The timestamp of when the subscription grant to the asset is created.
     */
    public val grantedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.grantedTimestamp
    /**
     * The status of the asset for which the subscription grant is created.
     */
    public val status: aws.sdk.kotlin.services.datazone.model.SubscriptionGrantStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The target name of the asset for which the subscription grant is created.
     */
    public val targetName: kotlin.String? = builder.targetName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datazone.model.SubscribedAsset = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SubscribedAsset(")
        append("assetId=$assetId,")
        append("assetRevision=$assetRevision,")
        append("failureCause=$failureCause,")
        append("failureTimestamp=$failureTimestamp,")
        append("grantedTimestamp=$grantedTimestamp,")
        append("status=$status,")
        append("targetName=$targetName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetId.hashCode()
        result = 31 * result + (assetRevision.hashCode())
        result = 31 * result + (failureCause?.hashCode() ?: 0)
        result = 31 * result + (failureTimestamp?.hashCode() ?: 0)
        result = 31 * result + (grantedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (targetName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SubscribedAsset

        if (assetId != other.assetId) return false
        if (assetRevision != other.assetRevision) return false
        if (failureCause != other.failureCause) return false
        if (failureTimestamp != other.failureTimestamp) return false
        if (grantedTimestamp != other.grantedTimestamp) return false
        if (status != other.status) return false
        if (targetName != other.targetName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datazone.model.SubscribedAsset = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the asset for which the subscription grant is created.
         */
        public var assetId: kotlin.String? = null
        /**
         * The revision of the asset for which the subscription grant is created.
         */
        public var assetRevision: kotlin.String? = null
        /**
         * The failure cause included in the details of the asset for which the subscription grant is created.
         */
        public var failureCause: aws.sdk.kotlin.services.datazone.model.FailureCause? = null
        /**
         * The failure timestamp included in the details of the asset for which the subscription grant is created.
         */
        public var failureTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The timestamp of when the subscription grant to the asset is created.
         */
        public var grantedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the asset for which the subscription grant is created.
         */
        public var status: aws.sdk.kotlin.services.datazone.model.SubscriptionGrantStatus? = null
        /**
         * The target name of the asset for which the subscription grant is created.
         */
        public var targetName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datazone.model.SubscribedAsset) : this() {
            this.assetId = x.assetId
            this.assetRevision = x.assetRevision
            this.failureCause = x.failureCause
            this.failureTimestamp = x.failureTimestamp
            this.grantedTimestamp = x.grantedTimestamp
            this.status = x.status
            this.targetName = x.targetName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datazone.model.SubscribedAsset = SubscribedAsset(this)

        /**
         * construct an [aws.sdk.kotlin.services.datazone.model.FailureCause] inside the given [block]
         */
        public fun failureCause(block: aws.sdk.kotlin.services.datazone.model.FailureCause.Builder.() -> kotlin.Unit) {
            this.failureCause = aws.sdk.kotlin.services.datazone.model.FailureCause.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (assetId == null) assetId = ""
            if (assetRevision == null) assetRevision = ""
            if (status == null) status = SubscriptionGrantStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
