// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.model



public class ListEnvironmentsRequest private constructor(builder: Builder) {
    /**
     * The identifier of the Amazon Web Services account where you want to list environments.
     */
    public val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * The Amazon Web Services region where you want to list environments.
     */
    public val awsAccountRegion: kotlin.String? = builder.awsAccountRegion
    /**
     * The identifier of the Amazon DataZone domain.
     */
    public val domainIdentifier: kotlin.String? = builder.domainIdentifier
    /**
     * The identifier of the Amazon DataZone blueprint.
     */
    public val environmentBlueprintIdentifier: kotlin.String? = builder.environmentBlueprintIdentifier
    /**
     * The identifier of the environment profile.
     */
    public val environmentProfileIdentifier: kotlin.String? = builder.environmentProfileIdentifier
    /**
     * The maximum number of environments to return in a single call to `ListEnvironments`. When the number of environments to be listed is greater than the value of `MaxResults`, the response contains a `NextToken` value that you can use in a subsequent call to `ListEnvironments` to list the next set of environments.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     *
     */
    public val name: kotlin.String? = builder.name
    /**
     * When the number of environments is greater than the default value for the `MaxResults` parameter, or if you explicitly specify a value for `MaxResults` that is less than the number of environments, the response includes a pagination token named `NextToken`. You can specify this `NextToken` value in a subsequent call to `ListEnvironments` to list the next set of environments.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The identifier of the Amazon DataZone project.
     */
    public val projectIdentifier: kotlin.String? = builder.projectIdentifier
    /**
     * The provider of the environment.
     */
    public val provider: kotlin.String? = builder.provider
    /**
     * The status of the environments that you want to list.
     */
    public val status: aws.sdk.kotlin.services.datazone.model.EnvironmentStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datazone.model.ListEnvironmentsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListEnvironmentsRequest(")
        append("awsAccountId=$awsAccountId,")
        append("awsAccountRegion=$awsAccountRegion,")
        append("domainIdentifier=$domainIdentifier,")
        append("environmentBlueprintIdentifier=$environmentBlueprintIdentifier,")
        append("environmentProfileIdentifier=$environmentProfileIdentifier,")
        append("maxResults=$maxResults,")
        append("name=$name,")
        append("nextToken=$nextToken,")
        append("projectIdentifier=$projectIdentifier,")
        append("provider=$provider,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountId?.hashCode() ?: 0
        result = 31 * result + (awsAccountRegion?.hashCode() ?: 0)
        result = 31 * result + (domainIdentifier?.hashCode() ?: 0)
        result = 31 * result + (environmentBlueprintIdentifier?.hashCode() ?: 0)
        result = 31 * result + (environmentProfileIdentifier?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (projectIdentifier?.hashCode() ?: 0)
        result = 31 * result + (provider?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListEnvironmentsRequest

        if (awsAccountId != other.awsAccountId) return false
        if (awsAccountRegion != other.awsAccountRegion) return false
        if (domainIdentifier != other.domainIdentifier) return false
        if (environmentBlueprintIdentifier != other.environmentBlueprintIdentifier) return false
        if (environmentProfileIdentifier != other.environmentProfileIdentifier) return false
        if (maxResults != other.maxResults) return false
        if (name != other.name) return false
        if (nextToken != other.nextToken) return false
        if (projectIdentifier != other.projectIdentifier) return false
        if (provider != other.provider) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datazone.model.ListEnvironmentsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the Amazon Web Services account where you want to list environments.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * The Amazon Web Services region where you want to list environments.
         */
        public var awsAccountRegion: kotlin.String? = null
        /**
         * The identifier of the Amazon DataZone domain.
         */
        public var domainIdentifier: kotlin.String? = null
        /**
         * The identifier of the Amazon DataZone blueprint.
         */
        public var environmentBlueprintIdentifier: kotlin.String? = null
        /**
         * The identifier of the environment profile.
         */
        public var environmentProfileIdentifier: kotlin.String? = null
        /**
         * The maximum number of environments to return in a single call to `ListEnvironments`. When the number of environments to be listed is greater than the value of `MaxResults`, the response contains a `NextToken` value that you can use in a subsequent call to `ListEnvironments` to list the next set of environments.
         */
        public var maxResults: kotlin.Int? = null
        /**
         *
         */
        public var name: kotlin.String? = null
        /**
         * When the number of environments is greater than the default value for the `MaxResults` parameter, or if you explicitly specify a value for `MaxResults` that is less than the number of environments, the response includes a pagination token named `NextToken`. You can specify this `NextToken` value in a subsequent call to `ListEnvironments` to list the next set of environments.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The identifier of the Amazon DataZone project.
         */
        public var projectIdentifier: kotlin.String? = null
        /**
         * The provider of the environment.
         */
        public var provider: kotlin.String? = null
        /**
         * The status of the environments that you want to list.
         */
        public var status: aws.sdk.kotlin.services.datazone.model.EnvironmentStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datazone.model.ListEnvironmentsRequest) : this() {
            this.awsAccountId = x.awsAccountId
            this.awsAccountRegion = x.awsAccountRegion
            this.domainIdentifier = x.domainIdentifier
            this.environmentBlueprintIdentifier = x.environmentBlueprintIdentifier
            this.environmentProfileIdentifier = x.environmentProfileIdentifier
            this.maxResults = x.maxResults
            this.name = x.name
            this.nextToken = x.nextToken
            this.projectIdentifier = x.projectIdentifier
            this.provider = x.provider
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datazone.model.ListEnvironmentsRequest = ListEnvironmentsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
