// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.model

import aws.smithy.kotlin.runtime.time.Instant

public class GetDataSourceRunResponse private constructor(builder: Builder) {
    /**
     * The timestamp of when the data source run was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The configuration snapshot of the data source run.
     */
    public val dataSourceConfigurationSnapshot: kotlin.String? = builder.dataSourceConfigurationSnapshot
    /**
     * The ID of the data source for this data source run.
     */
    public val dataSourceId: kotlin.String = requireNotNull(builder.dataSourceId) { "A non-null value must be provided for dataSourceId" }
    /**
     * The ID of the domain in which this data source run was performed.
     */
    public val domainId: kotlin.String = requireNotNull(builder.domainId) { "A non-null value must be provided for domainId" }
    /**
     * Specifies the error message that is returned if the operation cannot be successfully completed.
     */
    public val errorMessage: aws.sdk.kotlin.services.datazone.model.DataSourceErrorMessage? = builder.errorMessage
    /**
     * The ID of the data source run.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The ID of the project in which this data source run occured.
     */
    public val projectId: kotlin.String = requireNotNull(builder.projectId) { "A non-null value must be provided for projectId" }
    /**
     * The asset statistics from this data source run.
     */
    public val runStatisticsForAssets: aws.sdk.kotlin.services.datazone.model.RunStatisticsForAssets? = builder.runStatisticsForAssets
    /**
     * The timestamp of when this data source run started.
     */
    public val startedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.startedAt
    /**
     * The status of this data source run.
     */
    public val status: aws.sdk.kotlin.services.datazone.model.DataSourceRunStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The timestamp of when this data source run stopped.
     */
    public val stoppedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.stoppedAt
    /**
     * The type of this data source run.
     */
    public val type: aws.sdk.kotlin.services.datazone.model.DataSourceRunType = requireNotNull(builder.type) { "A non-null value must be provided for type" }
    /**
     * The timestamp of when this data source run was updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updatedAt) { "A non-null value must be provided for updatedAt" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datazone.model.GetDataSourceRunResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetDataSourceRunResponse(")
        append("createdAt=$createdAt,")
        append("dataSourceConfigurationSnapshot=$dataSourceConfigurationSnapshot,")
        append("dataSourceId=$dataSourceId,")
        append("domainId=$domainId,")
        append("errorMessage=$errorMessage,")
        append("id=$id,")
        append("projectId=$projectId,")
        append("runStatisticsForAssets=$runStatisticsForAssets,")
        append("startedAt=$startedAt,")
        append("status=$status,")
        append("stoppedAt=$stoppedAt,")
        append("type=$type,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt.hashCode()
        result = 31 * result + (dataSourceConfigurationSnapshot?.hashCode() ?: 0)
        result = 31 * result + (dataSourceId.hashCode())
        result = 31 * result + (domainId.hashCode())
        result = 31 * result + (errorMessage?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (projectId.hashCode())
        result = 31 * result + (runStatisticsForAssets?.hashCode() ?: 0)
        result = 31 * result + (startedAt?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (stoppedAt?.hashCode() ?: 0)
        result = 31 * result + (type.hashCode())
        result = 31 * result + (updatedAt.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetDataSourceRunResponse

        if (createdAt != other.createdAt) return false
        if (dataSourceConfigurationSnapshot != other.dataSourceConfigurationSnapshot) return false
        if (dataSourceId != other.dataSourceId) return false
        if (domainId != other.domainId) return false
        if (errorMessage != other.errorMessage) return false
        if (id != other.id) return false
        if (projectId != other.projectId) return false
        if (runStatisticsForAssets != other.runStatisticsForAssets) return false
        if (startedAt != other.startedAt) return false
        if (status != other.status) return false
        if (stoppedAt != other.stoppedAt) return false
        if (type != other.type) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datazone.model.GetDataSourceRunResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The timestamp of when the data source run was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The configuration snapshot of the data source run.
         */
        public var dataSourceConfigurationSnapshot: kotlin.String? = null
        /**
         * The ID of the data source for this data source run.
         */
        public var dataSourceId: kotlin.String? = null
        /**
         * The ID of the domain in which this data source run was performed.
         */
        public var domainId: kotlin.String? = null
        /**
         * Specifies the error message that is returned if the operation cannot be successfully completed.
         */
        public var errorMessage: aws.sdk.kotlin.services.datazone.model.DataSourceErrorMessage? = null
        /**
         * The ID of the data source run.
         */
        public var id: kotlin.String? = null
        /**
         * The ID of the project in which this data source run occured.
         */
        public var projectId: kotlin.String? = null
        /**
         * The asset statistics from this data source run.
         */
        public var runStatisticsForAssets: aws.sdk.kotlin.services.datazone.model.RunStatisticsForAssets? = null
        /**
         * The timestamp of when this data source run started.
         */
        public var startedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of this data source run.
         */
        public var status: aws.sdk.kotlin.services.datazone.model.DataSourceRunStatus? = null
        /**
         * The timestamp of when this data source run stopped.
         */
        public var stoppedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The type of this data source run.
         */
        public var type: aws.sdk.kotlin.services.datazone.model.DataSourceRunType? = null
        /**
         * The timestamp of when this data source run was updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datazone.model.GetDataSourceRunResponse) : this() {
            this.createdAt = x.createdAt
            this.dataSourceConfigurationSnapshot = x.dataSourceConfigurationSnapshot
            this.dataSourceId = x.dataSourceId
            this.domainId = x.domainId
            this.errorMessage = x.errorMessage
            this.id = x.id
            this.projectId = x.projectId
            this.runStatisticsForAssets = x.runStatisticsForAssets
            this.startedAt = x.startedAt
            this.status = x.status
            this.stoppedAt = x.stoppedAt
            this.type = x.type
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datazone.model.GetDataSourceRunResponse = GetDataSourceRunResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.datazone.model.DataSourceErrorMessage] inside the given [block]
         */
        public fun errorMessage(block: aws.sdk.kotlin.services.datazone.model.DataSourceErrorMessage.Builder.() -> kotlin.Unit) {
            this.errorMessage = aws.sdk.kotlin.services.datazone.model.DataSourceErrorMessage.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.datazone.model.RunStatisticsForAssets] inside the given [block]
         */
        public fun runStatisticsForAssets(block: aws.sdk.kotlin.services.datazone.model.RunStatisticsForAssets.Builder.() -> kotlin.Unit) {
            this.runStatisticsForAssets = aws.sdk.kotlin.services.datazone.model.RunStatisticsForAssets.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (dataSourceId == null) dataSourceId = ""
            if (domainId == null) domainId = ""
            if (id == null) id = ""
            if (projectId == null) projectId = ""
            if (status == null) status = DataSourceRunStatus.SdkUnknown("no value provided")
            if (type == null) type = DataSourceRunType.SdkUnknown("no value provided")
            if (updatedAt == null) updatedAt = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
