// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The details of an environment.
 */
public class EnvironmentSummary private constructor(builder: Builder) {
    /**
     * The identifier of the Amazon Web Services account in which an environment exists.
     */
    public val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * The Amazon Web Services Region in which an environment exists.
     */
    public val awsAccountRegion: kotlin.String? = builder.awsAccountRegion
    /**
     * The timestamp of when the environment was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The Amazon DataZone user who created the environment.
     */
    public val createdBy: kotlin.String = requireNotNull(builder.createdBy) { "A non-null value must be provided for createdBy" }
    /**
     * The description of the environment.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The identifier of the Amazon DataZone domain in which the environment exists.
     */
    public val domainId: kotlin.String = requireNotNull(builder.domainId) { "A non-null value must be provided for domainId" }
    /**
     * The identifier of the environment profile with which the environment was created.
     */
    public val environmentProfileId: kotlin.String = requireNotNull(builder.environmentProfileId) { "A non-null value must be provided for environmentProfileId" }
    /**
     * The identifier of the environment.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The name of the environment.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The identifier of the project in which the environment exists.
     */
    public val projectId: kotlin.String = requireNotNull(builder.projectId) { "A non-null value must be provided for projectId" }
    /**
     * The provider of the environment.
     */
    public val provider: kotlin.String = requireNotNull(builder.provider) { "A non-null value must be provided for provider" }
    /**
     * The status of the environment.
     */
    public val status: aws.sdk.kotlin.services.datazone.model.EnvironmentStatus? = builder.status
    /**
     * The timestamp of when the environment was updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datazone.model.EnvironmentSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EnvironmentSummary(")
        append("awsAccountId=$awsAccountId,")
        append("awsAccountRegion=$awsAccountRegion,")
        append("createdAt=$createdAt,")
        append("createdBy=$createdBy,")
        append("description=*** Sensitive Data Redacted ***,")
        append("domainId=$domainId,")
        append("environmentProfileId=$environmentProfileId,")
        append("id=$id,")
        append("name=*** Sensitive Data Redacted ***,")
        append("projectId=$projectId,")
        append("provider=$provider,")
        append("status=$status,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountId?.hashCode() ?: 0
        result = 31 * result + (awsAccountRegion?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (createdBy.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (domainId.hashCode())
        result = 31 * result + (environmentProfileId.hashCode())
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (projectId.hashCode())
        result = 31 * result + (provider.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EnvironmentSummary

        if (awsAccountId != other.awsAccountId) return false
        if (awsAccountRegion != other.awsAccountRegion) return false
        if (createdAt != other.createdAt) return false
        if (createdBy != other.createdBy) return false
        if (description != other.description) return false
        if (domainId != other.domainId) return false
        if (environmentProfileId != other.environmentProfileId) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (projectId != other.projectId) return false
        if (provider != other.provider) return false
        if (status != other.status) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datazone.model.EnvironmentSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the Amazon Web Services account in which an environment exists.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * The Amazon Web Services Region in which an environment exists.
         */
        public var awsAccountRegion: kotlin.String? = null
        /**
         * The timestamp of when the environment was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon DataZone user who created the environment.
         */
        public var createdBy: kotlin.String? = null
        /**
         * The description of the environment.
         */
        public var description: kotlin.String? = null
        /**
         * The identifier of the Amazon DataZone domain in which the environment exists.
         */
        public var domainId: kotlin.String? = null
        /**
         * The identifier of the environment profile with which the environment was created.
         */
        public var environmentProfileId: kotlin.String? = null
        /**
         * The identifier of the environment.
         */
        public var id: kotlin.String? = null
        /**
         * The name of the environment.
         */
        public var name: kotlin.String? = null
        /**
         * The identifier of the project in which the environment exists.
         */
        public var projectId: kotlin.String? = null
        /**
         * The provider of the environment.
         */
        public var provider: kotlin.String? = null
        /**
         * The status of the environment.
         */
        public var status: aws.sdk.kotlin.services.datazone.model.EnvironmentStatus? = null
        /**
         * The timestamp of when the environment was updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datazone.model.EnvironmentSummary) : this() {
            this.awsAccountId = x.awsAccountId
            this.awsAccountRegion = x.awsAccountRegion
            this.createdAt = x.createdAt
            this.createdBy = x.createdBy
            this.description = x.description
            this.domainId = x.domainId
            this.environmentProfileId = x.environmentProfileId
            this.id = x.id
            this.name = x.name
            this.projectId = x.projectId
            this.provider = x.provider
            this.status = x.status
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datazone.model.EnvironmentSummary = EnvironmentSummary(this)

        internal fun correctErrors(): Builder {
            if (createdBy == null) createdBy = ""
            if (domainId == null) domainId = ""
            if (environmentProfileId == null) environmentProfileId = ""
            if (name == null) name = ""
            if (projectId == null) projectId = ""
            if (provider == null) provider = ""
            return this
        }
    }
}
