// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.model

import aws.smithy.kotlin.runtime.time.Instant

public class CreateDataSourceResponse private constructor(builder: Builder) {
    /**
     * The metadata forms attached to the assets that this data source creates.
     */
    public val assetFormsOutput: List<FormOutput>? = builder.assetFormsOutput
    /**
     * Specifies the configuration of the data source. It can be set to either `glueRunConfiguration` or `redshiftRunConfiguration`.
     */
    public val configuration: aws.sdk.kotlin.services.datazone.model.DataSourceConfigurationOutput? = builder.configuration
    /**
     * The timestamp of when the data source was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The description of the data source.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The ID of the Amazon DataZone domain in which the data source is created.
     */
    public val domainId: kotlin.String = requireNotNull(builder.domainId) { "A non-null value must be provided for domainId" }
    /**
     * Specifies whether the data source is enabled.
     */
    public val enableSetting: aws.sdk.kotlin.services.datazone.model.EnableSetting? = builder.enableSetting
    /**
     * The unique identifier of the Amazon DataZone environment to which the data source publishes assets.
     */
    public val environmentId: kotlin.String = requireNotNull(builder.environmentId) { "A non-null value must be provided for environmentId" }
    /**
     * Specifies the error message that is returned if the operation cannot be successfully completed.
     */
    public val errorMessage: aws.sdk.kotlin.services.datazone.model.DataSourceErrorMessage? = builder.errorMessage
    /**
     * The unique identifier of the data source.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The timestamp that specifies when the data source was last run.
     */
    public val lastRunAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastRunAt
    /**
     * Specifies the error message that is returned if the operation cannot be successfully completed.
     */
    public val lastRunErrorMessage: aws.sdk.kotlin.services.datazone.model.DataSourceErrorMessage? = builder.lastRunErrorMessage
    /**
     * The status of the last run of this data source.
     */
    public val lastRunStatus: aws.sdk.kotlin.services.datazone.model.DataSourceRunStatus? = builder.lastRunStatus
    /**
     * The name of the data source.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The ID of the Amazon DataZone project to which the data source is added.
     */
    public val projectId: kotlin.String = requireNotNull(builder.projectId) { "A non-null value must be provided for projectId" }
    /**
     * Specifies whether the assets that this data source creates in the inventory are to be also automatically published to the catalog.
     */
    public val publishOnImport: kotlin.Boolean? = builder.publishOnImport
    /**
     * Specifies whether the business name generation is to be enabled for this data source.
     */
    public val recommendation: aws.sdk.kotlin.services.datazone.model.RecommendationConfiguration? = builder.recommendation
    /**
     * The schedule of the data source runs.
     */
    public val schedule: aws.sdk.kotlin.services.datazone.model.ScheduleConfiguration? = builder.schedule
    /**
     * The status of the data source.
     */
    public val status: aws.sdk.kotlin.services.datazone.model.DataSourceStatus? = builder.status
    /**
     * The type of the data source.
     */
    public val type: kotlin.String? = builder.type
    /**
     * The timestamp of when the data source was updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datazone.model.CreateDataSourceResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDataSourceResponse(")
        append("assetFormsOutput=$assetFormsOutput,")
        append("configuration=$configuration,")
        append("createdAt=$createdAt,")
        append("description=*** Sensitive Data Redacted ***,")
        append("domainId=$domainId,")
        append("enableSetting=$enableSetting,")
        append("environmentId=$environmentId,")
        append("errorMessage=$errorMessage,")
        append("id=$id,")
        append("lastRunAt=$lastRunAt,")
        append("lastRunErrorMessage=$lastRunErrorMessage,")
        append("lastRunStatus=$lastRunStatus,")
        append("name=*** Sensitive Data Redacted ***,")
        append("projectId=$projectId,")
        append("publishOnImport=$publishOnImport,")
        append("recommendation=$recommendation,")
        append("schedule=*** Sensitive Data Redacted ***,")
        append("status=$status,")
        append("type=$type,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetFormsOutput?.hashCode() ?: 0
        result = 31 * result + (configuration?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (domainId.hashCode())
        result = 31 * result + (enableSetting?.hashCode() ?: 0)
        result = 31 * result + (environmentId.hashCode())
        result = 31 * result + (errorMessage?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (lastRunAt?.hashCode() ?: 0)
        result = 31 * result + (lastRunErrorMessage?.hashCode() ?: 0)
        result = 31 * result + (lastRunStatus?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (projectId.hashCode())
        result = 31 * result + (publishOnImport?.hashCode() ?: 0)
        result = 31 * result + (recommendation?.hashCode() ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDataSourceResponse

        if (assetFormsOutput != other.assetFormsOutput) return false
        if (configuration != other.configuration) return false
        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (domainId != other.domainId) return false
        if (enableSetting != other.enableSetting) return false
        if (environmentId != other.environmentId) return false
        if (errorMessage != other.errorMessage) return false
        if (id != other.id) return false
        if (lastRunAt != other.lastRunAt) return false
        if (lastRunErrorMessage != other.lastRunErrorMessage) return false
        if (lastRunStatus != other.lastRunStatus) return false
        if (name != other.name) return false
        if (projectId != other.projectId) return false
        if (publishOnImport != other.publishOnImport) return false
        if (recommendation != other.recommendation) return false
        if (schedule != other.schedule) return false
        if (status != other.status) return false
        if (type != other.type) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datazone.model.CreateDataSourceResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The metadata forms attached to the assets that this data source creates.
         */
        public var assetFormsOutput: List<FormOutput>? = null
        /**
         * Specifies the configuration of the data source. It can be set to either `glueRunConfiguration` or `redshiftRunConfiguration`.
         */
        public var configuration: aws.sdk.kotlin.services.datazone.model.DataSourceConfigurationOutput? = null
        /**
         * The timestamp of when the data source was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the data source.
         */
        public var description: kotlin.String? = null
        /**
         * The ID of the Amazon DataZone domain in which the data source is created.
         */
        public var domainId: kotlin.String? = null
        /**
         * Specifies whether the data source is enabled.
         */
        public var enableSetting: aws.sdk.kotlin.services.datazone.model.EnableSetting? = null
        /**
         * The unique identifier of the Amazon DataZone environment to which the data source publishes assets.
         */
        public var environmentId: kotlin.String? = null
        /**
         * Specifies the error message that is returned if the operation cannot be successfully completed.
         */
        public var errorMessage: aws.sdk.kotlin.services.datazone.model.DataSourceErrorMessage? = null
        /**
         * The unique identifier of the data source.
         */
        public var id: kotlin.String? = null
        /**
         * The timestamp that specifies when the data source was last run.
         */
        public var lastRunAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the error message that is returned if the operation cannot be successfully completed.
         */
        public var lastRunErrorMessage: aws.sdk.kotlin.services.datazone.model.DataSourceErrorMessage? = null
        /**
         * The status of the last run of this data source.
         */
        public var lastRunStatus: aws.sdk.kotlin.services.datazone.model.DataSourceRunStatus? = null
        /**
         * The name of the data source.
         */
        public var name: kotlin.String? = null
        /**
         * The ID of the Amazon DataZone project to which the data source is added.
         */
        public var projectId: kotlin.String? = null
        /**
         * Specifies whether the assets that this data source creates in the inventory are to be also automatically published to the catalog.
         */
        public var publishOnImport: kotlin.Boolean? = null
        /**
         * Specifies whether the business name generation is to be enabled for this data source.
         */
        public var recommendation: aws.sdk.kotlin.services.datazone.model.RecommendationConfiguration? = null
        /**
         * The schedule of the data source runs.
         */
        public var schedule: aws.sdk.kotlin.services.datazone.model.ScheduleConfiguration? = null
        /**
         * The status of the data source.
         */
        public var status: aws.sdk.kotlin.services.datazone.model.DataSourceStatus? = null
        /**
         * The type of the data source.
         */
        public var type: kotlin.String? = null
        /**
         * The timestamp of when the data source was updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datazone.model.CreateDataSourceResponse) : this() {
            this.assetFormsOutput = x.assetFormsOutput
            this.configuration = x.configuration
            this.createdAt = x.createdAt
            this.description = x.description
            this.domainId = x.domainId
            this.enableSetting = x.enableSetting
            this.environmentId = x.environmentId
            this.errorMessage = x.errorMessage
            this.id = x.id
            this.lastRunAt = x.lastRunAt
            this.lastRunErrorMessage = x.lastRunErrorMessage
            this.lastRunStatus = x.lastRunStatus
            this.name = x.name
            this.projectId = x.projectId
            this.publishOnImport = x.publishOnImport
            this.recommendation = x.recommendation
            this.schedule = x.schedule
            this.status = x.status
            this.type = x.type
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datazone.model.CreateDataSourceResponse = CreateDataSourceResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.datazone.model.DataSourceErrorMessage] inside the given [block]
         */
        public fun errorMessage(block: aws.sdk.kotlin.services.datazone.model.DataSourceErrorMessage.Builder.() -> kotlin.Unit) {
            this.errorMessage = aws.sdk.kotlin.services.datazone.model.DataSourceErrorMessage.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.datazone.model.DataSourceErrorMessage] inside the given [block]
         */
        public fun lastRunErrorMessage(block: aws.sdk.kotlin.services.datazone.model.DataSourceErrorMessage.Builder.() -> kotlin.Unit) {
            this.lastRunErrorMessage = aws.sdk.kotlin.services.datazone.model.DataSourceErrorMessage.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.datazone.model.RecommendationConfiguration] inside the given [block]
         */
        public fun recommendation(block: aws.sdk.kotlin.services.datazone.model.RecommendationConfiguration.Builder.() -> kotlin.Unit) {
            this.recommendation = aws.sdk.kotlin.services.datazone.model.RecommendationConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.datazone.model.ScheduleConfiguration] inside the given [block]
         */
        public fun schedule(block: aws.sdk.kotlin.services.datazone.model.ScheduleConfiguration.Builder.() -> kotlin.Unit) {
            this.schedule = aws.sdk.kotlin.services.datazone.model.ScheduleConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (domainId == null) domainId = ""
            if (environmentId == null) environmentId = ""
            if (id == null) id = ""
            if (name == null) name = ""
            if (projectId == null) projectId = ""
            return this
        }
    }
}
