// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A Amazon DataZone inventory asset.
 */
public class AssetItem private constructor(builder: Builder) {
    /**
     * The additional attributes of a Amazon DataZone inventory asset.
     */
    public val additionalAttributes: aws.sdk.kotlin.services.datazone.model.AssetItemAdditionalAttributes? = builder.additionalAttributes
    /**
     * The timestamp of when the Amazon DataZone inventory asset was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The Amazon DataZone user who created the inventory asset.
     */
    public val createdBy: kotlin.String? = builder.createdBy
    /**
     * The description of an Amazon DataZone inventory asset.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The identifier of the Amazon DataZone domain in which the inventory asset exists.
     */
    public val domainId: kotlin.String = requireNotNull(builder.domainId) { "A non-null value must be provided for domainId" }
    /**
     * The external identifier of the Amazon DataZone inventory asset.
     */
    public val externalIdentifier: kotlin.String? = builder.externalIdentifier
    /**
     * The timestamp of when the first revision of the inventory asset was created.
     */
    public val firstRevisionCreatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.firstRevisionCreatedAt
    /**
     * The Amazon DataZone user who created the first revision of the inventory asset.
     */
    public val firstRevisionCreatedBy: kotlin.String? = builder.firstRevisionCreatedBy
    /**
     * The glossary terms attached to the Amazon DataZone inventory asset.
     */
    public val glossaryTerms: List<String>? = builder.glossaryTerms
    /**
     * the identifier of the Amazon DataZone inventory asset.
     */
    public val identifier: kotlin.String = requireNotNull(builder.identifier) { "A non-null value must be provided for identifier" }
    /**
     * The name of the Amazon DataZone inventory asset.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The identifier of the Amazon DataZone project that owns the inventory asset.
     */
    public val owningProjectId: kotlin.String = requireNotNull(builder.owningProjectId) { "A non-null value must be provided for owningProjectId" }
    /**
     * The identifier of the asset type of the specified Amazon DataZone inventory asset.
     */
    public val typeIdentifier: kotlin.String = requireNotNull(builder.typeIdentifier) { "A non-null value must be provided for typeIdentifier" }
    /**
     * The revision of the inventory asset type.
     */
    public val typeRevision: kotlin.String = requireNotNull(builder.typeRevision) { "A non-null value must be provided for typeRevision" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datazone.model.AssetItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssetItem(")
        append("additionalAttributes=$additionalAttributes,")
        append("createdAt=$createdAt,")
        append("createdBy=$createdBy,")
        append("description=*** Sensitive Data Redacted ***,")
        append("domainId=$domainId,")
        append("externalIdentifier=*** Sensitive Data Redacted ***,")
        append("firstRevisionCreatedAt=$firstRevisionCreatedAt,")
        append("firstRevisionCreatedBy=$firstRevisionCreatedBy,")
        append("glossaryTerms=$glossaryTerms,")
        append("identifier=$identifier,")
        append("name=*** Sensitive Data Redacted ***,")
        append("owningProjectId=$owningProjectId,")
        append("typeIdentifier=$typeIdentifier,")
        append("typeRevision=$typeRevision")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalAttributes?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (domainId.hashCode())
        result = 31 * result + (externalIdentifier?.hashCode() ?: 0)
        result = 31 * result + (firstRevisionCreatedAt?.hashCode() ?: 0)
        result = 31 * result + (firstRevisionCreatedBy?.hashCode() ?: 0)
        result = 31 * result + (glossaryTerms?.hashCode() ?: 0)
        result = 31 * result + (identifier.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (owningProjectId.hashCode())
        result = 31 * result + (typeIdentifier.hashCode())
        result = 31 * result + (typeRevision.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssetItem

        if (additionalAttributes != other.additionalAttributes) return false
        if (createdAt != other.createdAt) return false
        if (createdBy != other.createdBy) return false
        if (description != other.description) return false
        if (domainId != other.domainId) return false
        if (externalIdentifier != other.externalIdentifier) return false
        if (firstRevisionCreatedAt != other.firstRevisionCreatedAt) return false
        if (firstRevisionCreatedBy != other.firstRevisionCreatedBy) return false
        if (glossaryTerms != other.glossaryTerms) return false
        if (identifier != other.identifier) return false
        if (name != other.name) return false
        if (owningProjectId != other.owningProjectId) return false
        if (typeIdentifier != other.typeIdentifier) return false
        if (typeRevision != other.typeRevision) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datazone.model.AssetItem = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The additional attributes of a Amazon DataZone inventory asset.
         */
        public var additionalAttributes: aws.sdk.kotlin.services.datazone.model.AssetItemAdditionalAttributes? = null
        /**
         * The timestamp of when the Amazon DataZone inventory asset was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon DataZone user who created the inventory asset.
         */
        public var createdBy: kotlin.String? = null
        /**
         * The description of an Amazon DataZone inventory asset.
         */
        public var description: kotlin.String? = null
        /**
         * The identifier of the Amazon DataZone domain in which the inventory asset exists.
         */
        public var domainId: kotlin.String? = null
        /**
         * The external identifier of the Amazon DataZone inventory asset.
         */
        public var externalIdentifier: kotlin.String? = null
        /**
         * The timestamp of when the first revision of the inventory asset was created.
         */
        public var firstRevisionCreatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon DataZone user who created the first revision of the inventory asset.
         */
        public var firstRevisionCreatedBy: kotlin.String? = null
        /**
         * The glossary terms attached to the Amazon DataZone inventory asset.
         */
        public var glossaryTerms: List<String>? = null
        /**
         * the identifier of the Amazon DataZone inventory asset.
         */
        public var identifier: kotlin.String? = null
        /**
         * The name of the Amazon DataZone inventory asset.
         */
        public var name: kotlin.String? = null
        /**
         * The identifier of the Amazon DataZone project that owns the inventory asset.
         */
        public var owningProjectId: kotlin.String? = null
        /**
         * The identifier of the asset type of the specified Amazon DataZone inventory asset.
         */
        public var typeIdentifier: kotlin.String? = null
        /**
         * The revision of the inventory asset type.
         */
        public var typeRevision: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datazone.model.AssetItem) : this() {
            this.additionalAttributes = x.additionalAttributes
            this.createdAt = x.createdAt
            this.createdBy = x.createdBy
            this.description = x.description
            this.domainId = x.domainId
            this.externalIdentifier = x.externalIdentifier
            this.firstRevisionCreatedAt = x.firstRevisionCreatedAt
            this.firstRevisionCreatedBy = x.firstRevisionCreatedBy
            this.glossaryTerms = x.glossaryTerms
            this.identifier = x.identifier
            this.name = x.name
            this.owningProjectId = x.owningProjectId
            this.typeIdentifier = x.typeIdentifier
            this.typeRevision = x.typeRevision
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datazone.model.AssetItem = AssetItem(this)

        /**
         * construct an [aws.sdk.kotlin.services.datazone.model.AssetItemAdditionalAttributes] inside the given [block]
         */
        public fun additionalAttributes(block: aws.sdk.kotlin.services.datazone.model.AssetItemAdditionalAttributes.Builder.() -> kotlin.Unit) {
            this.additionalAttributes = aws.sdk.kotlin.services.datazone.model.AssetItemAdditionalAttributes.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (domainId == null) domainId = ""
            if (identifier == null) identifier = ""
            if (name == null) name = ""
            if (owningProjectId == null) owningProjectId = ""
            if (typeIdentifier == null) typeIdentifier = ""
            if (typeRevision == null) typeRevision = ""
            return this
        }
    }
}
