// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.serde

import aws.sdk.kotlin.services.datasync.model.DataSyncException
import aws.sdk.kotlin.services.datasync.model.DescribeTaskExecutionResponse
import aws.sdk.kotlin.services.datasync.model.FilterRule
import aws.sdk.kotlin.services.datasync.model.ManifestConfig
import aws.sdk.kotlin.services.datasync.model.Options
import aws.sdk.kotlin.services.datasync.model.ReportResult
import aws.sdk.kotlin.services.datasync.model.TaskExecutionFilesFailedDetail
import aws.sdk.kotlin.services.datasync.model.TaskExecutionFilesListedDetail
import aws.sdk.kotlin.services.datasync.model.TaskExecutionResultDetail
import aws.sdk.kotlin.services.datasync.model.TaskExecutionStatus
import aws.sdk.kotlin.services.datasync.model.TaskMode
import aws.sdk.kotlin.services.datasync.model.TaskReportConfig
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class DescribeTaskExecutionOperationDeserializer: HttpDeserializer.NonStreaming<DescribeTaskExecutionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeTaskExecutionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeTaskExecutionError(context, call, payload)
        }
        val builder = DescribeTaskExecutionResponse.Builder()

        if (payload != null) {
            deserializeDescribeTaskExecutionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeTaskExecutionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DataSyncException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> DataSyncException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeTaskExecutionOperationBody(builder: DescribeTaskExecutionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BYTESCOMPRESSED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("BytesCompressed"))
    val BYTESTRANSFERRED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("BytesTransferred"))
    val BYTESWRITTEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("BytesWritten"))
    val ESTIMATEDBYTESTOTRANSFER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("EstimatedBytesToTransfer"))
    val ESTIMATEDFILESTODELETE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("EstimatedFilesToDelete"))
    val ESTIMATEDFILESTOTRANSFER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("EstimatedFilesToTransfer"))
    val EXCLUDES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Excludes"))
    val FILESDELETED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("FilesDeleted"))
    val FILESFAILED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("FilesFailed"))
    val FILESLISTED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("FilesListed"))
    val FILESPREPARED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("FilesPrepared"))
    val FILESSKIPPED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("FilesSkipped"))
    val FILESTRANSFERRED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("FilesTransferred"))
    val FILESVERIFIED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("FilesVerified"))
    val INCLUDES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Includes"))
    val MANIFESTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ManifestConfig"))
    val OPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Options"))
    val REPORTRESULT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ReportResult"))
    val RESULT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Result"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("StartTime"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val TASKEXECUTIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TaskExecutionArn"))
    val TASKMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("TaskMode"))
    val TASKREPORTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TaskReportConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BYTESCOMPRESSED_DESCRIPTOR)
        field(BYTESTRANSFERRED_DESCRIPTOR)
        field(BYTESWRITTEN_DESCRIPTOR)
        field(ESTIMATEDBYTESTOTRANSFER_DESCRIPTOR)
        field(ESTIMATEDFILESTODELETE_DESCRIPTOR)
        field(ESTIMATEDFILESTOTRANSFER_DESCRIPTOR)
        field(EXCLUDES_DESCRIPTOR)
        field(FILESDELETED_DESCRIPTOR)
        field(FILESFAILED_DESCRIPTOR)
        field(FILESLISTED_DESCRIPTOR)
        field(FILESPREPARED_DESCRIPTOR)
        field(FILESSKIPPED_DESCRIPTOR)
        field(FILESTRANSFERRED_DESCRIPTOR)
        field(FILESVERIFIED_DESCRIPTOR)
        field(INCLUDES_DESCRIPTOR)
        field(MANIFESTCONFIG_DESCRIPTOR)
        field(OPTIONS_DESCRIPTOR)
        field(REPORTRESULT_DESCRIPTOR)
        field(RESULT_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TASKEXECUTIONARN_DESCRIPTOR)
        field(TASKMODE_DESCRIPTOR)
        field(TASKREPORTCONFIG_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BYTESCOMPRESSED_DESCRIPTOR.index -> builder.bytesCompressed = deserializeLong()
                BYTESTRANSFERRED_DESCRIPTOR.index -> builder.bytesTransferred = deserializeLong()
                BYTESWRITTEN_DESCRIPTOR.index -> builder.bytesWritten = deserializeLong()
                ESTIMATEDBYTESTOTRANSFER_DESCRIPTOR.index -> builder.estimatedBytesToTransfer = deserializeLong()
                ESTIMATEDFILESTODELETE_DESCRIPTOR.index -> builder.estimatedFilesToDelete = deserializeLong()
                ESTIMATEDFILESTOTRANSFER_DESCRIPTOR.index -> builder.estimatedFilesToTransfer = deserializeLong()
                EXCLUDES_DESCRIPTOR.index -> builder.excludes =
                    deserializer.deserializeList(EXCLUDES_DESCRIPTOR) {
                        val col0 = mutableListOf<FilterRule>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFilterRuleDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FILESDELETED_DESCRIPTOR.index -> builder.filesDeleted = deserializeLong()
                FILESFAILED_DESCRIPTOR.index -> builder.filesFailed = deserializeTaskExecutionFilesFailedDetailDocument(deserializer)
                FILESLISTED_DESCRIPTOR.index -> builder.filesListed = deserializeTaskExecutionFilesListedDetailDocument(deserializer)
                FILESPREPARED_DESCRIPTOR.index -> builder.filesPrepared = deserializeLong()
                FILESSKIPPED_DESCRIPTOR.index -> builder.filesSkipped = deserializeLong()
                FILESTRANSFERRED_DESCRIPTOR.index -> builder.filesTransferred = deserializeLong()
                FILESVERIFIED_DESCRIPTOR.index -> builder.filesVerified = deserializeLong()
                INCLUDES_DESCRIPTOR.index -> builder.includes =
                    deserializer.deserializeList(INCLUDES_DESCRIPTOR) {
                        val col0 = mutableListOf<FilterRule>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFilterRuleDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                MANIFESTCONFIG_DESCRIPTOR.index -> builder.manifestConfig = deserializeManifestConfigDocument(deserializer)
                OPTIONS_DESCRIPTOR.index -> builder.options = deserializeOptionsDocument(deserializer)
                REPORTRESULT_DESCRIPTOR.index -> builder.reportResult = deserializeReportResultDocument(deserializer)
                RESULT_DESCRIPTOR.index -> builder.result = deserializeTaskExecutionResultDetailDocument(deserializer)
                STARTTIME_DESCRIPTOR.index -> builder.startTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { TaskExecutionStatus.fromValue(it) }
                TASKEXECUTIONARN_DESCRIPTOR.index -> builder.taskExecutionArn = deserializeString()
                TASKMODE_DESCRIPTOR.index -> builder.taskMode = deserializeString().let { TaskMode.fromValue(it) }
                TASKREPORTCONFIG_DESCRIPTOR.index -> builder.taskReportConfig = deserializeTaskReportConfigDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
