// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.serde

import aws.sdk.kotlin.services.datasync.model.DataSyncException
import aws.sdk.kotlin.services.datasync.model.DescribeLocationObjectStorageResponse
import aws.sdk.kotlin.services.datasync.model.ObjectStorageServerProtocol
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class DescribeLocationObjectStorageOperationDeserializer: HttpDeserializer.NonStreaming<DescribeLocationObjectStorageResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeLocationObjectStorageResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeLocationObjectStorageError(context, call, payload)
        }
        val builder = DescribeLocationObjectStorageResponse.Builder()

        if (payload != null) {
            deserializeDescribeLocationObjectStorageOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeLocationObjectStorageError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DataSyncException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> DataSyncException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeLocationObjectStorageOperationBody(builder: DescribeLocationObjectStorageResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACCESSKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AccessKey"))
    val AGENTARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AgentArns"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val LOCATIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LocationArn"))
    val LOCATIONURI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LocationUri"))
    val SERVERCERTIFICATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Blob, JsonSerialName("ServerCertificate"))
    val SERVERPORT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("ServerPort"))
    val SERVERPROTOCOL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ServerProtocol"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCESSKEY_DESCRIPTOR)
        field(AGENTARNS_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(LOCATIONARN_DESCRIPTOR)
        field(LOCATIONURI_DESCRIPTOR)
        field(SERVERCERTIFICATE_DESCRIPTOR)
        field(SERVERPORT_DESCRIPTOR)
        field(SERVERPROTOCOL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCESSKEY_DESCRIPTOR.index -> builder.accessKey = deserializeString()
                AGENTARNS_DESCRIPTOR.index -> builder.agentArns =
                    deserializer.deserializeList(AGENTARNS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                LOCATIONARN_DESCRIPTOR.index -> builder.locationArn = deserializeString()
                LOCATIONURI_DESCRIPTOR.index -> builder.locationUri = deserializeString()
                SERVERCERTIFICATE_DESCRIPTOR.index -> builder.serverCertificate = deserializeByteArray()
                SERVERPORT_DESCRIPTOR.index -> builder.serverPort = deserializeInt()
                SERVERPROTOCOL_DESCRIPTOR.index -> builder.serverProtocol = deserializeString().let { ObjectStorageServerProtocol.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
