// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.serde

import aws.sdk.kotlin.services.datasync.model.DataSyncException
import aws.sdk.kotlin.services.datasync.model.DescribeLocationFsxOntapResponse
import aws.sdk.kotlin.services.datasync.model.FsxProtocol
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class DescribeLocationFsxOntapOperationDeserializer: HttpDeserializer.NonStreaming<DescribeLocationFsxOntapResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeLocationFsxOntapResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeLocationFsxOntapError(context, call, payload)
        }
        val builder = DescribeLocationFsxOntapResponse.Builder()

        if (payload != null) {
            deserializeDescribeLocationFsxOntapOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeLocationFsxOntapError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DataSyncException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> DataSyncException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeLocationFsxOntapOperationBody(builder: DescribeLocationFsxOntapResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val FSXFILESYSTEMARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FsxFilesystemArn"))
    val LOCATIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LocationArn"))
    val LOCATIONURI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LocationUri"))
    val PROTOCOL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Protocol"))
    val SECURITYGROUPARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SecurityGroupArns"))
    val STORAGEVIRTUALMACHINEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StorageVirtualMachineArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(FSXFILESYSTEMARN_DESCRIPTOR)
        field(LOCATIONARN_DESCRIPTOR)
        field(LOCATIONURI_DESCRIPTOR)
        field(PROTOCOL_DESCRIPTOR)
        field(SECURITYGROUPARNS_DESCRIPTOR)
        field(STORAGEVIRTUALMACHINEARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                FSXFILESYSTEMARN_DESCRIPTOR.index -> builder.fsxFilesystemArn = deserializeString()
                LOCATIONARN_DESCRIPTOR.index -> builder.locationArn = deserializeString()
                LOCATIONURI_DESCRIPTOR.index -> builder.locationUri = deserializeString()
                PROTOCOL_DESCRIPTOR.index -> builder.protocol = deserializeFsxProtocolDocument(deserializer)
                SECURITYGROUPARNS_DESCRIPTOR.index -> builder.securityGroupArns =
                    deserializer.deserializeList(SECURITYGROUPARNS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                STORAGEVIRTUALMACHINEARN_DESCRIPTOR.index -> builder.storageVirtualMachineArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
