// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.serde

import aws.sdk.kotlin.services.datasync.model.AgentStatus
import aws.sdk.kotlin.services.datasync.model.DataSyncException
import aws.sdk.kotlin.services.datasync.model.DescribeAgentResponse
import aws.sdk.kotlin.services.datasync.model.EndpointType
import aws.sdk.kotlin.services.datasync.model.Platform
import aws.sdk.kotlin.services.datasync.model.PrivateLinkConfig
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeAgentOperationDeserializer: HttpDeserializer.NonStreaming<DescribeAgentResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeAgentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeAgentError(context, call, payload)
        }
        val builder = DescribeAgentResponse.Builder()

        if (payload != null) {
            deserializeDescribeAgentOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeAgentError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DataSyncException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> DataSyncException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAgentOperationBody(builder: DescribeAgentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AGENTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AgentArn"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val ENDPOINTTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("EndpointType"))
    val LASTCONNECTIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastConnectionTime"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val PLATFORM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Platform"))
    val PRIVATELINKCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("PrivateLinkConfig"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AGENTARN_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(ENDPOINTTYPE_DESCRIPTOR)
        field(LASTCONNECTIONTIME_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PLATFORM_DESCRIPTOR)
        field(PRIVATELINKCONFIG_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AGENTARN_DESCRIPTOR.index -> builder.agentArn = deserializeString()
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                ENDPOINTTYPE_DESCRIPTOR.index -> builder.endpointType = deserializeString().let { EndpointType.fromValue(it) }
                LASTCONNECTIONTIME_DESCRIPTOR.index -> builder.lastConnectionTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                PLATFORM_DESCRIPTOR.index -> builder.platform = deserializePlatformDocument(deserializer)
                PRIVATELINKCONFIG_DESCRIPTOR.index -> builder.privateLinkConfig = deserializePrivateLinkConfigDocument(deserializer)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { AgentStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
