// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.paginators

import aws.sdk.kotlin.services.datasync.DataSyncClient
import aws.sdk.kotlin.services.datasync.model.AgentListEntry
import aws.sdk.kotlin.services.datasync.model.DescribeStorageSystemResourceMetricsRequest
import aws.sdk.kotlin.services.datasync.model.DescribeStorageSystemResourceMetricsResponse
import aws.sdk.kotlin.services.datasync.model.DescribeStorageSystemResourcesRequest
import aws.sdk.kotlin.services.datasync.model.DescribeStorageSystemResourcesResponse
import aws.sdk.kotlin.services.datasync.model.DiscoveryJobListEntry
import aws.sdk.kotlin.services.datasync.model.ListAgentsRequest
import aws.sdk.kotlin.services.datasync.model.ListAgentsResponse
import aws.sdk.kotlin.services.datasync.model.ListDiscoveryJobsRequest
import aws.sdk.kotlin.services.datasync.model.ListDiscoveryJobsResponse
import aws.sdk.kotlin.services.datasync.model.ListLocationsRequest
import aws.sdk.kotlin.services.datasync.model.ListLocationsResponse
import aws.sdk.kotlin.services.datasync.model.ListStorageSystemsRequest
import aws.sdk.kotlin.services.datasync.model.ListStorageSystemsResponse
import aws.sdk.kotlin.services.datasync.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.datasync.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.datasync.model.ListTaskExecutionsRequest
import aws.sdk.kotlin.services.datasync.model.ListTaskExecutionsResponse
import aws.sdk.kotlin.services.datasync.model.ListTasksRequest
import aws.sdk.kotlin.services.datasync.model.ListTasksResponse
import aws.sdk.kotlin.services.datasync.model.LocationListEntry
import aws.sdk.kotlin.services.datasync.model.ResourceMetrics
import aws.sdk.kotlin.services.datasync.model.StorageSystemListEntry
import aws.sdk.kotlin.services.datasync.model.TagListEntry
import aws.sdk.kotlin.services.datasync.model.TaskExecutionListEntry
import aws.sdk.kotlin.services.datasync.model.TaskListEntry
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeStorageSystemResourceMetricsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeStorageSystemResourceMetricsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeStorageSystemResourceMetricsResponse]
 */
public fun DataSyncClient.describeStorageSystemResourceMetricsPaginated(initialRequest: DescribeStorageSystemResourceMetricsRequest): Flow<DescribeStorageSystemResourceMetricsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeStorageSystemResourceMetricsPaginated.describeStorageSystemResourceMetrics(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeStorageSystemResourceMetricsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeStorageSystemResourceMetricsResponse]
 */
public fun DataSyncClient.describeStorageSystemResourceMetricsPaginated(block: DescribeStorageSystemResourceMetricsRequest.Builder.() -> Unit): Flow<DescribeStorageSystemResourceMetricsResponse> =
    describeStorageSystemResourceMetricsPaginated(DescribeStorageSystemResourceMetricsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeStorageSystemResourceMetricsPaginated]
 * to access the nested member [ResourceMetrics]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ResourceMetrics]
 */
@JvmName("describeStorageSystemResourceMetricsResponseResourceMetrics")
public fun Flow<DescribeStorageSystemResourceMetricsResponse>.metrics(): Flow<ResourceMetrics> =
    transform() { response ->
        response.metrics?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeStorageSystemResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeStorageSystemResourcesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeStorageSystemResourcesResponse]
 */
public fun DataSyncClient.describeStorageSystemResourcesPaginated(initialRequest: DescribeStorageSystemResourcesRequest): Flow<DescribeStorageSystemResourcesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeStorageSystemResourcesPaginated.describeStorageSystemResources(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeStorageSystemResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeStorageSystemResourcesResponse]
 */
public fun DataSyncClient.describeStorageSystemResourcesPaginated(block: DescribeStorageSystemResourcesRequest.Builder.() -> Unit): Flow<DescribeStorageSystemResourcesResponse> =
    describeStorageSystemResourcesPaginated(DescribeStorageSystemResourcesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAgentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAgentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAgentsResponse]
 */
public fun DataSyncClient.listAgentsPaginated(initialRequest: ListAgentsRequest = ListAgentsRequest { }): Flow<ListAgentsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAgentsPaginated.listAgents(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAgentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAgentsResponse]
 */
public fun DataSyncClient.listAgentsPaginated(block: ListAgentsRequest.Builder.() -> Unit): Flow<ListAgentsResponse> =
    listAgentsPaginated(ListAgentsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAgentsPaginated]
 * to access the nested member [AgentListEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AgentListEntry]
 */
@JvmName("listAgentsResponseAgentListEntry")
public fun Flow<ListAgentsResponse>.agents(): Flow<AgentListEntry> =
    transform() { response ->
        response.agents?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDiscoveryJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDiscoveryJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDiscoveryJobsResponse]
 */
public fun DataSyncClient.listDiscoveryJobsPaginated(initialRequest: ListDiscoveryJobsRequest = ListDiscoveryJobsRequest { }): Flow<ListDiscoveryJobsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDiscoveryJobsPaginated.listDiscoveryJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDiscoveryJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDiscoveryJobsResponse]
 */
public fun DataSyncClient.listDiscoveryJobsPaginated(block: ListDiscoveryJobsRequest.Builder.() -> Unit): Flow<ListDiscoveryJobsResponse> =
    listDiscoveryJobsPaginated(ListDiscoveryJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDiscoveryJobsPaginated]
 * to access the nested member [DiscoveryJobListEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DiscoveryJobListEntry]
 */
@JvmName("listDiscoveryJobsResponseDiscoveryJobListEntry")
public fun Flow<ListDiscoveryJobsResponse>.discoveryJobs(): Flow<DiscoveryJobListEntry> =
    transform() { response ->
        response.discoveryJobs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListLocationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListLocationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLocationsResponse]
 */
public fun DataSyncClient.listLocationsPaginated(initialRequest: ListLocationsRequest = ListLocationsRequest { }): Flow<ListLocationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listLocationsPaginated.listLocations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListLocationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLocationsResponse]
 */
public fun DataSyncClient.listLocationsPaginated(block: ListLocationsRequest.Builder.() -> Unit): Flow<ListLocationsResponse> =
    listLocationsPaginated(ListLocationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listLocationsPaginated]
 * to access the nested member [LocationListEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [LocationListEntry]
 */
@JvmName("listLocationsResponseLocationListEntry")
public fun Flow<ListLocationsResponse>.locations(): Flow<LocationListEntry> =
    transform() { response ->
        response.locations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListStorageSystemsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListStorageSystemsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStorageSystemsResponse]
 */
public fun DataSyncClient.listStorageSystemsPaginated(initialRequest: ListStorageSystemsRequest = ListStorageSystemsRequest { }): Flow<ListStorageSystemsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listStorageSystemsPaginated.listStorageSystems(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListStorageSystemsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStorageSystemsResponse]
 */
public fun DataSyncClient.listStorageSystemsPaginated(block: ListStorageSystemsRequest.Builder.() -> Unit): Flow<ListStorageSystemsResponse> =
    listStorageSystemsPaginated(ListStorageSystemsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listStorageSystemsPaginated]
 * to access the nested member [StorageSystemListEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [StorageSystemListEntry]
 */
@JvmName("listStorageSystemsResponseStorageSystemListEntry")
public fun Flow<ListStorageSystemsResponse>.storageSystems(): Flow<StorageSystemListEntry> =
    transform() { response ->
        response.storageSystems?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTagsForResourceRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
public fun DataSyncClient.listTagsForResourcePaginated(initialRequest: ListTagsForResourceRequest): Flow<ListTagsForResourceResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTagsForResourcePaginated.listTagsForResource(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
public fun DataSyncClient.listTagsForResourcePaginated(block: ListTagsForResourceRequest.Builder.() -> Unit): Flow<ListTagsForResourceResponse> =
    listTagsForResourcePaginated(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTagsForResourcePaginated]
 * to access the nested member [TagListEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TagListEntry]
 */
@JvmName("listTagsForResourceResponseTagListEntry")
public fun Flow<ListTagsForResourceResponse>.tags(): Flow<TagListEntry> =
    transform() { response ->
        response.tags?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTaskExecutionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTaskExecutionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTaskExecutionsResponse]
 */
public fun DataSyncClient.listTaskExecutionsPaginated(initialRequest: ListTaskExecutionsRequest = ListTaskExecutionsRequest { }): Flow<ListTaskExecutionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTaskExecutionsPaginated.listTaskExecutions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTaskExecutionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTaskExecutionsResponse]
 */
public fun DataSyncClient.listTaskExecutionsPaginated(block: ListTaskExecutionsRequest.Builder.() -> Unit): Flow<ListTaskExecutionsResponse> =
    listTaskExecutionsPaginated(ListTaskExecutionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTaskExecutionsPaginated]
 * to access the nested member [TaskExecutionListEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TaskExecutionListEntry]
 */
@JvmName("listTaskExecutionsResponseTaskExecutionListEntry")
public fun Flow<ListTaskExecutionsResponse>.taskExecutions(): Flow<TaskExecutionListEntry> =
    transform() { response ->
        response.taskExecutions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTasksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTasksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTasksResponse]
 */
public fun DataSyncClient.listTasksPaginated(initialRequest: ListTasksRequest = ListTasksRequest { }): Flow<ListTasksResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTasksPaginated.listTasks(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTasksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTasksResponse]
 */
public fun DataSyncClient.listTasksPaginated(block: ListTasksRequest.Builder.() -> Unit): Flow<ListTasksResponse> =
    listTasksPaginated(ListTasksRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTasksPaginated]
 * to access the nested member [TaskListEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TaskListEntry]
 */
@JvmName("listTasksResponseTaskListEntry")
public fun Flow<ListTasksResponse>.tasks(): Flow<TaskListEntry> =
    transform() { response ->
        response.tasks?.forEach {
            emit(it)
        }
    }
