// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * UpdateTaskResponse
 */
public class UpdateTaskRequest private constructor(builder: Builder) {
    /**
     * Specifies the Amazon Resource Name (ARN) of an Amazon CloudWatch log group for monitoring your task.
     *
     * For Enhanced mode tasks, you must use `/aws/datasync` as your log group name. For example:
     *
     * `arn:aws:logs:us-east-1:111222333444:log-group:/aws/datasync:*`
     *
     * For more information, see [Monitoring data transfers with CloudWatch Logs](https://docs.aws.amazon.com/datasync/latest/userguide/configure-logging.html).
     */
    public val cloudWatchLogGroupArn: kotlin.String? = builder.cloudWatchLogGroupArn
    /**
     * Specifies exclude filters that define the files, objects, and folders in your source location that you don't want DataSync to transfer. For more information and examples, see [Specifying what DataSync transfers by using filters](https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html).
     */
    public val excludes: List<FilterRule>? = builder.excludes
    /**
     * Specifies include filters define the files, objects, and folders in your source location that you want DataSync to transfer. For more information and examples, see [Specifying what DataSync transfers by using filters](https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html).
     */
    public val includes: List<FilterRule>? = builder.includes
    /**
     * Configures a manifest, which is a list of files or objects that you want DataSync to transfer. For more information and configuration examples, see [Specifying what DataSync transfers by using a manifest](https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html).
     *
     * When using this parameter, your caller identity (the IAM role that you're using DataSync with) must have the `iam:PassRole` permission. The [AWSDataSyncFullAccess](https://docs.aws.amazon.com/datasync/latest/userguide/security-iam-awsmanpol.html#security-iam-awsmanpol-awsdatasyncfullaccess) policy includes this permission.
     *
     * To remove a manifest configuration, specify this parameter as empty.
     */
    public val manifestConfig: aws.sdk.kotlin.services.datasync.model.ManifestConfig? = builder.manifestConfig
    /**
     * Specifies the name of your task.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Indicates how your transfer task is configured. These options include how DataSync handles files, objects, and their associated metadata during your transfer. You also can specify how to verify data integrity, set bandwidth limits for your task, among other options.
     *
     * Each option has a default value. Unless you need to, you don't have to configure any option before calling [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html).
     *
     * You also can override your task options for each task execution. For example, you might want to adjust the `LogLevel` for an individual execution.
     */
    public val options: aws.sdk.kotlin.services.datasync.model.Options? = builder.options
    /**
     * Specifies a schedule for when you want your task to run. For more information, see [Scheduling your task](https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html).
     */
    public val schedule: aws.sdk.kotlin.services.datasync.model.TaskSchedule? = builder.schedule
    /**
     * Specifies the ARN of the task that you want to update.
     */
    public val taskArn: kotlin.String? = builder.taskArn
    /**
     * Specifies how you want to configure a task report, which provides detailed information about your DataSync transfer. For more information, see [Monitoring your DataSync transfers with task reports](https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html).
     *
     * When using this parameter, your caller identity (the IAM role that you're using DataSync with) must have the `iam:PassRole` permission. The [AWSDataSyncFullAccess](https://docs.aws.amazon.com/datasync/latest/userguide/security-iam-awsmanpol.html#security-iam-awsmanpol-awsdatasyncfullaccess) policy includes this permission.
     *
     * To remove a task report configuration, specify this parameter as empty.
     */
    public val taskReportConfig: aws.sdk.kotlin.services.datasync.model.TaskReportConfig? = builder.taskReportConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.UpdateTaskRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateTaskRequest(")
        append("cloudWatchLogGroupArn=$cloudWatchLogGroupArn,")
        append("excludes=$excludes,")
        append("includes=$includes,")
        append("manifestConfig=$manifestConfig,")
        append("name=$name,")
        append("options=$options,")
        append("schedule=$schedule,")
        append("taskArn=$taskArn,")
        append("taskReportConfig=$taskReportConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchLogGroupArn?.hashCode() ?: 0
        result = 31 * result + (excludes?.hashCode() ?: 0)
        result = 31 * result + (includes?.hashCode() ?: 0)
        result = 31 * result + (manifestConfig?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (options?.hashCode() ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        result = 31 * result + (taskArn?.hashCode() ?: 0)
        result = 31 * result + (taskReportConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateTaskRequest

        if (cloudWatchLogGroupArn != other.cloudWatchLogGroupArn) return false
        if (excludes != other.excludes) return false
        if (includes != other.includes) return false
        if (manifestConfig != other.manifestConfig) return false
        if (name != other.name) return false
        if (options != other.options) return false
        if (schedule != other.schedule) return false
        if (taskArn != other.taskArn) return false
        if (taskReportConfig != other.taskReportConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.UpdateTaskRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the Amazon Resource Name (ARN) of an Amazon CloudWatch log group for monitoring your task.
         *
         * For Enhanced mode tasks, you must use `/aws/datasync` as your log group name. For example:
         *
         * `arn:aws:logs:us-east-1:111222333444:log-group:/aws/datasync:*`
         *
         * For more information, see [Monitoring data transfers with CloudWatch Logs](https://docs.aws.amazon.com/datasync/latest/userguide/configure-logging.html).
         */
        public var cloudWatchLogGroupArn: kotlin.String? = null
        /**
         * Specifies exclude filters that define the files, objects, and folders in your source location that you don't want DataSync to transfer. For more information and examples, see [Specifying what DataSync transfers by using filters](https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html).
         */
        public var excludes: List<FilterRule>? = null
        /**
         * Specifies include filters define the files, objects, and folders in your source location that you want DataSync to transfer. For more information and examples, see [Specifying what DataSync transfers by using filters](https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html).
         */
        public var includes: List<FilterRule>? = null
        /**
         * Configures a manifest, which is a list of files or objects that you want DataSync to transfer. For more information and configuration examples, see [Specifying what DataSync transfers by using a manifest](https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html).
         *
         * When using this parameter, your caller identity (the IAM role that you're using DataSync with) must have the `iam:PassRole` permission. The [AWSDataSyncFullAccess](https://docs.aws.amazon.com/datasync/latest/userguide/security-iam-awsmanpol.html#security-iam-awsmanpol-awsdatasyncfullaccess) policy includes this permission.
         *
         * To remove a manifest configuration, specify this parameter as empty.
         */
        public var manifestConfig: aws.sdk.kotlin.services.datasync.model.ManifestConfig? = null
        /**
         * Specifies the name of your task.
         */
        public var name: kotlin.String? = null
        /**
         * Indicates how your transfer task is configured. These options include how DataSync handles files, objects, and their associated metadata during your transfer. You also can specify how to verify data integrity, set bandwidth limits for your task, among other options.
         *
         * Each option has a default value. Unless you need to, you don't have to configure any option before calling [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html).
         *
         * You also can override your task options for each task execution. For example, you might want to adjust the `LogLevel` for an individual execution.
         */
        public var options: aws.sdk.kotlin.services.datasync.model.Options? = null
        /**
         * Specifies a schedule for when you want your task to run. For more information, see [Scheduling your task](https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html).
         */
        public var schedule: aws.sdk.kotlin.services.datasync.model.TaskSchedule? = null
        /**
         * Specifies the ARN of the task that you want to update.
         */
        public var taskArn: kotlin.String? = null
        /**
         * Specifies how you want to configure a task report, which provides detailed information about your DataSync transfer. For more information, see [Monitoring your DataSync transfers with task reports](https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html).
         *
         * When using this parameter, your caller identity (the IAM role that you're using DataSync with) must have the `iam:PassRole` permission. The [AWSDataSyncFullAccess](https://docs.aws.amazon.com/datasync/latest/userguide/security-iam-awsmanpol.html#security-iam-awsmanpol-awsdatasyncfullaccess) policy includes this permission.
         *
         * To remove a task report configuration, specify this parameter as empty.
         */
        public var taskReportConfig: aws.sdk.kotlin.services.datasync.model.TaskReportConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.UpdateTaskRequest) : this() {
            this.cloudWatchLogGroupArn = x.cloudWatchLogGroupArn
            this.excludes = x.excludes
            this.includes = x.includes
            this.manifestConfig = x.manifestConfig
            this.name = x.name
            this.options = x.options
            this.schedule = x.schedule
            this.taskArn = x.taskArn
            this.taskReportConfig = x.taskReportConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.UpdateTaskRequest = UpdateTaskRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.ManifestConfig] inside the given [block]
         */
        public fun manifestConfig(block: aws.sdk.kotlin.services.datasync.model.ManifestConfig.Builder.() -> kotlin.Unit) {
            this.manifestConfig = aws.sdk.kotlin.services.datasync.model.ManifestConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.Options] inside the given [block]
         */
        public fun options(block: aws.sdk.kotlin.services.datasync.model.Options.Builder.() -> kotlin.Unit) {
            this.options = aws.sdk.kotlin.services.datasync.model.Options.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.TaskSchedule] inside the given [block]
         */
        public fun schedule(block: aws.sdk.kotlin.services.datasync.model.TaskSchedule.Builder.() -> kotlin.Unit) {
            this.schedule = aws.sdk.kotlin.services.datasync.model.TaskSchedule.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.TaskReportConfig] inside the given [block]
         */
        public fun taskReportConfig(block: aws.sdk.kotlin.services.datasync.model.TaskReportConfig.Builder.() -> kotlin.Unit) {
            this.taskReportConfig = aws.sdk.kotlin.services.datasync.model.TaskReportConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
