// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * You can use API filters to narrow down the list of resources returned by `ListTasks`. For example, to retrieve all tasks on a source location, you can use `ListTasks` with filter name `LocationId` and `Operator Equals` with the ARN for the location.
 *
 * For more information, see [filtering DataSync resources](https://docs.aws.amazon.com/datasync/latest/userguide/query-resources.html).
 */
public class TaskFilter private constructor(builder: Builder) {
    /**
     * The name of the filter being used. Each API call supports a list of filters that are available for it. For example, `LocationId` for `ListTasks`.
     */
    public val name: aws.sdk.kotlin.services.datasync.model.TaskFilterName = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The operator that is used to compare filter values (for example, `Equals` or `Contains`).
     */
    public val operator: aws.sdk.kotlin.services.datasync.model.Operator = requireNotNull(builder.operator) { "A non-null value must be provided for operator" }
    /**
     * The values that you want to filter for. For example, you might want to display only tasks for a specific destination location.
     */
    public val values: List<String> = requireNotNull(builder.values) { "A non-null value must be provided for values" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.TaskFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TaskFilter(")
        append("name=$name,")
        append("operator=$operator,")
        append("values=$values")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name.hashCode()
        result = 31 * result + (operator.hashCode())
        result = 31 * result + (values.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TaskFilter

        if (name != other.name) return false
        if (operator != other.operator) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.TaskFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the filter being used. Each API call supports a list of filters that are available for it. For example, `LocationId` for `ListTasks`.
         */
        public var name: aws.sdk.kotlin.services.datasync.model.TaskFilterName? = null
        /**
         * The operator that is used to compare filter values (for example, `Equals` or `Contains`).
         */
        public var operator: aws.sdk.kotlin.services.datasync.model.Operator? = null
        /**
         * The values that you want to filter for. For example, you might want to display only tasks for a specific destination location.
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.TaskFilter) : this() {
            this.name = x.name
            this.operator = x.operator
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.TaskFilter = TaskFilter(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = TaskFilterName.SdkUnknown("no value provided")
            if (operator == null) operator = Operator.SdkUnknown("no value provided")
            if (values == null) values = emptyList()
            return this
        }
    }
}
