// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides detailed information about the result of your DataSync task execution.
 */
public class TaskExecutionResultDetail private constructor(builder: Builder) {
    /**
     * An error that DataSync encountered during your task execution. You can use this information to help [troubleshoot issues](https://docs.aws.amazon.com/datasync/latest/userguide/troubleshooting-datasync-locations-tasks.html).
     */
    public val errorCode: kotlin.String? = builder.errorCode
    /**
     * The detailed description of an error that DataSync encountered during your task execution. You can use this information to help [troubleshoot issues](https://docs.aws.amazon.com/datasync/latest/userguide/troubleshooting-datasync-locations-tasks.html).
     */
    public val errorDetail: kotlin.String? = builder.errorDetail
    /**
     * The time in milliseconds that your task execution was in the `PREPARING` step. For more information, see [Task execution statuses](https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#understand-task-execution-statuses).
     *
     * For Enhanced mode tasks, the value is always `0`. For more information, see [How DataSync prepares your data transfer](https://docs.aws.amazon.com/datasync/latest/userguide/how-datasync-transfer-works.html#how-datasync-prepares).
     */
    public val prepareDuration: kotlin.Long? = builder.prepareDuration
    /**
     * The status of the `PREPARING` step for your task execution. For more information, see [Task execution statuses](https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#understand-task-execution-statuses).
     */
    public val prepareStatus: aws.sdk.kotlin.services.datasync.model.PhaseStatus? = builder.prepareStatus
    /**
     * The time in milliseconds that your task execution ran.
     */
    public val totalDuration: kotlin.Long? = builder.totalDuration
    /**
     * The time in milliseconds that your task execution was in the `TRANSFERRING` step. For more information, see [Task execution statuses](https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#understand-task-execution-statuses).
     *
     * For Enhanced mode tasks, the value is always `0`. For more information, see [How DataSync transfers your data](https://docs.aws.amazon.com/datasync/latest/userguide/how-datasync-transfer-works.html#how-datasync-transfers).
     */
    public val transferDuration: kotlin.Long? = builder.transferDuration
    /**
     * The status of the `TRANSFERRING` step for your task execution. For more information, see [Task execution statuses](https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#understand-task-execution-statuses).
     */
    public val transferStatus: aws.sdk.kotlin.services.datasync.model.PhaseStatus? = builder.transferStatus
    /**
     * The time in milliseconds that your task execution was in the `VERIFYING` step. For more information, see [Task execution statuses](https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#understand-task-execution-statuses).
     *
     * For Enhanced mode tasks, the value is always `0`. For more information, see [How DataSync verifies your data's integrity](https://docs.aws.amazon.com/datasync/latest/userguide/how-datasync-transfer-works.html#how-verifying-works).
     */
    public val verifyDuration: kotlin.Long? = builder.verifyDuration
    /**
     * The status of the `VERIFYING` step for your task execution. For more information, see [Task execution statuses](https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#understand-task-execution-statuses).
     */
    public val verifyStatus: aws.sdk.kotlin.services.datasync.model.PhaseStatus? = builder.verifyStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.TaskExecutionResultDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TaskExecutionResultDetail(")
        append("errorCode=$errorCode,")
        append("errorDetail=$errorDetail,")
        append("prepareDuration=$prepareDuration,")
        append("prepareStatus=$prepareStatus,")
        append("totalDuration=$totalDuration,")
        append("transferDuration=$transferDuration,")
        append("transferStatus=$transferStatus,")
        append("verifyDuration=$verifyDuration,")
        append("verifyStatus=$verifyStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = errorCode?.hashCode() ?: 0
        result = 31 * result + (errorDetail?.hashCode() ?: 0)
        result = 31 * result + (prepareDuration?.hashCode() ?: 0)
        result = 31 * result + (prepareStatus?.hashCode() ?: 0)
        result = 31 * result + (totalDuration?.hashCode() ?: 0)
        result = 31 * result + (transferDuration?.hashCode() ?: 0)
        result = 31 * result + (transferStatus?.hashCode() ?: 0)
        result = 31 * result + (verifyDuration?.hashCode() ?: 0)
        result = 31 * result + (verifyStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TaskExecutionResultDetail

        if (errorCode != other.errorCode) return false
        if (errorDetail != other.errorDetail) return false
        if (prepareDuration != other.prepareDuration) return false
        if (prepareStatus != other.prepareStatus) return false
        if (totalDuration != other.totalDuration) return false
        if (transferDuration != other.transferDuration) return false
        if (transferStatus != other.transferStatus) return false
        if (verifyDuration != other.verifyDuration) return false
        if (verifyStatus != other.verifyStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.TaskExecutionResultDetail = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An error that DataSync encountered during your task execution. You can use this information to help [troubleshoot issues](https://docs.aws.amazon.com/datasync/latest/userguide/troubleshooting-datasync-locations-tasks.html).
         */
        public var errorCode: kotlin.String? = null
        /**
         * The detailed description of an error that DataSync encountered during your task execution. You can use this information to help [troubleshoot issues](https://docs.aws.amazon.com/datasync/latest/userguide/troubleshooting-datasync-locations-tasks.html).
         */
        public var errorDetail: kotlin.String? = null
        /**
         * The time in milliseconds that your task execution was in the `PREPARING` step. For more information, see [Task execution statuses](https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#understand-task-execution-statuses).
         *
         * For Enhanced mode tasks, the value is always `0`. For more information, see [How DataSync prepares your data transfer](https://docs.aws.amazon.com/datasync/latest/userguide/how-datasync-transfer-works.html#how-datasync-prepares).
         */
        public var prepareDuration: kotlin.Long? = null
        /**
         * The status of the `PREPARING` step for your task execution. For more information, see [Task execution statuses](https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#understand-task-execution-statuses).
         */
        public var prepareStatus: aws.sdk.kotlin.services.datasync.model.PhaseStatus? = null
        /**
         * The time in milliseconds that your task execution ran.
         */
        public var totalDuration: kotlin.Long? = null
        /**
         * The time in milliseconds that your task execution was in the `TRANSFERRING` step. For more information, see [Task execution statuses](https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#understand-task-execution-statuses).
         *
         * For Enhanced mode tasks, the value is always `0`. For more information, see [How DataSync transfers your data](https://docs.aws.amazon.com/datasync/latest/userguide/how-datasync-transfer-works.html#how-datasync-transfers).
         */
        public var transferDuration: kotlin.Long? = null
        /**
         * The status of the `TRANSFERRING` step for your task execution. For more information, see [Task execution statuses](https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#understand-task-execution-statuses).
         */
        public var transferStatus: aws.sdk.kotlin.services.datasync.model.PhaseStatus? = null
        /**
         * The time in milliseconds that your task execution was in the `VERIFYING` step. For more information, see [Task execution statuses](https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#understand-task-execution-statuses).
         *
         * For Enhanced mode tasks, the value is always `0`. For more information, see [How DataSync verifies your data's integrity](https://docs.aws.amazon.com/datasync/latest/userguide/how-datasync-transfer-works.html#how-verifying-works).
         */
        public var verifyDuration: kotlin.Long? = null
        /**
         * The status of the `VERIFYING` step for your task execution. For more information, see [Task execution statuses](https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#understand-task-execution-statuses).
         */
        public var verifyStatus: aws.sdk.kotlin.services.datasync.model.PhaseStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.TaskExecutionResultDetail) : this() {
            this.errorCode = x.errorCode
            this.errorDetail = x.errorDetail
            this.prepareDuration = x.prepareDuration
            this.prepareStatus = x.prepareStatus
            this.totalDuration = x.totalDuration
            this.transferDuration = x.transferDuration
            this.transferStatus = x.transferStatus
            this.verifyDuration = x.verifyDuration
            this.verifyStatus = x.verifyStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.TaskExecutionResultDetail = TaskExecutionResultDetail(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
