// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The number of objects that DataSync finds at your locations.
 *
 * Applies only to [Enhanced mode tasks](https://docs.aws.amazon.com/datasync/latest/userguide/choosing-task-mode.html).
 */
public class TaskExecutionFilesListedDetail private constructor(builder: Builder) {
    /**
     * The number of objects that DataSync finds at your destination location. This metric is only applicable if you [configure your task](https://docs.aws.amazon.com/datasync/latest/userguide/configure-metadata.html#task-option-file-object-handling) to delete data in the destination that isn't in the source.
     */
    public val atDestinationForDelete: kotlin.Long = builder.atDestinationForDelete
    /**
     * The number of objects that DataSync finds at your source location.
     * + With a [manifest](https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html), DataSync lists only what's in your manifest (and not everything at your source location).
     * + With an include [filter](https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html), DataSync lists only what matches the filter at your source location.
     * + With an exclude filter, DataSync lists everything at your source location before applying the filter.
     */
    public val atSource: kotlin.Long = builder.atSource

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.TaskExecutionFilesListedDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TaskExecutionFilesListedDetail(")
        append("atDestinationForDelete=$atDestinationForDelete,")
        append("atSource=$atSource")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = atDestinationForDelete.hashCode()
        result = 31 * result + (atSource.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TaskExecutionFilesListedDetail

        if (atDestinationForDelete != other.atDestinationForDelete) return false
        if (atSource != other.atSource) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.TaskExecutionFilesListedDetail = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of objects that DataSync finds at your destination location. This metric is only applicable if you [configure your task](https://docs.aws.amazon.com/datasync/latest/userguide/configure-metadata.html#task-option-file-object-handling) to delete data in the destination that isn't in the source.
         */
        public var atDestinationForDelete: kotlin.Long = 0L
        /**
         * The number of objects that DataSync finds at your source location.
         * + With a [manifest](https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html), DataSync lists only what's in your manifest (and not everything at your source location).
         * + With an include [filter](https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html), DataSync lists only what matches the filter at your source location.
         * + With an exclude filter, DataSync lists everything at your source location before applying the filter.
         */
        public var atSource: kotlin.Long = 0L

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.TaskExecutionFilesListedDetail) : this() {
            this.atDestinationForDelete = x.atDestinationForDelete
            this.atSource = x.atSource
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.TaskExecutionFilesListedDetail = TaskExecutionFilesListedDetail(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
