// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the version of the Server Message Block (SMB) protocol that DataSync uses to access an SMB file server.
 */
public class SmbMountOptions private constructor(builder: Builder) {
    /**
     * By default, DataSync automatically chooses an SMB protocol version based on negotiation with your SMB file server. You also can configure DataSync to use a specific SMB version, but we recommend doing this only if DataSync has trouble negotiating with the SMB file server automatically.
     *
     * These are the following options for configuring the SMB version:
     * + `AUTOMATIC` (default): DataSync and the SMB file server negotiate the highest version of SMB that they mutually support between 2.1 and 3.1.1.This is the recommended option. If you instead choose a specific version that your file server doesn't support, you may get an `Operation Not Supported` error.
     * + `SMB3`: Restricts the protocol negotiation to only SMB version 3.0.2.
     * + `SMB2`: Restricts the protocol negotiation to only SMB version 2.1.
     * + `SMB2_0`: Restricts the protocol negotiation to only SMB version 2.0.
     * + `SMB1`: Restricts the protocol negotiation to only SMB version 1.0.The `SMB1` option isn't available when [creating an Amazon FSx for NetApp ONTAP location](https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateLocationFsxOntap.html).
     */
    public val version: aws.sdk.kotlin.services.datasync.model.SmbVersion? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.SmbMountOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SmbMountOptions(")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = version?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SmbMountOptions

        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.SmbMountOptions = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * By default, DataSync automatically chooses an SMB protocol version based on negotiation with your SMB file server. You also can configure DataSync to use a specific SMB version, but we recommend doing this only if DataSync has trouble negotiating with the SMB file server automatically.
         *
         * These are the following options for configuring the SMB version:
         * + `AUTOMATIC` (default): DataSync and the SMB file server negotiate the highest version of SMB that they mutually support between 2.1 and 3.1.1.This is the recommended option. If you instead choose a specific version that your file server doesn't support, you may get an `Operation Not Supported` error.
         * + `SMB3`: Restricts the protocol negotiation to only SMB version 3.0.2.
         * + `SMB2`: Restricts the protocol negotiation to only SMB version 2.1.
         * + `SMB2_0`: Restricts the protocol negotiation to only SMB version 2.0.
         * + `SMB1`: Restricts the protocol negotiation to only SMB version 1.0.The `SMB1` option isn't available when [creating an Amazon FSx for NetApp ONTAP location](https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateLocationFsxOntap.html).
         */
        public var version: aws.sdk.kotlin.services.datasync.model.SmbVersion? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.SmbMountOptions) : this() {
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.SmbMountOptions = SmbMountOptions(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
