// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The details about an Amazon Web Services storage service that DataSync Discovery recommends for a resource in your on-premises storage system.
 *
 * For more information, see [Recommendations provided by DataSync Discovery](https://docs.aws.amazon.com/datasync/latest/userguide/discovery-understand-recommendations.html).
 */
public class Recommendation private constructor(builder: Builder) {
    /**
     * The estimated monthly cost of the recommended Amazon Web Services storage service.
     */
    public val estimatedMonthlyStorageCost: kotlin.String? = builder.estimatedMonthlyStorageCost
    /**
     * Information about how you can set up a recommended Amazon Web Services storage service.
     */
    public val storageConfiguration: Map<String, String>? = builder.storageConfiguration
    /**
     * A recommended Amazon Web Services storage service that you can migrate data to based on information that DataSync Discovery collects about your on-premises storage system.
     */
    public val storageType: kotlin.String? = builder.storageType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.Recommendation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Recommendation(")
        append("estimatedMonthlyStorageCost=$estimatedMonthlyStorageCost,")
        append("storageConfiguration=$storageConfiguration,")
        append("storageType=$storageType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = estimatedMonthlyStorageCost?.hashCode() ?: 0
        result = 31 * result + (storageConfiguration?.hashCode() ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Recommendation

        if (estimatedMonthlyStorageCost != other.estimatedMonthlyStorageCost) return false
        if (storageConfiguration != other.storageConfiguration) return false
        if (storageType != other.storageType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.Recommendation = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The estimated monthly cost of the recommended Amazon Web Services storage service.
         */
        public var estimatedMonthlyStorageCost: kotlin.String? = null
        /**
         * Information about how you can set up a recommended Amazon Web Services storage service.
         */
        public var storageConfiguration: Map<String, String>? = null
        /**
         * A recommended Amazon Web Services storage service that you can migrate data to based on information that DataSync Discovery collects about your on-premises storage system.
         */
        public var storageType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.Recommendation) : this() {
            this.estimatedMonthlyStorageCost = x.estimatedMonthlyStorageCost
            this.storageConfiguration = x.storageConfiguration
            this.storageType = x.storageType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.Recommendation = Recommendation(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
