// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies how your DataSync agent connects to Amazon Web Services using a [virtual private cloud (VPC) service endpoint](https://docs.aws.amazon.com/datasync/latest/userguide/choose-service-endpoint.html#choose-service-endpoint-vpc). An agent that uses a VPC endpoint isn't accessible over the public internet.
 */
public class PrivateLinkConfig private constructor(builder: Builder) {
    /**
     * Specifies the VPC endpoint provided by [Amazon Web Services PrivateLink](https://docs.aws.amazon.com/vpc/latest/privatelink/privatelink-share-your-services.html) that your agent connects to.
     */
    public val privateLinkEndpoint: kotlin.String? = builder.privateLinkEndpoint
    /**
     * Specifies the Amazon Resource Names (ARN) of the security group that provides DataSync access to your VPC endpoint. You can only specify one ARN.
     */
    public val securityGroupArns: List<String>? = builder.securityGroupArns
    /**
     * Specifies the ARN of the subnet where your VPC endpoint is located. You can only specify one ARN.
     */
    public val subnetArns: List<String>? = builder.subnetArns
    /**
     * Specifies the ID of the VPC endpoint that your agent connects to.
     */
    public val vpcEndpointId: kotlin.String? = builder.vpcEndpointId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.PrivateLinkConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PrivateLinkConfig(")
        append("privateLinkEndpoint=$privateLinkEndpoint,")
        append("securityGroupArns=$securityGroupArns,")
        append("subnetArns=$subnetArns,")
        append("vpcEndpointId=$vpcEndpointId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = privateLinkEndpoint?.hashCode() ?: 0
        result = 31 * result + (securityGroupArns?.hashCode() ?: 0)
        result = 31 * result + (subnetArns?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpointId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PrivateLinkConfig

        if (privateLinkEndpoint != other.privateLinkEndpoint) return false
        if (securityGroupArns != other.securityGroupArns) return false
        if (subnetArns != other.subnetArns) return false
        if (vpcEndpointId != other.vpcEndpointId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.PrivateLinkConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the VPC endpoint provided by [Amazon Web Services PrivateLink](https://docs.aws.amazon.com/vpc/latest/privatelink/privatelink-share-your-services.html) that your agent connects to.
         */
        public var privateLinkEndpoint: kotlin.String? = null
        /**
         * Specifies the Amazon Resource Names (ARN) of the security group that provides DataSync access to your VPC endpoint. You can only specify one ARN.
         */
        public var securityGroupArns: List<String>? = null
        /**
         * Specifies the ARN of the subnet where your VPC endpoint is located. You can only specify one ARN.
         */
        public var subnetArns: List<String>? = null
        /**
         * Specifies the ID of the VPC endpoint that your agent connects to.
         */
        public var vpcEndpointId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.PrivateLinkConfig) : this() {
            this.privateLinkEndpoint = x.privateLinkEndpoint
            this.securityGroupArns = x.securityGroupArns
            this.subnetArns = x.subnetArns
            this.vpcEndpointId = x.vpcEndpointId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.PrivateLinkConfig = PrivateLinkConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
