// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateLocationFsxOntapRequest private constructor(builder: Builder) {
    /**
     * Specifies the data transfer protocol that DataSync uses to access your Amazon FSx file system.
     */
    public val protocol: aws.sdk.kotlin.services.datasync.model.FsxProtocol? = builder.protocol
    /**
     * Specifies the Amazon EC2 security groups that provide access to your file system's preferred subnet.
     *
     * The security groups must allow outbound traffic on the following ports (depending on the protocol you use):
     * + **Network File System (NFS)**: TCP ports 111, 635, and 2049
     * + **Server Message Block (SMB)**: TCP port 445
     *
     * Your file system's security groups must also allow inbound traffic on the same ports.
     */
    public val securityGroupArns: List<String>? = builder.securityGroupArns
    /**
     * Specifies the ARN of the storage virtual machine (SVM) in your file system where you want to copy data to or from.
     */
    public val storageVirtualMachineArn: kotlin.String? = builder.storageVirtualMachineArn
    /**
     * Specifies a path to the file share in the SVM where you'll copy your data.
     *
     * You can specify a junction path (also known as a mount point), qtree path (for NFS file shares), or share name (for SMB file shares). For example, your mount path might be `/vol1`, `/vol1/tree1`, or `/share1`.
     *
     * Don't specify a junction path in the SVM's root volume. For more information, see [Managing FSx for ONTAP storage virtual machines](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html) in the *Amazon FSx for NetApp ONTAP User Guide*.
     */
    public val subdirectory: kotlin.String? = builder.subdirectory
    /**
     * Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We recommend creating at least a name tag for your location.
     */
    public val tags: List<TagListEntry>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.CreateLocationFsxOntapRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateLocationFsxOntapRequest(")
        append("protocol=$protocol,")
        append("securityGroupArns=$securityGroupArns,")
        append("storageVirtualMachineArn=$storageVirtualMachineArn,")
        append("subdirectory=$subdirectory,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = protocol?.hashCode() ?: 0
        result = 31 * result + (securityGroupArns?.hashCode() ?: 0)
        result = 31 * result + (storageVirtualMachineArn?.hashCode() ?: 0)
        result = 31 * result + (subdirectory?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateLocationFsxOntapRequest

        if (protocol != other.protocol) return false
        if (securityGroupArns != other.securityGroupArns) return false
        if (storageVirtualMachineArn != other.storageVirtualMachineArn) return false
        if (subdirectory != other.subdirectory) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.CreateLocationFsxOntapRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the data transfer protocol that DataSync uses to access your Amazon FSx file system.
         */
        public var protocol: aws.sdk.kotlin.services.datasync.model.FsxProtocol? = null
        /**
         * Specifies the Amazon EC2 security groups that provide access to your file system's preferred subnet.
         *
         * The security groups must allow outbound traffic on the following ports (depending on the protocol you use):
         * + **Network File System (NFS)**: TCP ports 111, 635, and 2049
         * + **Server Message Block (SMB)**: TCP port 445
         *
         * Your file system's security groups must also allow inbound traffic on the same ports.
         */
        public var securityGroupArns: List<String>? = null
        /**
         * Specifies the ARN of the storage virtual machine (SVM) in your file system where you want to copy data to or from.
         */
        public var storageVirtualMachineArn: kotlin.String? = null
        /**
         * Specifies a path to the file share in the SVM where you'll copy your data.
         *
         * You can specify a junction path (also known as a mount point), qtree path (for NFS file shares), or share name (for SMB file shares). For example, your mount path might be `/vol1`, `/vol1/tree1`, or `/share1`.
         *
         * Don't specify a junction path in the SVM's root volume. For more information, see [Managing FSx for ONTAP storage virtual machines](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html) in the *Amazon FSx for NetApp ONTAP User Guide*.
         */
        public var subdirectory: kotlin.String? = null
        /**
         * Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We recommend creating at least a name tag for your location.
         */
        public var tags: List<TagListEntry>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.CreateLocationFsxOntapRequest) : this() {
            this.protocol = x.protocol
            this.securityGroupArns = x.securityGroupArns
            this.storageVirtualMachineArn = x.storageVirtualMachineArn
            this.subdirectory = x.subdirectory
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.CreateLocationFsxOntapRequest = CreateLocationFsxOntapRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.FsxProtocol] inside the given [block]
         */
        public fun protocol(block: aws.sdk.kotlin.services.datasync.model.FsxProtocol.Builder.() -> kotlin.Unit) {
            this.protocol = aws.sdk.kotlin.services.datasync.model.FsxProtocol.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
