// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * CreateAgentRequest
 */
public class CreateAgentRequest private constructor(builder: Builder) {
    /**
     * Specifies your DataSync agent's activation key. If you don't have an activation key, see [Activating your agent](https://docs.aws.amazon.com/datasync/latest/userguide/activate-agent.html).
     */
    public val activationKey: kotlin.String? = builder.activationKey
    /**
     * Specifies a name for your agent. We recommend specifying a name that you can remember.
     */
    public val agentName: kotlin.String? = builder.agentName
    /**
     * Specifies the Amazon Resource Name (ARN) of the security group that allows traffic between your agent and VPC service endpoint. You can only specify one ARN.
     */
    public val securityGroupArns: List<String>? = builder.securityGroupArns
    /**
     * Specifies the ARN of the subnet where your VPC service endpoint is located. You can only specify one ARN.
     */
    public val subnetArns: List<String>? = builder.subnetArns
    /**
     * Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We recommend creating at least one tag for your agent.
     */
    public val tags: List<TagListEntry>? = builder.tags
    /**
     * Specifies the ID of the [VPC service endpoint](https://docs.aws.amazon.com/datasync/latest/userguide/choose-service-endpoint.html#datasync-in-vpc) that you're using. For example, a VPC endpoint ID looks like `vpce-01234d5aff67890e1`.
     *
     * The VPC service endpoint you use must include the DataSync service name (for example, `com.amazonaws.us-east-2.datasync`).
     */
    public val vpcEndpointId: kotlin.String? = builder.vpcEndpointId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.CreateAgentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAgentRequest(")
        append("activationKey=$activationKey,")
        append("agentName=$agentName,")
        append("securityGroupArns=$securityGroupArns,")
        append("subnetArns=$subnetArns,")
        append("tags=$tags,")
        append("vpcEndpointId=$vpcEndpointId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activationKey?.hashCode() ?: 0
        result = 31 * result + (agentName?.hashCode() ?: 0)
        result = 31 * result + (securityGroupArns?.hashCode() ?: 0)
        result = 31 * result + (subnetArns?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpointId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAgentRequest

        if (activationKey != other.activationKey) return false
        if (agentName != other.agentName) return false
        if (securityGroupArns != other.securityGroupArns) return false
        if (subnetArns != other.subnetArns) return false
        if (tags != other.tags) return false
        if (vpcEndpointId != other.vpcEndpointId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.CreateAgentRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies your DataSync agent's activation key. If you don't have an activation key, see [Activating your agent](https://docs.aws.amazon.com/datasync/latest/userguide/activate-agent.html).
         */
        public var activationKey: kotlin.String? = null
        /**
         * Specifies a name for your agent. We recommend specifying a name that you can remember.
         */
        public var agentName: kotlin.String? = null
        /**
         * Specifies the Amazon Resource Name (ARN) of the security group that allows traffic between your agent and VPC service endpoint. You can only specify one ARN.
         */
        public var securityGroupArns: List<String>? = null
        /**
         * Specifies the ARN of the subnet where your VPC service endpoint is located. You can only specify one ARN.
         */
        public var subnetArns: List<String>? = null
        /**
         * Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We recommend creating at least one tag for your agent.
         */
        public var tags: List<TagListEntry>? = null
        /**
         * Specifies the ID of the [VPC service endpoint](https://docs.aws.amazon.com/datasync/latest/userguide/choose-service-endpoint.html#datasync-in-vpc) that you're using. For example, a VPC endpoint ID looks like `vpce-01234d5aff67890e1`.
         *
         * The VPC service endpoint you use must include the DataSync service name (for example, `com.amazonaws.us-east-2.datasync`).
         */
        public var vpcEndpointId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.CreateAgentRequest) : this() {
            this.activationKey = x.activationKey
            this.agentName = x.agentName
            this.securityGroupArns = x.securityGroupArns
            this.subnetArns = x.subnetArns
            this.tags = x.tags
            this.vpcEndpointId = x.vpcEndpointId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.CreateAgentRequest = CreateAgentRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
