// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.serde

import aws.sdk.kotlin.services.datasync.model.ObjectStorageServerProtocol
import aws.sdk.kotlin.services.datasync.model.UpdateLocationObjectStorageRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.encodeBase64String


internal class UpdateLocationObjectStorageOperationSerializer: HttpSerializer.NonStreaming<UpdateLocationObjectStorageRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateLocationObjectStorageRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeUpdateLocationObjectStorageOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeUpdateLocationObjectStorageOperationBody(context: ExecutionContext, input: UpdateLocationObjectStorageRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACCESSKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AccessKey"))
    val AGENTARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AgentArns"))
    val LOCATIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LocationArn"))
    val SECRETKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SecretKey"))
    val SERVERCERTIFICATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Blob, JsonSerialName("ServerCertificate"))
    val SERVERPORT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("ServerPort"))
    val SERVERPROTOCOL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ServerProtocol"))
    val SUBDIRECTORY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Subdirectory"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCESSKEY_DESCRIPTOR)
        field(AGENTARNS_DESCRIPTOR)
        field(LOCATIONARN_DESCRIPTOR)
        field(SECRETKEY_DESCRIPTOR)
        field(SERVERCERTIFICATE_DESCRIPTOR)
        field(SERVERPORT_DESCRIPTOR)
        field(SERVERPROTOCOL_DESCRIPTOR)
        field(SUBDIRECTORY_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.accessKey?.let { field(ACCESSKEY_DESCRIPTOR, it) }
        if (input.agentArns != null) {
            listField(AGENTARNS_DESCRIPTOR) {
                for (el0 in input.agentArns) {
                    serializeString(el0)
                }
            }
        }
        input.locationArn?.let { field(LOCATIONARN_DESCRIPTOR, it) }
        input.secretKey?.let { field(SECRETKEY_DESCRIPTOR, it) }
        input.serverCertificate?.let { field(SERVERCERTIFICATE_DESCRIPTOR, it.encodeBase64String()) }
        input.serverPort?.let { field(SERVERPORT_DESCRIPTOR, it) }
        input.serverProtocol?.let { field(SERVERPROTOCOL_DESCRIPTOR, it.value) }
        input.subdirectory?.let { field(SUBDIRECTORY_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
