// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.serde

import aws.sdk.kotlin.services.datasync.model.DataSyncException
import aws.sdk.kotlin.services.datasync.model.DescribeStorageSystemResponse
import aws.sdk.kotlin.services.datasync.model.DiscoveryServerConfiguration
import aws.sdk.kotlin.services.datasync.model.DiscoverySystemType
import aws.sdk.kotlin.services.datasync.model.StorageSystemConnectivityStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class DescribeStorageSystemOperationDeserializer: HttpDeserializer.NonStreaming<DescribeStorageSystemResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeStorageSystemResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeStorageSystemError(context, call, payload)
        }
        val builder = DescribeStorageSystemResponse.Builder()

        if (payload != null) {
            deserializeDescribeStorageSystemOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeStorageSystemError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DataSyncException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> DataSyncException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeStorageSystemOperationBody(builder: DescribeStorageSystemResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AGENTARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AgentArns"))
    val CLOUDWATCHLOGGROUPARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CloudWatchLogGroupArn"))
    val CONNECTIVITYSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ConnectivityStatus"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val ERRORMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ErrorMessage"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val SECRETSMANAGERARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SecretsManagerArn"))
    val SERVERCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ServerConfiguration"))
    val STORAGESYSTEMARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StorageSystemArn"))
    val SYSTEMTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("SystemType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AGENTARNS_DESCRIPTOR)
        field(CLOUDWATCHLOGGROUPARN_DESCRIPTOR)
        field(CONNECTIVITYSTATUS_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(ERRORMESSAGE_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(SECRETSMANAGERARN_DESCRIPTOR)
        field(SERVERCONFIGURATION_DESCRIPTOR)
        field(STORAGESYSTEMARN_DESCRIPTOR)
        field(SYSTEMTYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AGENTARNS_DESCRIPTOR.index -> builder.agentArns =
                    deserializer.deserializeList(AGENTARNS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CLOUDWATCHLOGGROUPARN_DESCRIPTOR.index -> builder.cloudWatchLogGroupArn = deserializeString()
                CONNECTIVITYSTATUS_DESCRIPTOR.index -> builder.connectivityStatus = deserializeString().let { StorageSystemConnectivityStatus.fromValue(it) }
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                ERRORMESSAGE_DESCRIPTOR.index -> builder.errorMessage = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                SECRETSMANAGERARN_DESCRIPTOR.index -> builder.secretsManagerArn = deserializeString()
                SERVERCONFIGURATION_DESCRIPTOR.index -> builder.serverConfiguration = deserializeDiscoveryServerConfigurationDocument(deserializer)
                STORAGESYSTEMARN_DESCRIPTOR.index -> builder.storageSystemArn = deserializeString()
                SYSTEMTYPE_DESCRIPTOR.index -> builder.systemType = deserializeString().let { DiscoverySystemType.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
