// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Configures your DataSync task to run on a [schedule](https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html) (at a minimum interval of 1 hour).
 */
public class TaskSchedule private constructor(builder: Builder) {
    /**
     * Specifies your task schedule by using a cron or rate expression.
     *
     * Use cron expressions for task schedules that run on a specific time and day. For example, the following cron expression creates a task schedule that runs at 8 AM on the first Wednesday of every month:
     *
     * `cron(0 8 * * 3#1)`
     *
     * Use rate expressions for task schedules that run on a regular interval. For example, the following rate expression creates a task schedule that runs every 12 hours:
     *
     * `rate(12 hours)`
     *
     * For information about cron and rate expression syntax, see the *Amazon EventBridge User Guide*[](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-scheduled-rule-pattern.html).
     */
    public val scheduleExpression: kotlin.String = requireNotNull(builder.scheduleExpression) { "A non-null value must be provided for scheduleExpression" }
    /**
     * Specifies whether to enable or disable your task schedule. Your schedule is enabled by default, but there can be situations where you need to disable it. For example, you might need to pause a recurring transfer to fix an issue with your task or perform maintenance on your storage system.
     *
     * DataSync might disable your schedule automatically if your task fails repeatedly with the same error. For more information, see [TaskScheduleDetails](https://docs.aws.amazon.com/datasync/latest/userguide/API_TaskScheduleDetails.html).
     */
    public val status: aws.sdk.kotlin.services.datasync.model.ScheduleStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.TaskSchedule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TaskSchedule(")
        append("scheduleExpression=$scheduleExpression,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = scheduleExpression.hashCode()
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TaskSchedule

        if (scheduleExpression != other.scheduleExpression) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.TaskSchedule = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies your task schedule by using a cron or rate expression.
         *
         * Use cron expressions for task schedules that run on a specific time and day. For example, the following cron expression creates a task schedule that runs at 8 AM on the first Wednesday of every month:
         *
         * `cron(0 8 * * 3#1)`
         *
         * Use rate expressions for task schedules that run on a regular interval. For example, the following rate expression creates a task schedule that runs every 12 hours:
         *
         * `rate(12 hours)`
         *
         * For information about cron and rate expression syntax, see the *Amazon EventBridge User Guide*[](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-scheduled-rule-pattern.html).
         */
        public var scheduleExpression: kotlin.String? = null
        /**
         * Specifies whether to enable or disable your task schedule. Your schedule is enabled by default, but there can be situations where you need to disable it. For example, you might need to pause a recurring transfer to fix an issue with your task or perform maintenance on your storage system.
         *
         * DataSync might disable your schedule automatically if your task fails repeatedly with the same error. For more information, see [TaskScheduleDetails](https://docs.aws.amazon.com/datasync/latest/userguide/API_TaskScheduleDetails.html).
         */
        public var status: aws.sdk.kotlin.services.datasync.model.ScheduleStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.TaskSchedule) : this() {
            this.scheduleExpression = x.scheduleExpression
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.TaskSchedule = TaskSchedule(this)

        internal fun correctErrors(): Builder {
            if (scheduleExpression == null) scheduleExpression = ""
            return this
        }
    }
}
