// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * StartTaskExecutionRequest
 */
public class StartTaskExecutionRequest private constructor(builder: Builder) {
    /**
     * Specifies a list of filter rules that determines which files to exclude from a task. The list contains a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example, `"/folder1|/folder2"`.
     */
    public val excludes: List<FilterRule>? = builder.excludes
    /**
     * Specifies a list of filter rules that determines which files to include when running a task. The pattern should contain a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example, `"/folder1|/folder2"`.
     */
    public val includes: List<FilterRule>? = builder.includes
    /**
     * Configures a manifest, which is a list of files or objects that you want DataSync to transfer. For more information and configuration examples, see [Specifying what DataSync transfers by using a manifest](https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html).
     *
     * When using this parameter, your caller identity (the role that you're using DataSync with) must have the `iam:PassRole` permission. The [AWSDataSyncFullAccess](https://docs.aws.amazon.com/datasync/latest/userguide/security-iam-awsmanpol.html#security-iam-awsmanpol-awsdatasyncfullaccess) policy includes this permission.
     *
     * To remove a manifest configuration, specify this parameter with an empty value.
     */
    public val manifestConfig: aws.sdk.kotlin.services.datasync.model.ManifestConfig? = builder.manifestConfig
    /**
     * Indicates how your transfer task is configured. These options include how DataSync handles files, objects, and their associated metadata during your transfer. You also can specify how to verify data integrity, set bandwidth limits for your task, among other options.
     *
     * Each option has a default value. Unless you need to, you don't have to configure any option before calling [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html).
     *
     * You also can override your task options for each task execution. For example, you might want to adjust the `LogLevel` for an individual execution.
     */
    public val overrideOptions: aws.sdk.kotlin.services.datasync.model.Options? = builder.overrideOptions
    /**
     * Specifies the tags that you want to apply to the Amazon Resource Name (ARN) representing the task execution.
     *
     * *Tags* are key-value pairs that help you manage, filter, and search for your DataSync resources.
     */
    public val tags: List<TagListEntry>? = builder.tags
    /**
     * Specifies the Amazon Resource Name (ARN) of the task that you want to start.
     */
    public val taskArn: kotlin.String? = builder.taskArn
    /**
     * Specifies how you want to configure a task report, which provides detailed information about your DataSync transfer. For more information, see [Monitoring your DataSync transfers with task reports](https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html).
     *
     * When using this parameter, your caller identity (the role that you're using DataSync with) must have the `iam:PassRole` permission. The [AWSDataSyncFullAccess](https://docs.aws.amazon.com/datasync/latest/userguide/security-iam-awsmanpol.html#security-iam-awsmanpol-awsdatasyncfullaccess) policy includes this permission.
     *
     * To remove a task report configuration, specify this parameter as empty.
     */
    public val taskReportConfig: aws.sdk.kotlin.services.datasync.model.TaskReportConfig? = builder.taskReportConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.StartTaskExecutionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartTaskExecutionRequest(")
        append("excludes=$excludes,")
        append("includes=$includes,")
        append("manifestConfig=$manifestConfig,")
        append("overrideOptions=$overrideOptions,")
        append("tags=$tags,")
        append("taskArn=$taskArn,")
        append("taskReportConfig=$taskReportConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = excludes?.hashCode() ?: 0
        result = 31 * result + (includes?.hashCode() ?: 0)
        result = 31 * result + (manifestConfig?.hashCode() ?: 0)
        result = 31 * result + (overrideOptions?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (taskArn?.hashCode() ?: 0)
        result = 31 * result + (taskReportConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartTaskExecutionRequest

        if (excludes != other.excludes) return false
        if (includes != other.includes) return false
        if (manifestConfig != other.manifestConfig) return false
        if (overrideOptions != other.overrideOptions) return false
        if (tags != other.tags) return false
        if (taskArn != other.taskArn) return false
        if (taskReportConfig != other.taskReportConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.StartTaskExecutionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies a list of filter rules that determines which files to exclude from a task. The list contains a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example, `"/folder1|/folder2"`.
         */
        public var excludes: List<FilterRule>? = null
        /**
         * Specifies a list of filter rules that determines which files to include when running a task. The pattern should contain a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example, `"/folder1|/folder2"`.
         */
        public var includes: List<FilterRule>? = null
        /**
         * Configures a manifest, which is a list of files or objects that you want DataSync to transfer. For more information and configuration examples, see [Specifying what DataSync transfers by using a manifest](https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html).
         *
         * When using this parameter, your caller identity (the role that you're using DataSync with) must have the `iam:PassRole` permission. The [AWSDataSyncFullAccess](https://docs.aws.amazon.com/datasync/latest/userguide/security-iam-awsmanpol.html#security-iam-awsmanpol-awsdatasyncfullaccess) policy includes this permission.
         *
         * To remove a manifest configuration, specify this parameter with an empty value.
         */
        public var manifestConfig: aws.sdk.kotlin.services.datasync.model.ManifestConfig? = null
        /**
         * Indicates how your transfer task is configured. These options include how DataSync handles files, objects, and their associated metadata during your transfer. You also can specify how to verify data integrity, set bandwidth limits for your task, among other options.
         *
         * Each option has a default value. Unless you need to, you don't have to configure any option before calling [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html).
         *
         * You also can override your task options for each task execution. For example, you might want to adjust the `LogLevel` for an individual execution.
         */
        public var overrideOptions: aws.sdk.kotlin.services.datasync.model.Options? = null
        /**
         * Specifies the tags that you want to apply to the Amazon Resource Name (ARN) representing the task execution.
         *
         * *Tags* are key-value pairs that help you manage, filter, and search for your DataSync resources.
         */
        public var tags: List<TagListEntry>? = null
        /**
         * Specifies the Amazon Resource Name (ARN) of the task that you want to start.
         */
        public var taskArn: kotlin.String? = null
        /**
         * Specifies how you want to configure a task report, which provides detailed information about your DataSync transfer. For more information, see [Monitoring your DataSync transfers with task reports](https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html).
         *
         * When using this parameter, your caller identity (the role that you're using DataSync with) must have the `iam:PassRole` permission. The [AWSDataSyncFullAccess](https://docs.aws.amazon.com/datasync/latest/userguide/security-iam-awsmanpol.html#security-iam-awsmanpol-awsdatasyncfullaccess) policy includes this permission.
         *
         * To remove a task report configuration, specify this parameter as empty.
         */
        public var taskReportConfig: aws.sdk.kotlin.services.datasync.model.TaskReportConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.StartTaskExecutionRequest) : this() {
            this.excludes = x.excludes
            this.includes = x.includes
            this.manifestConfig = x.manifestConfig
            this.overrideOptions = x.overrideOptions
            this.tags = x.tags
            this.taskArn = x.taskArn
            this.taskReportConfig = x.taskReportConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.StartTaskExecutionRequest = StartTaskExecutionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.ManifestConfig] inside the given [block]
         */
        public fun manifestConfig(block: aws.sdk.kotlin.services.datasync.model.ManifestConfig.Builder.() -> kotlin.Unit) {
            this.manifestConfig = aws.sdk.kotlin.services.datasync.model.ManifestConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.Options] inside the given [block]
         */
        public fun overrideOptions(block: aws.sdk.kotlin.services.datasync.model.Options.Builder.() -> kotlin.Unit) {
            this.overrideOptions = aws.sdk.kotlin.services.datasync.model.Options.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.TaskReportConfig] inside the given [block]
         */
        public fun taskReportConfig(block: aws.sdk.kotlin.services.datasync.model.TaskReportConfig.Builder.() -> kotlin.Unit) {
            this.taskReportConfig = aws.sdk.kotlin.services.datasync.model.TaskReportConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
