// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the S3 bucket where you're hosting the manifest that you want DataSync to use. For more information and configuration examples, see [Specifying what DataSync transfers by using a manifest](https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html).
 */
public class S3ManifestConfig private constructor(builder: Builder) {
    /**
     * Specifies the Identity and Access Management (IAM) role that allows DataSync to access your manifest. For more information, see [Providing DataSync access to your manifest](https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html#transferring-with-manifest-access).
     */
    public val bucketAccessRoleArn: kotlin.String = requireNotNull(builder.bucketAccessRoleArn) { "A non-null value must be provided for bucketAccessRoleArn" }
    /**
     * Specifies the Amazon S3 object key of your manifest. This can include a prefix (for example, `prefix/my-manifest.csv`).
     */
    public val manifestObjectPath: kotlin.String = requireNotNull(builder.manifestObjectPath) { "A non-null value must be provided for manifestObjectPath" }
    /**
     * Specifies the object version ID of the manifest that you want DataSync to use. If you don't set this, DataSync uses the latest version of the object.
     */
    public val manifestObjectVersionId: kotlin.String? = builder.manifestObjectVersionId
    /**
     * Specifies the Amazon Resource Name (ARN) of the S3 bucket where you're hosting your manifest.
     */
    public val s3BucketArn: kotlin.String = requireNotNull(builder.s3BucketArn) { "A non-null value must be provided for s3BucketArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.S3ManifestConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3ManifestConfig(")
        append("bucketAccessRoleArn=$bucketAccessRoleArn,")
        append("manifestObjectPath=$manifestObjectPath,")
        append("manifestObjectVersionId=$manifestObjectVersionId,")
        append("s3BucketArn=$s3BucketArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketAccessRoleArn.hashCode()
        result = 31 * result + (manifestObjectPath.hashCode())
        result = 31 * result + (manifestObjectVersionId?.hashCode() ?: 0)
        result = 31 * result + (s3BucketArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3ManifestConfig

        if (bucketAccessRoleArn != other.bucketAccessRoleArn) return false
        if (manifestObjectPath != other.manifestObjectPath) return false
        if (manifestObjectVersionId != other.manifestObjectVersionId) return false
        if (s3BucketArn != other.s3BucketArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.S3ManifestConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the Identity and Access Management (IAM) role that allows DataSync to access your manifest. For more information, see [Providing DataSync access to your manifest](https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html#transferring-with-manifest-access).
         */
        public var bucketAccessRoleArn: kotlin.String? = null
        /**
         * Specifies the Amazon S3 object key of your manifest. This can include a prefix (for example, `prefix/my-manifest.csv`).
         */
        public var manifestObjectPath: kotlin.String? = null
        /**
         * Specifies the object version ID of the manifest that you want DataSync to use. If you don't set this, DataSync uses the latest version of the object.
         */
        public var manifestObjectVersionId: kotlin.String? = null
        /**
         * Specifies the Amazon Resource Name (ARN) of the S3 bucket where you're hosting your manifest.
         */
        public var s3BucketArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.S3ManifestConfig) : this() {
            this.bucketAccessRoleArn = x.bucketAccessRoleArn
            this.manifestObjectPath = x.manifestObjectPath
            this.manifestObjectVersionId = x.manifestObjectVersionId
            this.s3BucketArn = x.s3BucketArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.S3ManifestConfig = S3ManifestConfig(this)

        internal fun correctErrors(): Builder {
            if (bucketAccessRoleArn == null) bucketAccessRoleArn = ""
            if (manifestObjectPath == null) manifestObjectPath = ""
            if (s3BucketArn == null) s3BucketArn = ""
            return this
        }
    }
}
