// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that DataSync uses to access your S3 bucket.
 *
 * For more information, see [Accessing S3 buckets](https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#create-s3-location-access).
 */
public class S3Config private constructor(builder: Builder) {
    /**
     * Specifies the ARN of the IAM role that DataSync uses to access your S3 bucket.
     */
    public val bucketAccessRoleArn: kotlin.String = requireNotNull(builder.bucketAccessRoleArn) { "A non-null value must be provided for bucketAccessRoleArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.S3Config = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3Config(")
        append("bucketAccessRoleArn=$bucketAccessRoleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketAccessRoleArn.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3Config

        if (bucketAccessRoleArn != other.bucketAccessRoleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.S3Config = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the ARN of the IAM role that DataSync uses to access your S3 bucket.
         */
        public var bucketAccessRoleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.S3Config) : this() {
            this.bucketAccessRoleArn = x.bucketAccessRoleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.S3Config = S3Config(this)

        internal fun correctErrors(): Builder {
            if (bucketAccessRoleArn == null) bucketAccessRoleArn = ""
            return this
        }
    }
}
