// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the Amazon S3 bucket where DataSync uploads your [task report](https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html).
 */
public class ReportDestinationS3 private constructor(builder: Builder) {
    /**
     * Specifies the Amazon Resource Name (ARN) of the IAM policy that allows DataSync to upload a task report to your S3 bucket. For more information, see [Allowing DataSync to upload a task report to an Amazon S3 bucket](https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html).
     */
    public val bucketAccessRoleArn: kotlin.String = requireNotNull(builder.bucketAccessRoleArn) { "A non-null value must be provided for bucketAccessRoleArn" }
    /**
     * Specifies the ARN of the S3 bucket where DataSync uploads your report.
     */
    public val s3BucketArn: kotlin.String = requireNotNull(builder.s3BucketArn) { "A non-null value must be provided for s3BucketArn" }
    /**
     * Specifies a bucket prefix for your report.
     */
    public val subdirectory: kotlin.String? = builder.subdirectory

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.ReportDestinationS3 = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReportDestinationS3(")
        append("bucketAccessRoleArn=$bucketAccessRoleArn,")
        append("s3BucketArn=$s3BucketArn,")
        append("subdirectory=$subdirectory")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketAccessRoleArn.hashCode()
        result = 31 * result + (s3BucketArn.hashCode())
        result = 31 * result + (subdirectory?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReportDestinationS3

        if (bucketAccessRoleArn != other.bucketAccessRoleArn) return false
        if (s3BucketArn != other.s3BucketArn) return false
        if (subdirectory != other.subdirectory) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.ReportDestinationS3 = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the Amazon Resource Name (ARN) of the IAM policy that allows DataSync to upload a task report to your S3 bucket. For more information, see [Allowing DataSync to upload a task report to an Amazon S3 bucket](https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html).
         */
        public var bucketAccessRoleArn: kotlin.String? = null
        /**
         * Specifies the ARN of the S3 bucket where DataSync uploads your report.
         */
        public var s3BucketArn: kotlin.String? = null
        /**
         * Specifies a bucket prefix for your report.
         */
        public var subdirectory: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.ReportDestinationS3) : this() {
            this.bucketAccessRoleArn = x.bucketAccessRoleArn
            this.s3BucketArn = x.s3BucketArn
            this.subdirectory = x.subdirectory
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.ReportDestinationS3 = ReportDestinationS3(this)

        internal fun correctErrors(): Builder {
            if (bucketAccessRoleArn == null) bucketAccessRoleArn = ""
            if (s3BucketArn == null) s3BucketArn = ""
            return this
        }
    }
}
