// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies how DataSync can access a location using the NFS protocol.
 */
public class NfsMountOptions private constructor(builder: Builder) {
    /**
     * Specifies the NFS version that you want DataSync to use when mounting your NFS share. If the server refuses to use the version specified, the task fails.
     *
     * You can specify the following options:
     * + `AUTOMATIC` (default): DataSync chooses NFS version 4.1.
     * + `NFS3`: Stateless protocol version that allows for asynchronous writes on the server.
     * + `NFSv4_0`: Stateful, firewall-friendly protocol version that supports delegations and pseudo file systems.
     * + `NFSv4_1`: Stateful protocol version that supports sessions, directory delegations, and parallel data processing. NFS version 4.1 also includes all features available in version 4.0.
     *
     * DataSync currently only supports NFS version 3 with Amazon FSx for NetApp ONTAP locations.
     */
    public val version: aws.sdk.kotlin.services.datasync.model.NfsVersion? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.NfsMountOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NfsMountOptions(")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = version?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NfsMountOptions

        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.NfsMountOptions = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the NFS version that you want DataSync to use when mounting your NFS share. If the server refuses to use the version specified, the task fails.
         *
         * You can specify the following options:
         * + `AUTOMATIC` (default): DataSync chooses NFS version 4.1.
         * + `NFS3`: Stateless protocol version that allows for asynchronous writes on the server.
         * + `NFSv4_0`: Stateful, firewall-friendly protocol version that supports delegations and pseudo file systems.
         * + `NFSv4_1`: Stateful protocol version that supports sessions, directory delegations, and parallel data processing. NFS version 4.1 also includes all features available in version 4.0.
         *
         * DataSync currently only supports NFS version 3 with Amazon FSx for NetApp ONTAP locations.
         */
        public var version: aws.sdk.kotlin.services.datasync.model.NfsVersion? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.NfsMountOptions) : this() {
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.NfsMountOptions = NfsMountOptions(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
