// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The information that DataSync Discovery collects about a storage virtual machine (SVM) in your on-premises storage system.
 */
public class NetAppOntapsvm private constructor(builder: Builder) {
    /**
     * The number of CIFS shares in the SVM.
     */
    public val cifsShareCount: kotlin.Long? = builder.cifsShareCount
    /**
     * The universally unique identifier (UUID) of the cluster associated with the SVM.
     */
    public val clusterUuid: kotlin.String? = builder.clusterUuid
    /**
     * The data transfer protocols (such as NFS) configured for the SVM.
     */
    public val enabledProtocols: List<String>? = builder.enabledProtocols
    /**
     * The number of LUNs (logical unit numbers) in the SVM.
     */
    public val lunCount: kotlin.Long? = builder.lunCount
    /**
     * The performance data that DataSync Discovery collects about the SVM.
     */
    public val maxP95Performance: aws.sdk.kotlin.services.datasync.model.MaxP95Performance? = builder.maxP95Performance
    /**
     * The number of NFS volumes in the SVM.
     */
    public val nfsExportedVolumes: kotlin.Long? = builder.nfsExportedVolumes
    /**
     * Indicates whether DataSync Discovery recommendations for the SVM are ready to view, incomplete, or can't be determined.
     *
     * For more information, see [Recommendation statuses](https://docs.aws.amazon.com/datasync/latest/userguide/discovery-job-statuses.html#recommendation-statuses-table).
     */
    public val recommendationStatus: aws.sdk.kotlin.services.datasync.model.RecommendationStatus? = builder.recommendationStatus
    /**
     * The Amazon Web Services storage services that DataSync Discovery recommends for the SVM. For more information, see [Recommendations provided by DataSync Discovery](https://docs.aws.amazon.com/datasync/latest/userguide/discovery-understand-recommendations.html).
     */
    public val recommendations: List<Recommendation>? = builder.recommendations
    /**
     * The UUID of the SVM.
     */
    public val resourceId: kotlin.String? = builder.resourceId
    /**
     * The name of the SVM
     */
    public val svmName: kotlin.String? = builder.svmName
    /**
     * The total storage space that's available in the SVM.
     */
    public val totalCapacityProvisioned: kotlin.Long? = builder.totalCapacityProvisioned
    /**
     * The storage space that's being used in the SVM.
     */
    public val totalCapacityUsed: kotlin.Long? = builder.totalCapacityUsed
    /**
     * The storage space that's being used in the SVM without accounting for compression or deduplication.
     */
    public val totalLogicalCapacityUsed: kotlin.Long? = builder.totalLogicalCapacityUsed
    /**
     * The amount of storage in the SVM that's being used for snapshots.
     */
    public val totalSnapshotCapacityUsed: kotlin.Long? = builder.totalSnapshotCapacityUsed

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.NetAppOntapsvm = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NetAppOntapsvm(")
        append("cifsShareCount=$cifsShareCount,")
        append("clusterUuid=$clusterUuid,")
        append("enabledProtocols=$enabledProtocols,")
        append("lunCount=$lunCount,")
        append("maxP95Performance=$maxP95Performance,")
        append("nfsExportedVolumes=$nfsExportedVolumes,")
        append("recommendationStatus=$recommendationStatus,")
        append("recommendations=$recommendations,")
        append("resourceId=$resourceId,")
        append("svmName=$svmName,")
        append("totalCapacityProvisioned=$totalCapacityProvisioned,")
        append("totalCapacityUsed=$totalCapacityUsed,")
        append("totalLogicalCapacityUsed=$totalLogicalCapacityUsed,")
        append("totalSnapshotCapacityUsed=$totalSnapshotCapacityUsed")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cifsShareCount?.hashCode() ?: 0
        result = 31 * result + (clusterUuid?.hashCode() ?: 0)
        result = 31 * result + (enabledProtocols?.hashCode() ?: 0)
        result = 31 * result + (lunCount?.hashCode() ?: 0)
        result = 31 * result + (maxP95Performance?.hashCode() ?: 0)
        result = 31 * result + (nfsExportedVolumes?.hashCode() ?: 0)
        result = 31 * result + (recommendationStatus?.hashCode() ?: 0)
        result = 31 * result + (recommendations?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (svmName?.hashCode() ?: 0)
        result = 31 * result + (totalCapacityProvisioned?.hashCode() ?: 0)
        result = 31 * result + (totalCapacityUsed?.hashCode() ?: 0)
        result = 31 * result + (totalLogicalCapacityUsed?.hashCode() ?: 0)
        result = 31 * result + (totalSnapshotCapacityUsed?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NetAppOntapsvm

        if (cifsShareCount != other.cifsShareCount) return false
        if (clusterUuid != other.clusterUuid) return false
        if (enabledProtocols != other.enabledProtocols) return false
        if (lunCount != other.lunCount) return false
        if (maxP95Performance != other.maxP95Performance) return false
        if (nfsExportedVolumes != other.nfsExportedVolumes) return false
        if (recommendationStatus != other.recommendationStatus) return false
        if (recommendations != other.recommendations) return false
        if (resourceId != other.resourceId) return false
        if (svmName != other.svmName) return false
        if (totalCapacityProvisioned != other.totalCapacityProvisioned) return false
        if (totalCapacityUsed != other.totalCapacityUsed) return false
        if (totalLogicalCapacityUsed != other.totalLogicalCapacityUsed) return false
        if (totalSnapshotCapacityUsed != other.totalSnapshotCapacityUsed) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.NetAppOntapsvm = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of CIFS shares in the SVM.
         */
        public var cifsShareCount: kotlin.Long? = null
        /**
         * The universally unique identifier (UUID) of the cluster associated with the SVM.
         */
        public var clusterUuid: kotlin.String? = null
        /**
         * The data transfer protocols (such as NFS) configured for the SVM.
         */
        public var enabledProtocols: List<String>? = null
        /**
         * The number of LUNs (logical unit numbers) in the SVM.
         */
        public var lunCount: kotlin.Long? = null
        /**
         * The performance data that DataSync Discovery collects about the SVM.
         */
        public var maxP95Performance: aws.sdk.kotlin.services.datasync.model.MaxP95Performance? = null
        /**
         * The number of NFS volumes in the SVM.
         */
        public var nfsExportedVolumes: kotlin.Long? = null
        /**
         * Indicates whether DataSync Discovery recommendations for the SVM are ready to view, incomplete, or can't be determined.
         *
         * For more information, see [Recommendation statuses](https://docs.aws.amazon.com/datasync/latest/userguide/discovery-job-statuses.html#recommendation-statuses-table).
         */
        public var recommendationStatus: aws.sdk.kotlin.services.datasync.model.RecommendationStatus? = null
        /**
         * The Amazon Web Services storage services that DataSync Discovery recommends for the SVM. For more information, see [Recommendations provided by DataSync Discovery](https://docs.aws.amazon.com/datasync/latest/userguide/discovery-understand-recommendations.html).
         */
        public var recommendations: List<Recommendation>? = null
        /**
         * The UUID of the SVM.
         */
        public var resourceId: kotlin.String? = null
        /**
         * The name of the SVM
         */
        public var svmName: kotlin.String? = null
        /**
         * The total storage space that's available in the SVM.
         */
        public var totalCapacityProvisioned: kotlin.Long? = null
        /**
         * The storage space that's being used in the SVM.
         */
        public var totalCapacityUsed: kotlin.Long? = null
        /**
         * The storage space that's being used in the SVM without accounting for compression or deduplication.
         */
        public var totalLogicalCapacityUsed: kotlin.Long? = null
        /**
         * The amount of storage in the SVM that's being used for snapshots.
         */
        public var totalSnapshotCapacityUsed: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.NetAppOntapsvm) : this() {
            this.cifsShareCount = x.cifsShareCount
            this.clusterUuid = x.clusterUuid
            this.enabledProtocols = x.enabledProtocols
            this.lunCount = x.lunCount
            this.maxP95Performance = x.maxP95Performance
            this.nfsExportedVolumes = x.nfsExportedVolumes
            this.recommendationStatus = x.recommendationStatus
            this.recommendations = x.recommendations
            this.resourceId = x.resourceId
            this.svmName = x.svmName
            this.totalCapacityProvisioned = x.totalCapacityProvisioned
            this.totalCapacityUsed = x.totalCapacityUsed
            this.totalLogicalCapacityUsed = x.totalLogicalCapacityUsed
            this.totalSnapshotCapacityUsed = x.totalSnapshotCapacityUsed
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.NetAppOntapsvm = NetAppOntapsvm(this)

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.MaxP95Performance] inside the given [block]
         */
        public fun maxP95Performance(block: aws.sdk.kotlin.services.datasync.model.MaxP95Performance.Builder.() -> kotlin.Unit) {
            this.maxP95Performance = aws.sdk.kotlin.services.datasync.model.MaxP95Performance.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
