// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Configures a manifest, which is a list of files or objects that you want DataSync to transfer. For more information and configuration examples, see [Specifying what DataSync transfers by using a manifest](https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html).
 */
public class ManifestConfig private constructor(builder: Builder) {
    /**
     * Specifies what DataSync uses the manifest for.
     */
    public val action: aws.sdk.kotlin.services.datasync.model.ManifestAction? = builder.action
    /**
     * Specifies the file format of your manifest. For more information, see [Creating a manifest](https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html#transferring-with-manifest-create).
     */
    public val format: aws.sdk.kotlin.services.datasync.model.ManifestFormat? = builder.format
    /**
     * Specifies the manifest that you want DataSync to use and where it's hosted.
     *
     * You must specify this parameter if you're configuring a new manifest on or after February 7, 2024.
     *
     * If you don't, you'll get a 400 status code and `ValidationException` error stating that you're missing the IAM role for DataSync to access the S3 bucket where you're hosting your manifest. For more information, see [Providing DataSync access to your manifest](https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html#transferring-with-manifest-access).
     */
    public val source: aws.sdk.kotlin.services.datasync.model.SourceManifestConfig? = builder.source

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.ManifestConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ManifestConfig(")
        append("action=$action,")
        append("format=$format,")
        append("source=$source")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ManifestConfig

        if (action != other.action) return false
        if (format != other.format) return false
        if (source != other.source) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.ManifestConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies what DataSync uses the manifest for.
         */
        public var action: aws.sdk.kotlin.services.datasync.model.ManifestAction? = null
        /**
         * Specifies the file format of your manifest. For more information, see [Creating a manifest](https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html#transferring-with-manifest-create).
         */
        public var format: aws.sdk.kotlin.services.datasync.model.ManifestFormat? = null
        /**
         * Specifies the manifest that you want DataSync to use and where it's hosted.
         *
         * You must specify this parameter if you're configuring a new manifest on or after February 7, 2024.
         *
         * If you don't, you'll get a 400 status code and `ValidationException` error stating that you're missing the IAM role for DataSync to access the S3 bucket where you're hosting your manifest. For more information, see [Providing DataSync access to your manifest](https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html#transferring-with-manifest-access).
         */
        public var source: aws.sdk.kotlin.services.datasync.model.SourceManifestConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.ManifestConfig) : this() {
            this.action = x.action
            this.format = x.format
            this.source = x.source
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.ManifestConfig = ManifestConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.SourceManifestConfig] inside the given [block]
         */
        public fun source(block: aws.sdk.kotlin.services.datasync.model.SourceManifestConfig.Builder.() -> kotlin.Unit) {
            this.source = aws.sdk.kotlin.services.datasync.model.SourceManifestConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
