// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * DescribeTaskExecutionResponse
 */
public class DescribeTaskExecutionResponse private constructor(builder: Builder) {
    /**
     * The number of physical bytes that DataSync transfers over the network after compression (if compression is possible). This number is typically less than [BytesTransferred](https://docs.aws.amazon.com/datasync/latest/userguide/API_DescribeTaskExecution.html#DataSync-DescribeTaskExecution-response-BytesTransferred) unless the data isn't compressible.
     *
     * Not currently supported with [Enhanced mode tasks](https://docs.aws.amazon.com/datasync/latest/userguide/choosing-task-mode.html).
     */
    public val bytesCompressed: kotlin.Long = builder.bytesCompressed
    /**
     * The number of bytes that DataSync sends to the network before compression (if compression is possible). For the number of bytes transferred over the network, see [BytesCompressed](https://docs.aws.amazon.com/datasync/latest/userguide/API_DescribeTaskExecution.html#DataSync-DescribeTaskExecution-response-BytesCompressed).
     */
    public val bytesTransferred: kotlin.Long = builder.bytesTransferred
    /**
     * The number of logical bytes that DataSync actually writes to the destination location.
     */
    public val bytesWritten: kotlin.Long = builder.bytesWritten
    /**
     * The number of logical bytes that DataSync expects to write to the destination location.
     */
    public val estimatedBytesToTransfer: kotlin.Long = builder.estimatedBytesToTransfer
    /**
     * The number of files, objects, and directories that DataSync expects to delete in your destination location. If you don't [configure your task](https://docs.aws.amazon.com/datasync/latest/userguide/configure-metadata.html) to delete data in the destination that isn't in the source, the value is always `0`.
     */
    public val estimatedFilesToDelete: kotlin.Long = builder.estimatedFilesToDelete
    /**
     * The number of files, objects, and directories that DataSync expects to transfer over the network. This value is calculated during the task execution's `PREPARING`[step](https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#understand-task-execution-statuses) before the `TRANSFERRING` step.
     *
     * How this gets calculated depends primarily on your task’s [transfer mode](https://docs.aws.amazon.com/datasync/latest/userguide/API_Options.html#DataSync-Type-Options-TransferMode) configuration:
     * + If `TranserMode` is set to `CHANGED` - The calculation is based on comparing the content of the source and destination locations and determining the difference that needs to be transferred. The difference can include:
     *    + Anything that's added or modified at the source location.
     *    + Anything that's in both locations and modified at the destination after an initial transfer (unless [OverwriteMode](https://docs.aws.amazon.com/datasync/latest/userguide/API_Options.html#DataSync-Type-Options-OverwriteMode) is set to `NEVER`).
     *    + **(Basic task mode only)** The number of items that DataSync expects to delete (if [PreserveDeletedFiles](https://docs.aws.amazon.com/datasync/latest/userguide/API_Options.html#DataSync-Type-Options-PreserveDeletedFiles) is set to `REMOVE`).
     * + If `TranserMode` is set to `ALL` - The calculation is based only on the items that DataSync finds at the source location.
     */
    public val estimatedFilesToTransfer: kotlin.Long = builder.estimatedFilesToTransfer
    /**
     * A list of filter rules that exclude specific data during your transfer. For more information and examples, see [Filtering data transferred by DataSync](https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html).
     */
    public val excludes: List<FilterRule>? = builder.excludes
    /**
     * The number of files, objects, and directories that DataSync actually deletes in your destination location. If you don't [configure your task](https://docs.aws.amazon.com/datasync/latest/userguide/configure-metadata.html) to delete data in the destination that isn't in the source, the value is always `0`.
     */
    public val filesDeleted: kotlin.Long = builder.filesDeleted
    /**
     * The number of objects that DataSync fails to prepare, transfer, verify, and delete during your task execution.
     *
     * Applies only to [Enhanced mode tasks](https://docs.aws.amazon.com/datasync/latest/userguide/choosing-task-mode.html).
     */
    public val filesFailed: aws.sdk.kotlin.services.datasync.model.TaskExecutionFilesFailedDetail? = builder.filesFailed
    /**
     * The number of objects that DataSync finds at your locations.
     *
     * Applies only to [Enhanced mode tasks](https://docs.aws.amazon.com/datasync/latest/userguide/choosing-task-mode.html).
     */
    public val filesListed: aws.sdk.kotlin.services.datasync.model.TaskExecutionFilesListedDetail? = builder.filesListed
    /**
     * The number of objects that DataSync will attempt to transfer after comparing your source and destination locations.
     *
     * Applies only to [Enhanced mode tasks](https://docs.aws.amazon.com/datasync/latest/userguide/choosing-task-mode.html).
     *
     * This metric isn't applicable if you configure your task to [transfer all data](https://docs.aws.amazon.com/datasync/latest/userguide/configure-metadata.html#task-option-transfer-mode). In that scenario, DataSync copies everything from the source to the destination without comparing differences between the locations.
     */
    public val filesPrepared: kotlin.Long = builder.filesPrepared
    /**
     * The number of files, objects, and directories that DataSync skips during your transfer.
     */
    public val filesSkipped: kotlin.Long = builder.filesSkipped
    /**
     * The number of files, objects, and directories that DataSync actually transfers over the network. This value is updated periodically during the task execution's `TRANSFERRING`[step](https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#understand-task-execution-statuses) when something is read from the source and sent over the network.
     *
     * If DataSync fails to transfer something, this value can be less than `EstimatedFilesToTransfer`. In some cases, this value can also be greater than `EstimatedFilesToTransfer`. This element is implementation-specific for some location types, so don't use it as an exact indication of what's transferring or to monitor your task execution.
     */
    public val filesTransferred: kotlin.Long = builder.filesTransferred
    /**
     * The number of files, objects, and directories that DataSync verifies during your transfer.
     *
     * When you configure your task to [verify only the data that's transferred](https://docs.aws.amazon.com/datasync/latest/userguide/configure-data-verification-options.html), DataSync doesn't verify directories in some situations or files that fail to transfer.
     */
    public val filesVerified: kotlin.Long = builder.filesVerified
    /**
     * A list of filter rules that include specific data during your transfer. For more information and examples, see [Filtering data transferred by DataSync](https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html).
     */
    public val includes: List<FilterRule>? = builder.includes
    /**
     * The configuration of the manifest that lists the files or objects to transfer. For more information, see [Specifying what DataSync transfers by using a manifest](https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html).
     */
    public val manifestConfig: aws.sdk.kotlin.services.datasync.model.ManifestConfig? = builder.manifestConfig
    /**
     * Indicates how your transfer task is configured. These options include how DataSync handles files, objects, and their associated metadata during your transfer. You also can specify how to verify data integrity, set bandwidth limits for your task, among other options.
     *
     * Each option has a default value. Unless you need to, you don't have to configure any option before calling [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html).
     *
     * You also can override your task options for each task execution. For example, you might want to adjust the `LogLevel` for an individual execution.
     */
    public val options: aws.sdk.kotlin.services.datasync.model.Options? = builder.options
    /**
     * Indicates whether DataSync generated a complete [task report](https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html) for your transfer.
     */
    public val reportResult: aws.sdk.kotlin.services.datasync.model.ReportResult? = builder.reportResult
    /**
     * The result of the task execution.
     */
    public val result: aws.sdk.kotlin.services.datasync.model.TaskExecutionResultDetail? = builder.result
    /**
     * The time when the task execution started.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The status of the task execution.
     */
    public val status: aws.sdk.kotlin.services.datasync.model.TaskExecutionStatus? = builder.status
    /**
     * The ARN of the task execution that you wanted information about. `TaskExecutionArn` is hierarchical and includes `TaskArn` for the task that was executed.
     *
     * For example, a `TaskExecution` value with the ARN `arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2/execution/exec-08ef1e88ec491019b` executed the task with the ARN `arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2`.
     */
    public val taskExecutionArn: kotlin.String? = builder.taskExecutionArn
    /**
     * The task mode that you're using. For more information, see [Choosing a task mode for your data transfer](https://docs.aws.amazon.com/datasync/latest/userguide/choosing-task-mode.html).
     */
    public val taskMode: aws.sdk.kotlin.services.datasync.model.TaskMode? = builder.taskMode
    /**
     * The configuration of your task report, which provides detailed information about for your DataSync transfer. For more information, see [Creating a task report](https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html).
     */
    public val taskReportConfig: aws.sdk.kotlin.services.datasync.model.TaskReportConfig? = builder.taskReportConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.DescribeTaskExecutionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeTaskExecutionResponse(")
        append("bytesCompressed=$bytesCompressed,")
        append("bytesTransferred=$bytesTransferred,")
        append("bytesWritten=$bytesWritten,")
        append("estimatedBytesToTransfer=$estimatedBytesToTransfer,")
        append("estimatedFilesToDelete=$estimatedFilesToDelete,")
        append("estimatedFilesToTransfer=$estimatedFilesToTransfer,")
        append("excludes=$excludes,")
        append("filesDeleted=$filesDeleted,")
        append("filesFailed=$filesFailed,")
        append("filesListed=$filesListed,")
        append("filesPrepared=$filesPrepared,")
        append("filesSkipped=$filesSkipped,")
        append("filesTransferred=$filesTransferred,")
        append("filesVerified=$filesVerified,")
        append("includes=$includes,")
        append("manifestConfig=$manifestConfig,")
        append("options=$options,")
        append("reportResult=$reportResult,")
        append("result=$result,")
        append("startTime=$startTime,")
        append("status=$status,")
        append("taskExecutionArn=$taskExecutionArn,")
        append("taskMode=$taskMode,")
        append("taskReportConfig=$taskReportConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bytesCompressed.hashCode()
        result = 31 * result + (bytesTransferred.hashCode())
        result = 31 * result + (bytesWritten.hashCode())
        result = 31 * result + (estimatedBytesToTransfer.hashCode())
        result = 31 * result + (estimatedFilesToDelete.hashCode())
        result = 31 * result + (estimatedFilesToTransfer.hashCode())
        result = 31 * result + (excludes?.hashCode() ?: 0)
        result = 31 * result + (filesDeleted.hashCode())
        result = 31 * result + (filesFailed?.hashCode() ?: 0)
        result = 31 * result + (filesListed?.hashCode() ?: 0)
        result = 31 * result + (filesPrepared.hashCode())
        result = 31 * result + (filesSkipped.hashCode())
        result = 31 * result + (filesTransferred.hashCode())
        result = 31 * result + (filesVerified.hashCode())
        result = 31 * result + (includes?.hashCode() ?: 0)
        result = 31 * result + (manifestConfig?.hashCode() ?: 0)
        result = 31 * result + (options?.hashCode() ?: 0)
        result = 31 * result + (reportResult?.hashCode() ?: 0)
        result = 31 * result + (result?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (taskExecutionArn?.hashCode() ?: 0)
        result = 31 * result + (taskMode?.hashCode() ?: 0)
        result = 31 * result + (taskReportConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeTaskExecutionResponse

        if (bytesCompressed != other.bytesCompressed) return false
        if (bytesTransferred != other.bytesTransferred) return false
        if (bytesWritten != other.bytesWritten) return false
        if (estimatedBytesToTransfer != other.estimatedBytesToTransfer) return false
        if (estimatedFilesToDelete != other.estimatedFilesToDelete) return false
        if (estimatedFilesToTransfer != other.estimatedFilesToTransfer) return false
        if (excludes != other.excludes) return false
        if (filesDeleted != other.filesDeleted) return false
        if (filesFailed != other.filesFailed) return false
        if (filesListed != other.filesListed) return false
        if (filesPrepared != other.filesPrepared) return false
        if (filesSkipped != other.filesSkipped) return false
        if (filesTransferred != other.filesTransferred) return false
        if (filesVerified != other.filesVerified) return false
        if (includes != other.includes) return false
        if (manifestConfig != other.manifestConfig) return false
        if (options != other.options) return false
        if (reportResult != other.reportResult) return false
        if (result != other.result) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (taskExecutionArn != other.taskExecutionArn) return false
        if (taskMode != other.taskMode) return false
        if (taskReportConfig != other.taskReportConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.DescribeTaskExecutionResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of physical bytes that DataSync transfers over the network after compression (if compression is possible). This number is typically less than [BytesTransferred](https://docs.aws.amazon.com/datasync/latest/userguide/API_DescribeTaskExecution.html#DataSync-DescribeTaskExecution-response-BytesTransferred) unless the data isn't compressible.
         *
         * Not currently supported with [Enhanced mode tasks](https://docs.aws.amazon.com/datasync/latest/userguide/choosing-task-mode.html).
         */
        public var bytesCompressed: kotlin.Long = 0L
        /**
         * The number of bytes that DataSync sends to the network before compression (if compression is possible). For the number of bytes transferred over the network, see [BytesCompressed](https://docs.aws.amazon.com/datasync/latest/userguide/API_DescribeTaskExecution.html#DataSync-DescribeTaskExecution-response-BytesCompressed).
         */
        public var bytesTransferred: kotlin.Long = 0L
        /**
         * The number of logical bytes that DataSync actually writes to the destination location.
         */
        public var bytesWritten: kotlin.Long = 0L
        /**
         * The number of logical bytes that DataSync expects to write to the destination location.
         */
        public var estimatedBytesToTransfer: kotlin.Long = 0L
        /**
         * The number of files, objects, and directories that DataSync expects to delete in your destination location. If you don't [configure your task](https://docs.aws.amazon.com/datasync/latest/userguide/configure-metadata.html) to delete data in the destination that isn't in the source, the value is always `0`.
         */
        public var estimatedFilesToDelete: kotlin.Long = 0L
        /**
         * The number of files, objects, and directories that DataSync expects to transfer over the network. This value is calculated during the task execution's `PREPARING`[step](https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#understand-task-execution-statuses) before the `TRANSFERRING` step.
         *
         * How this gets calculated depends primarily on your task’s [transfer mode](https://docs.aws.amazon.com/datasync/latest/userguide/API_Options.html#DataSync-Type-Options-TransferMode) configuration:
         * + If `TranserMode` is set to `CHANGED` - The calculation is based on comparing the content of the source and destination locations and determining the difference that needs to be transferred. The difference can include:
         *    + Anything that's added or modified at the source location.
         *    + Anything that's in both locations and modified at the destination after an initial transfer (unless [OverwriteMode](https://docs.aws.amazon.com/datasync/latest/userguide/API_Options.html#DataSync-Type-Options-OverwriteMode) is set to `NEVER`).
         *    + **(Basic task mode only)** The number of items that DataSync expects to delete (if [PreserveDeletedFiles](https://docs.aws.amazon.com/datasync/latest/userguide/API_Options.html#DataSync-Type-Options-PreserveDeletedFiles) is set to `REMOVE`).
         * + If `TranserMode` is set to `ALL` - The calculation is based only on the items that DataSync finds at the source location.
         */
        public var estimatedFilesToTransfer: kotlin.Long = 0L
        /**
         * A list of filter rules that exclude specific data during your transfer. For more information and examples, see [Filtering data transferred by DataSync](https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html).
         */
        public var excludes: List<FilterRule>? = null
        /**
         * The number of files, objects, and directories that DataSync actually deletes in your destination location. If you don't [configure your task](https://docs.aws.amazon.com/datasync/latest/userguide/configure-metadata.html) to delete data in the destination that isn't in the source, the value is always `0`.
         */
        public var filesDeleted: kotlin.Long = 0L
        /**
         * The number of objects that DataSync fails to prepare, transfer, verify, and delete during your task execution.
         *
         * Applies only to [Enhanced mode tasks](https://docs.aws.amazon.com/datasync/latest/userguide/choosing-task-mode.html).
         */
        public var filesFailed: aws.sdk.kotlin.services.datasync.model.TaskExecutionFilesFailedDetail? = null
        /**
         * The number of objects that DataSync finds at your locations.
         *
         * Applies only to [Enhanced mode tasks](https://docs.aws.amazon.com/datasync/latest/userguide/choosing-task-mode.html).
         */
        public var filesListed: aws.sdk.kotlin.services.datasync.model.TaskExecutionFilesListedDetail? = null
        /**
         * The number of objects that DataSync will attempt to transfer after comparing your source and destination locations.
         *
         * Applies only to [Enhanced mode tasks](https://docs.aws.amazon.com/datasync/latest/userguide/choosing-task-mode.html).
         *
         * This metric isn't applicable if you configure your task to [transfer all data](https://docs.aws.amazon.com/datasync/latest/userguide/configure-metadata.html#task-option-transfer-mode). In that scenario, DataSync copies everything from the source to the destination without comparing differences between the locations.
         */
        public var filesPrepared: kotlin.Long = 0L
        /**
         * The number of files, objects, and directories that DataSync skips during your transfer.
         */
        public var filesSkipped: kotlin.Long = 0L
        /**
         * The number of files, objects, and directories that DataSync actually transfers over the network. This value is updated periodically during the task execution's `TRANSFERRING`[step](https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#understand-task-execution-statuses) when something is read from the source and sent over the network.
         *
         * If DataSync fails to transfer something, this value can be less than `EstimatedFilesToTransfer`. In some cases, this value can also be greater than `EstimatedFilesToTransfer`. This element is implementation-specific for some location types, so don't use it as an exact indication of what's transferring or to monitor your task execution.
         */
        public var filesTransferred: kotlin.Long = 0L
        /**
         * The number of files, objects, and directories that DataSync verifies during your transfer.
         *
         * When you configure your task to [verify only the data that's transferred](https://docs.aws.amazon.com/datasync/latest/userguide/configure-data-verification-options.html), DataSync doesn't verify directories in some situations or files that fail to transfer.
         */
        public var filesVerified: kotlin.Long = 0L
        /**
         * A list of filter rules that include specific data during your transfer. For more information and examples, see [Filtering data transferred by DataSync](https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html).
         */
        public var includes: List<FilterRule>? = null
        /**
         * The configuration of the manifest that lists the files or objects to transfer. For more information, see [Specifying what DataSync transfers by using a manifest](https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html).
         */
        public var manifestConfig: aws.sdk.kotlin.services.datasync.model.ManifestConfig? = null
        /**
         * Indicates how your transfer task is configured. These options include how DataSync handles files, objects, and their associated metadata during your transfer. You also can specify how to verify data integrity, set bandwidth limits for your task, among other options.
         *
         * Each option has a default value. Unless you need to, you don't have to configure any option before calling [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html).
         *
         * You also can override your task options for each task execution. For example, you might want to adjust the `LogLevel` for an individual execution.
         */
        public var options: aws.sdk.kotlin.services.datasync.model.Options? = null
        /**
         * Indicates whether DataSync generated a complete [task report](https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html) for your transfer.
         */
        public var reportResult: aws.sdk.kotlin.services.datasync.model.ReportResult? = null
        /**
         * The result of the task execution.
         */
        public var result: aws.sdk.kotlin.services.datasync.model.TaskExecutionResultDetail? = null
        /**
         * The time when the task execution started.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the task execution.
         */
        public var status: aws.sdk.kotlin.services.datasync.model.TaskExecutionStatus? = null
        /**
         * The ARN of the task execution that you wanted information about. `TaskExecutionArn` is hierarchical and includes `TaskArn` for the task that was executed.
         *
         * For example, a `TaskExecution` value with the ARN `arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2/execution/exec-08ef1e88ec491019b` executed the task with the ARN `arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2`.
         */
        public var taskExecutionArn: kotlin.String? = null
        /**
         * The task mode that you're using. For more information, see [Choosing a task mode for your data transfer](https://docs.aws.amazon.com/datasync/latest/userguide/choosing-task-mode.html).
         */
        public var taskMode: aws.sdk.kotlin.services.datasync.model.TaskMode? = null
        /**
         * The configuration of your task report, which provides detailed information about for your DataSync transfer. For more information, see [Creating a task report](https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html).
         */
        public var taskReportConfig: aws.sdk.kotlin.services.datasync.model.TaskReportConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.DescribeTaskExecutionResponse) : this() {
            this.bytesCompressed = x.bytesCompressed
            this.bytesTransferred = x.bytesTransferred
            this.bytesWritten = x.bytesWritten
            this.estimatedBytesToTransfer = x.estimatedBytesToTransfer
            this.estimatedFilesToDelete = x.estimatedFilesToDelete
            this.estimatedFilesToTransfer = x.estimatedFilesToTransfer
            this.excludes = x.excludes
            this.filesDeleted = x.filesDeleted
            this.filesFailed = x.filesFailed
            this.filesListed = x.filesListed
            this.filesPrepared = x.filesPrepared
            this.filesSkipped = x.filesSkipped
            this.filesTransferred = x.filesTransferred
            this.filesVerified = x.filesVerified
            this.includes = x.includes
            this.manifestConfig = x.manifestConfig
            this.options = x.options
            this.reportResult = x.reportResult
            this.result = x.result
            this.startTime = x.startTime
            this.status = x.status
            this.taskExecutionArn = x.taskExecutionArn
            this.taskMode = x.taskMode
            this.taskReportConfig = x.taskReportConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.DescribeTaskExecutionResponse = DescribeTaskExecutionResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.TaskExecutionFilesFailedDetail] inside the given [block]
         */
        public fun filesFailed(block: aws.sdk.kotlin.services.datasync.model.TaskExecutionFilesFailedDetail.Builder.() -> kotlin.Unit) {
            this.filesFailed = aws.sdk.kotlin.services.datasync.model.TaskExecutionFilesFailedDetail.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.TaskExecutionFilesListedDetail] inside the given [block]
         */
        public fun filesListed(block: aws.sdk.kotlin.services.datasync.model.TaskExecutionFilesListedDetail.Builder.() -> kotlin.Unit) {
            this.filesListed = aws.sdk.kotlin.services.datasync.model.TaskExecutionFilesListedDetail.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.ManifestConfig] inside the given [block]
         */
        public fun manifestConfig(block: aws.sdk.kotlin.services.datasync.model.ManifestConfig.Builder.() -> kotlin.Unit) {
            this.manifestConfig = aws.sdk.kotlin.services.datasync.model.ManifestConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.Options] inside the given [block]
         */
        public fun options(block: aws.sdk.kotlin.services.datasync.model.Options.Builder.() -> kotlin.Unit) {
            this.options = aws.sdk.kotlin.services.datasync.model.Options.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.ReportResult] inside the given [block]
         */
        public fun reportResult(block: aws.sdk.kotlin.services.datasync.model.ReportResult.Builder.() -> kotlin.Unit) {
            this.reportResult = aws.sdk.kotlin.services.datasync.model.ReportResult.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.TaskExecutionResultDetail] inside the given [block]
         */
        public fun result(block: aws.sdk.kotlin.services.datasync.model.TaskExecutionResultDetail.Builder.() -> kotlin.Unit) {
            this.result = aws.sdk.kotlin.services.datasync.model.TaskExecutionResultDetail.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.TaskReportConfig] inside the given [block]
         */
        public fun taskReportConfig(block: aws.sdk.kotlin.services.datasync.model.TaskReportConfig.Builder.() -> kotlin.Unit) {
            this.taskReportConfig = aws.sdk.kotlin.services.datasync.model.TaskReportConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
