// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * CreateLocationS3Request
 */
public class CreateLocationS3Request private constructor(builder: Builder) {
    /**
     * (Amazon S3 on Outposts only) Specifies the Amazon Resource Name (ARN) of the DataSync agent on your Outpost.
     *
     * For more information, see [Deploy your DataSync agent on Outposts](https://docs.aws.amazon.com/datasync/latest/userguide/deploy-agents.html#outposts-agent).
     */
    public val agentArns: List<String>? = builder.agentArns
    /**
     * Specifies the ARN of the S3 bucket that you want to use as a location. (When creating your DataSync task later, you specify whether this location is a transfer source or destination.)
     *
     * If your S3 bucket is located on an Outposts resource, you must specify an Amazon S3 access point. For more information, see [Managing data access with Amazon S3 access points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html) in the *Amazon S3 User Guide*.
     */
    public val s3BucketArn: kotlin.String? = builder.s3BucketArn
    /**
     * Specifies the Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that DataSync uses to access your S3 bucket.
     *
     * For more information, see [Accessing S3 buckets](https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#create-s3-location-access).
     */
    public val s3Config: aws.sdk.kotlin.services.datasync.model.S3Config? = builder.s3Config
    /**
     * Specifies the storage class that you want your objects to use when Amazon S3 is a transfer destination.
     *
     * For buckets in Amazon Web Services Regions, the storage class defaults to `STANDARD`. For buckets on Outposts, the storage class defaults to `OUTPOSTS`.
     *
     * For more information, see [Storage class considerations with Amazon S3 transfers](https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes).
     */
    public val s3StorageClass: aws.sdk.kotlin.services.datasync.model.S3StorageClass? = builder.s3StorageClass
    /**
     * Specifies a prefix in the S3 bucket that DataSync reads from or writes to (depending on whether the bucket is a source or destination location).
     *
     * DataSync can't transfer objects with a prefix that begins with a slash (`/`) or includes `//`, `/./`, or `/../` patterns. For example:
     * + `/photos`
     * + `photos//2006/January`
     * + `photos/./2006/February`
     * + `photos/../2006/March`
     */
    public val subdirectory: kotlin.String? = builder.subdirectory
    /**
     * Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We recommend creating at least a name tag for your transfer location.
     */
    public val tags: List<TagListEntry>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.CreateLocationS3Request = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateLocationS3Request(")
        append("agentArns=$agentArns,")
        append("s3BucketArn=$s3BucketArn,")
        append("s3Config=$s3Config,")
        append("s3StorageClass=$s3StorageClass,")
        append("subdirectory=$subdirectory,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentArns?.hashCode() ?: 0
        result = 31 * result + (s3BucketArn?.hashCode() ?: 0)
        result = 31 * result + (s3Config?.hashCode() ?: 0)
        result = 31 * result + (s3StorageClass?.hashCode() ?: 0)
        result = 31 * result + (subdirectory?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateLocationS3Request

        if (agentArns != other.agentArns) return false
        if (s3BucketArn != other.s3BucketArn) return false
        if (s3Config != other.s3Config) return false
        if (s3StorageClass != other.s3StorageClass) return false
        if (subdirectory != other.subdirectory) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.CreateLocationS3Request = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * (Amazon S3 on Outposts only) Specifies the Amazon Resource Name (ARN) of the DataSync agent on your Outpost.
         *
         * For more information, see [Deploy your DataSync agent on Outposts](https://docs.aws.amazon.com/datasync/latest/userguide/deploy-agents.html#outposts-agent).
         */
        public var agentArns: List<String>? = null
        /**
         * Specifies the ARN of the S3 bucket that you want to use as a location. (When creating your DataSync task later, you specify whether this location is a transfer source or destination.)
         *
         * If your S3 bucket is located on an Outposts resource, you must specify an Amazon S3 access point. For more information, see [Managing data access with Amazon S3 access points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html) in the *Amazon S3 User Guide*.
         */
        public var s3BucketArn: kotlin.String? = null
        /**
         * Specifies the Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that DataSync uses to access your S3 bucket.
         *
         * For more information, see [Accessing S3 buckets](https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#create-s3-location-access).
         */
        public var s3Config: aws.sdk.kotlin.services.datasync.model.S3Config? = null
        /**
         * Specifies the storage class that you want your objects to use when Amazon S3 is a transfer destination.
         *
         * For buckets in Amazon Web Services Regions, the storage class defaults to `STANDARD`. For buckets on Outposts, the storage class defaults to `OUTPOSTS`.
         *
         * For more information, see [Storage class considerations with Amazon S3 transfers](https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes).
         */
        public var s3StorageClass: aws.sdk.kotlin.services.datasync.model.S3StorageClass? = null
        /**
         * Specifies a prefix in the S3 bucket that DataSync reads from or writes to (depending on whether the bucket is a source or destination location).
         *
         * DataSync can't transfer objects with a prefix that begins with a slash (`/`) or includes `//`, `/./`, or `/../` patterns. For example:
         * + `/photos`
         * + `photos//2006/January`
         * + `photos/./2006/February`
         * + `photos/../2006/March`
         */
        public var subdirectory: kotlin.String? = null
        /**
         * Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We recommend creating at least a name tag for your transfer location.
         */
        public var tags: List<TagListEntry>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.CreateLocationS3Request) : this() {
            this.agentArns = x.agentArns
            this.s3BucketArn = x.s3BucketArn
            this.s3Config = x.s3Config
            this.s3StorageClass = x.s3StorageClass
            this.subdirectory = x.subdirectory
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.CreateLocationS3Request = CreateLocationS3Request(this)

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.S3Config] inside the given [block]
         */
        public fun s3Config(block: aws.sdk.kotlin.services.datasync.model.S3Config.Builder.() -> kotlin.Unit) {
            this.s3Config = aws.sdk.kotlin.services.datasync.model.S3Config.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
