// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The shared access signature (SAS) configuration that allows DataSync to access your Microsoft Azure Blob Storage.
 *
 * For more information, see [SAS tokens](https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-sas-tokens) for accessing your Azure Blob Storage.
 */
public class AzureBlobSasConfiguration private constructor(builder: Builder) {
    /**
     * Specifies a SAS token that provides permissions to access your Azure Blob Storage.
     *
     * The token is part of the SAS URI string that comes after the storage resource URI and a question mark. A token looks something like this:
     *
     * `sp=r&st=2023-12-20T14:54:52Z&se=2023-12-20T22:54:52Z&spr=https&sv=2021-06-08&sr=c&sig=aBBKDWQvyuVcTPH9EBp%2FXTI9E%2F%2Fmq171%2BZU178wcwqU%3D`
     */
    public val token: kotlin.String = requireNotNull(builder.token) { "A non-null value must be provided for token" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.AzureBlobSasConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AzureBlobSasConfiguration(")
        append("token=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = token.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AzureBlobSasConfiguration

        if (token != other.token) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.AzureBlobSasConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies a SAS token that provides permissions to access your Azure Blob Storage.
         *
         * The token is part of the SAS URI string that comes after the storage resource URI and a question mark. A token looks something like this:
         *
         * `sp=r&st=2023-12-20T14:54:52Z&se=2023-12-20T22:54:52Z&spr=https&sv=2021-06-08&sr=c&sig=aBBKDWQvyuVcTPH9EBp%2FXTI9E%2F%2Fmq171%2BZU178wcwqU%3D`
         */
        public var token: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.AzureBlobSasConfiguration) : this() {
            this.token = x.token
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.AzureBlobSasConfiguration = AzureBlobSasConfiguration(this)

        internal fun correctErrors(): Builder {
            if (token == null) token = ""
            return this
        }
    }
}
