// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.datasync.auth.DataSyncAuthSchemeProvider
import aws.sdk.kotlin.services.datasync.auth.DefaultDataSyncAuthSchemeProvider
import aws.sdk.kotlin.services.datasync.endpoints.DataSyncEndpointParameters
import aws.sdk.kotlin.services.datasync.endpoints.DataSyncEndpointProvider
import aws.sdk.kotlin.services.datasync.endpoints.DefaultDataSyncEndpointProvider
import aws.sdk.kotlin.services.datasync.model.AddStorageSystemRequest
import aws.sdk.kotlin.services.datasync.model.AddStorageSystemResponse
import aws.sdk.kotlin.services.datasync.model.CancelTaskExecutionRequest
import aws.sdk.kotlin.services.datasync.model.CancelTaskExecutionResponse
import aws.sdk.kotlin.services.datasync.model.CreateAgentRequest
import aws.sdk.kotlin.services.datasync.model.CreateAgentResponse
import aws.sdk.kotlin.services.datasync.model.CreateLocationAzureBlobRequest
import aws.sdk.kotlin.services.datasync.model.CreateLocationAzureBlobResponse
import aws.sdk.kotlin.services.datasync.model.CreateLocationEfsRequest
import aws.sdk.kotlin.services.datasync.model.CreateLocationEfsResponse
import aws.sdk.kotlin.services.datasync.model.CreateLocationFsxLustreRequest
import aws.sdk.kotlin.services.datasync.model.CreateLocationFsxLustreResponse
import aws.sdk.kotlin.services.datasync.model.CreateLocationFsxOntapRequest
import aws.sdk.kotlin.services.datasync.model.CreateLocationFsxOntapResponse
import aws.sdk.kotlin.services.datasync.model.CreateLocationFsxOpenZfsRequest
import aws.sdk.kotlin.services.datasync.model.CreateLocationFsxOpenZfsResponse
import aws.sdk.kotlin.services.datasync.model.CreateLocationFsxWindowsRequest
import aws.sdk.kotlin.services.datasync.model.CreateLocationFsxWindowsResponse
import aws.sdk.kotlin.services.datasync.model.CreateLocationHdfsRequest
import aws.sdk.kotlin.services.datasync.model.CreateLocationHdfsResponse
import aws.sdk.kotlin.services.datasync.model.CreateLocationNfsRequest
import aws.sdk.kotlin.services.datasync.model.CreateLocationNfsResponse
import aws.sdk.kotlin.services.datasync.model.CreateLocationObjectStorageRequest
import aws.sdk.kotlin.services.datasync.model.CreateLocationObjectStorageResponse
import aws.sdk.kotlin.services.datasync.model.CreateLocationS3Request
import aws.sdk.kotlin.services.datasync.model.CreateLocationS3Response
import aws.sdk.kotlin.services.datasync.model.CreateLocationSmbRequest
import aws.sdk.kotlin.services.datasync.model.CreateLocationSmbResponse
import aws.sdk.kotlin.services.datasync.model.CreateTaskRequest
import aws.sdk.kotlin.services.datasync.model.CreateTaskResponse
import aws.sdk.kotlin.services.datasync.model.DeleteAgentRequest
import aws.sdk.kotlin.services.datasync.model.DeleteAgentResponse
import aws.sdk.kotlin.services.datasync.model.DeleteLocationRequest
import aws.sdk.kotlin.services.datasync.model.DeleteLocationResponse
import aws.sdk.kotlin.services.datasync.model.DeleteTaskRequest
import aws.sdk.kotlin.services.datasync.model.DeleteTaskResponse
import aws.sdk.kotlin.services.datasync.model.DescribeAgentRequest
import aws.sdk.kotlin.services.datasync.model.DescribeAgentResponse
import aws.sdk.kotlin.services.datasync.model.DescribeDiscoveryJobRequest
import aws.sdk.kotlin.services.datasync.model.DescribeDiscoveryJobResponse
import aws.sdk.kotlin.services.datasync.model.DescribeLocationAzureBlobRequest
import aws.sdk.kotlin.services.datasync.model.DescribeLocationAzureBlobResponse
import aws.sdk.kotlin.services.datasync.model.DescribeLocationEfsRequest
import aws.sdk.kotlin.services.datasync.model.DescribeLocationEfsResponse
import aws.sdk.kotlin.services.datasync.model.DescribeLocationFsxLustreRequest
import aws.sdk.kotlin.services.datasync.model.DescribeLocationFsxLustreResponse
import aws.sdk.kotlin.services.datasync.model.DescribeLocationFsxOntapRequest
import aws.sdk.kotlin.services.datasync.model.DescribeLocationFsxOntapResponse
import aws.sdk.kotlin.services.datasync.model.DescribeLocationFsxOpenZfsRequest
import aws.sdk.kotlin.services.datasync.model.DescribeLocationFsxOpenZfsResponse
import aws.sdk.kotlin.services.datasync.model.DescribeLocationFsxWindowsRequest
import aws.sdk.kotlin.services.datasync.model.DescribeLocationFsxWindowsResponse
import aws.sdk.kotlin.services.datasync.model.DescribeLocationHdfsRequest
import aws.sdk.kotlin.services.datasync.model.DescribeLocationHdfsResponse
import aws.sdk.kotlin.services.datasync.model.DescribeLocationNfsRequest
import aws.sdk.kotlin.services.datasync.model.DescribeLocationNfsResponse
import aws.sdk.kotlin.services.datasync.model.DescribeLocationObjectStorageRequest
import aws.sdk.kotlin.services.datasync.model.DescribeLocationObjectStorageResponse
import aws.sdk.kotlin.services.datasync.model.DescribeLocationS3Request
import aws.sdk.kotlin.services.datasync.model.DescribeLocationS3Response
import aws.sdk.kotlin.services.datasync.model.DescribeLocationSmbRequest
import aws.sdk.kotlin.services.datasync.model.DescribeLocationSmbResponse
import aws.sdk.kotlin.services.datasync.model.DescribeStorageSystemRequest
import aws.sdk.kotlin.services.datasync.model.DescribeStorageSystemResourceMetricsRequest
import aws.sdk.kotlin.services.datasync.model.DescribeStorageSystemResourceMetricsResponse
import aws.sdk.kotlin.services.datasync.model.DescribeStorageSystemResourcesRequest
import aws.sdk.kotlin.services.datasync.model.DescribeStorageSystemResourcesResponse
import aws.sdk.kotlin.services.datasync.model.DescribeStorageSystemResponse
import aws.sdk.kotlin.services.datasync.model.DescribeTaskExecutionRequest
import aws.sdk.kotlin.services.datasync.model.DescribeTaskExecutionResponse
import aws.sdk.kotlin.services.datasync.model.DescribeTaskRequest
import aws.sdk.kotlin.services.datasync.model.DescribeTaskResponse
import aws.sdk.kotlin.services.datasync.model.GenerateRecommendationsRequest
import aws.sdk.kotlin.services.datasync.model.GenerateRecommendationsResponse
import aws.sdk.kotlin.services.datasync.model.ListAgentsRequest
import aws.sdk.kotlin.services.datasync.model.ListAgentsResponse
import aws.sdk.kotlin.services.datasync.model.ListDiscoveryJobsRequest
import aws.sdk.kotlin.services.datasync.model.ListDiscoveryJobsResponse
import aws.sdk.kotlin.services.datasync.model.ListLocationsRequest
import aws.sdk.kotlin.services.datasync.model.ListLocationsResponse
import aws.sdk.kotlin.services.datasync.model.ListStorageSystemsRequest
import aws.sdk.kotlin.services.datasync.model.ListStorageSystemsResponse
import aws.sdk.kotlin.services.datasync.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.datasync.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.datasync.model.ListTaskExecutionsRequest
import aws.sdk.kotlin.services.datasync.model.ListTaskExecutionsResponse
import aws.sdk.kotlin.services.datasync.model.ListTasksRequest
import aws.sdk.kotlin.services.datasync.model.ListTasksResponse
import aws.sdk.kotlin.services.datasync.model.RemoveStorageSystemRequest
import aws.sdk.kotlin.services.datasync.model.RemoveStorageSystemResponse
import aws.sdk.kotlin.services.datasync.model.StartDiscoveryJobRequest
import aws.sdk.kotlin.services.datasync.model.StartDiscoveryJobResponse
import aws.sdk.kotlin.services.datasync.model.StartTaskExecutionRequest
import aws.sdk.kotlin.services.datasync.model.StartTaskExecutionResponse
import aws.sdk.kotlin.services.datasync.model.StopDiscoveryJobRequest
import aws.sdk.kotlin.services.datasync.model.StopDiscoveryJobResponse
import aws.sdk.kotlin.services.datasync.model.TagResourceRequest
import aws.sdk.kotlin.services.datasync.model.TagResourceResponse
import aws.sdk.kotlin.services.datasync.model.UntagResourceRequest
import aws.sdk.kotlin.services.datasync.model.UntagResourceResponse
import aws.sdk.kotlin.services.datasync.model.UpdateAgentRequest
import aws.sdk.kotlin.services.datasync.model.UpdateAgentResponse
import aws.sdk.kotlin.services.datasync.model.UpdateDiscoveryJobRequest
import aws.sdk.kotlin.services.datasync.model.UpdateDiscoveryJobResponse
import aws.sdk.kotlin.services.datasync.model.UpdateLocationAzureBlobRequest
import aws.sdk.kotlin.services.datasync.model.UpdateLocationAzureBlobResponse
import aws.sdk.kotlin.services.datasync.model.UpdateLocationHdfsRequest
import aws.sdk.kotlin.services.datasync.model.UpdateLocationHdfsResponse
import aws.sdk.kotlin.services.datasync.model.UpdateLocationNfsRequest
import aws.sdk.kotlin.services.datasync.model.UpdateLocationNfsResponse
import aws.sdk.kotlin.services.datasync.model.UpdateLocationObjectStorageRequest
import aws.sdk.kotlin.services.datasync.model.UpdateLocationObjectStorageResponse
import aws.sdk.kotlin.services.datasync.model.UpdateLocationSmbRequest
import aws.sdk.kotlin.services.datasync.model.UpdateLocationSmbResponse
import aws.sdk.kotlin.services.datasync.model.UpdateStorageSystemRequest
import aws.sdk.kotlin.services.datasync.model.UpdateStorageSystemResponse
import aws.sdk.kotlin.services.datasync.model.UpdateTaskExecutionRequest
import aws.sdk.kotlin.services.datasync.model.UpdateTaskExecutionResponse
import aws.sdk.kotlin.services.datasync.model.UpdateTaskRequest
import aws.sdk.kotlin.services.datasync.model.UpdateTaskResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "DataSync"
public const val SdkVersion: String = "1.3.67"
public const val ServiceApiVersion: String = "2018-11-09"

/**
 * # DataSync
 * DataSync is an online data movement and discovery service that simplifies data migration and helps you quickly, easily, and securely transfer your file or object data to, from, and between Amazon Web Services storage services.
 *
 * This API interface reference includes documentation for using DataSync programmatically. For complete information, see the *[DataSync User Guide](https://docs.aws.amazon.com/datasync/latest/userguide/what-is-datasync.html)*.
 */
public interface DataSyncClient : SdkClient {
    /**
     * DataSyncClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, DataSyncClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "DataSync",
                "DATASYNC",
                "datasync",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, DataSyncClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): DataSyncClient = DefaultDataSyncClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: DataSyncEndpointProvider = builder.endpointProvider ?: DefaultDataSyncEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: DataSyncAuthSchemeProvider = builder.authSchemeProvider ?: DefaultDataSyncAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "DataSync"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: DataSyncEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: DataSyncAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates an Amazon Web Services resource for an on-premises storage system that you want DataSync Discovery to collect information about.
     */
    public suspend fun addStorageSystem(input: AddStorageSystemRequest): AddStorageSystemResponse

    /**
     * Stops an DataSync task execution that's in progress. The transfer of some files are abruptly interrupted. File contents that're transferred to the destination might be incomplete or inconsistent with the source files.
     *
     * However, if you start a new task execution using the same task and allow it to finish, file content on the destination will be complete and consistent. This applies to other unexpected failures that interrupt a task execution. In all of these cases, DataSync successfully completes the transfer when you start the next task execution.
     */
    public suspend fun cancelTaskExecution(input: CancelTaskExecutionRequest): CancelTaskExecutionResponse

    /**
     * Activates an DataSync agent that you deploy in your storage environment. The activation process associates the agent with your Amazon Web Services account.
     *
     * If you haven't deployed an agent yet, see [Do I need a DataSync agent?](https://docs.aws.amazon.com/datasync/latest/userguide/do-i-need-datasync-agent.html)
     */
    public suspend fun createAgent(input: CreateAgentRequest): CreateAgentResponse

    /**
     * Creates a transfer *location* for a Microsoft Azure Blob Storage container. DataSync can use this location as a transfer source or destination.
     *
     * Before you begin, make sure you know [how DataSync accesses Azure Blob Storage](https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-access) and works with [access tiers](https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-access-tiers) and [blob types](https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#blob-types). You also need a [DataSync agent](https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-creating-agent) that can connect to your container.
     */
    public suspend fun createLocationAzureBlob(input: CreateLocationAzureBlobRequest): CreateLocationAzureBlobResponse

    /**
     * Creates a transfer *location* for an Amazon EFS file system. DataSync can use this location as a source or destination for transferring data.
     *
     * Before you begin, make sure that you understand how DataSync [accesses Amazon EFS file systems](https://docs.aws.amazon.com/datasync/latest/userguide/create-efs-location.html#create-efs-location-access).
     */
    public suspend fun createLocationEfs(input: CreateLocationEfsRequest): CreateLocationEfsResponse

    /**
     * Creates a transfer *location* for an Amazon FSx for Lustre file system. DataSync can use this location as a source or destination for transferring data.
     *
     * Before you begin, make sure that you understand how DataSync [accesses FSx for Lustre file systems](https://docs.aws.amazon.com/datasync/latest/userguide/create-lustre-location.html#create-lustre-location-access).
     */
    public suspend fun createLocationFsxLustre(input: CreateLocationFsxLustreRequest): CreateLocationFsxLustreResponse

    /**
     * Creates a transfer *location* for an Amazon FSx for NetApp ONTAP file system. DataSync can use this location as a source or destination for transferring data.
     *
     * Before you begin, make sure that you understand how DataSync [accesses FSx for ONTAP file systems](https://docs.aws.amazon.com/datasync/latest/userguide/create-ontap-location.html#create-ontap-location-access).
     */
    public suspend fun createLocationFsxOntap(input: CreateLocationFsxOntapRequest): CreateLocationFsxOntapResponse

    /**
     * Creates a transfer *location* for an Amazon FSx for OpenZFS file system. DataSync can use this location as a source or destination for transferring data.
     *
     * Before you begin, make sure that you understand how DataSync [accesses FSx for OpenZFS file systems](https://docs.aws.amazon.com/datasync/latest/userguide/create-openzfs-location.html#create-openzfs-access).
     *
     * Request parameters related to `SMB` aren't supported with the `CreateLocationFsxOpenZfs` operation.
     */
    public suspend fun createLocationFsxOpenZfs(input: CreateLocationFsxOpenZfsRequest): CreateLocationFsxOpenZfsResponse

    /**
     * Creates a transfer *location* for an Amazon FSx for Windows File Server file system. DataSync can use this location as a source or destination for transferring data.
     *
     * Before you begin, make sure that you understand how DataSync [accesses FSx for Windows File Server file systems](https://docs.aws.amazon.com/datasync/latest/userguide/create-fsx-location.html#create-fsx-location-access).
     */
    public suspend fun createLocationFsxWindows(input: CreateLocationFsxWindowsRequest): CreateLocationFsxWindowsResponse

    /**
     * Creates a transfer *location* for a Hadoop Distributed File System (HDFS). DataSync can use this location as a source or destination for transferring data.
     *
     * Before you begin, make sure that you understand how DataSync [accesses HDFS clusters](https://docs.aws.amazon.com/datasync/latest/userguide/create-hdfs-location.html#accessing-hdfs).
     */
    public suspend fun createLocationHdfs(input: CreateLocationHdfsRequest): CreateLocationHdfsResponse

    /**
     * Creates a transfer *location* for a Network File System (NFS) file server. DataSync can use this location as a source or destination for transferring data.
     *
     * Before you begin, make sure that you understand how DataSync [accesses NFS file servers](https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#accessing-nfs).
     *
     * If you're copying data to or from an Snowcone device, you can also use `CreateLocationNfs` to create your transfer location. For more information, see [Configuring transfers with Snowcone](https://docs.aws.amazon.com/datasync/latest/userguide/nfs-on-snowcone.html).
     */
    public suspend fun createLocationNfs(input: CreateLocationNfsRequest): CreateLocationNfsResponse

    /**
     * Creates a transfer *location* for an object storage system. DataSync can use this location as a source or destination for transferring data.
     *
     * Before you begin, make sure that you understand the [prerequisites](https://docs.aws.amazon.com/datasync/latest/userguide/create-object-location.html#create-object-location-prerequisites) for DataSync to work with object storage systems.
     */
    public suspend fun createLocationObjectStorage(input: CreateLocationObjectStorageRequest): CreateLocationObjectStorageResponse

    /**
     * Creates a transfer *location* for an Amazon S3 bucket. DataSync can use this location as a source or destination for transferring data.
     *
     * Before you begin, make sure that you read the following topics:
     * + [Storage class considerations with Amazon S3 locations](https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes)
     * + [Evaluating S3 request costs when using DataSync](https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#create-s3-location-s3-requests)
     *  For more information, see [Configuring transfers with Amazon S3](https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html).
     */
    public suspend fun createLocationS3(input: CreateLocationS3Request): CreateLocationS3Response

    /**
     * Creates a transfer *location* for a Server Message Block (SMB) file server. DataSync can use this location as a source or destination for transferring data.
     *
     * Before you begin, make sure that you understand how DataSync [accesses SMB file servers](https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#configuring-smb).
     */
    public suspend fun createLocationSmb(input: CreateLocationSmbRequest): CreateLocationSmbResponse

    /**
     * Configures a *task*, which defines where and how DataSync transfers your data.
     *
     * A task includes a source location, destination location, and transfer options (such as bandwidth limits, scheduling, and more).
     *
     * If you're planning to transfer data to or from an Amazon S3 location, review [how DataSync can affect your S3 request charges](https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#create-s3-location-s3-requests) and the [DataSync pricing page](http://aws.amazon.com/datasync/pricing/) before you begin.
     */
    public suspend fun createTask(input: CreateTaskRequest): CreateTaskResponse

    /**
     * Removes an DataSync agent resource from your Amazon Web Services account.
     *
     * Keep in mind that this operation (which can't be undone) doesn't remove the agent's virtual machine (VM) or Amazon EC2 instance from your storage environment. For next steps, you can delete the VM or instance from your storage environment or reuse it to [activate a new agent](https://docs.aws.amazon.com/datasync/latest/userguide/activate-agent.html).
     */
    public suspend fun deleteAgent(input: DeleteAgentRequest): DeleteAgentResponse

    /**
     * Deletes a transfer location resource from DataSync.
     */
    public suspend fun deleteLocation(input: DeleteLocationRequest): DeleteLocationResponse

    /**
     * Deletes a transfer task resource from DataSync.
     */
    public suspend fun deleteTask(input: DeleteTaskRequest): DeleteTaskResponse

    /**
     * Returns information about an DataSync agent, such as its name, service endpoint type, and status.
     */
    public suspend fun describeAgent(input: DescribeAgentRequest): DescribeAgentResponse

    /**
     * Returns information about a DataSync discovery job.
     */
    public suspend fun describeDiscoveryJob(input: DescribeDiscoveryJobRequest): DescribeDiscoveryJobResponse

    /**
     * Provides details about how an DataSync transfer location for Microsoft Azure Blob Storage is configured.
     */
    public suspend fun describeLocationAzureBlob(input: DescribeLocationAzureBlobRequest): DescribeLocationAzureBlobResponse

    /**
     * Provides details about how an DataSync transfer location for an Amazon EFS file system is configured.
     */
    public suspend fun describeLocationEfs(input: DescribeLocationEfsRequest): DescribeLocationEfsResponse

    /**
     * Provides details about how an DataSync transfer location for an Amazon FSx for Lustre file system is configured.
     */
    public suspend fun describeLocationFsxLustre(input: DescribeLocationFsxLustreRequest): DescribeLocationFsxLustreResponse

    /**
     * Provides details about how an DataSync transfer location for an Amazon FSx for NetApp ONTAP file system is configured.
     *
     * If your location uses SMB, the `DescribeLocationFsxOntap` operation doesn't actually return a `Password`.
     */
    public suspend fun describeLocationFsxOntap(input: DescribeLocationFsxOntapRequest): DescribeLocationFsxOntapResponse

    /**
     * Provides details about how an DataSync transfer location for an Amazon FSx for OpenZFS file system is configured.
     *
     * Response elements related to `SMB` aren't supported with the `DescribeLocationFsxOpenZfs` operation.
     */
    public suspend fun describeLocationFsxOpenZfs(input: DescribeLocationFsxOpenZfsRequest): DescribeLocationFsxOpenZfsResponse

    /**
     * Provides details about how an DataSync transfer location for an Amazon FSx for Windows File Server file system is configured.
     */
    public suspend fun describeLocationFsxWindows(input: DescribeLocationFsxWindowsRequest): DescribeLocationFsxWindowsResponse

    /**
     * Provides details about how an DataSync transfer location for a Hadoop Distributed File System (HDFS) is configured.
     */
    public suspend fun describeLocationHdfs(input: DescribeLocationHdfsRequest): DescribeLocationHdfsResponse

    /**
     * Provides details about how an DataSync transfer location for a Network File System (NFS) file server is configured.
     */
    public suspend fun describeLocationNfs(input: DescribeLocationNfsRequest): DescribeLocationNfsResponse

    /**
     * Provides details about how an DataSync transfer location for an object storage system is configured.
     */
    public suspend fun describeLocationObjectStorage(input: DescribeLocationObjectStorageRequest): DescribeLocationObjectStorageResponse

    /**
     * Provides details about how an DataSync transfer location for an S3 bucket is configured.
     */
    public suspend fun describeLocationS3(input: DescribeLocationS3Request): DescribeLocationS3Response

    /**
     * Provides details about how an DataSync transfer location for a Server Message Block (SMB) file server is configured.
     */
    public suspend fun describeLocationSmb(input: DescribeLocationSmbRequest): DescribeLocationSmbResponse

    /**
     * Returns information about an on-premises storage system that you're using with DataSync Discovery.
     */
    public suspend fun describeStorageSystem(input: DescribeStorageSystemRequest): DescribeStorageSystemResponse

    /**
     * Returns information, including performance data and capacity usage, which DataSync Discovery collects about a specific resource in your-premises storage system.
     */
    public suspend fun describeStorageSystemResourceMetrics(input: DescribeStorageSystemResourceMetricsRequest): DescribeStorageSystemResourceMetricsResponse

    /**
     * Returns information that DataSync Discovery collects about resources in your on-premises storage system.
     */
    public suspend fun describeStorageSystemResources(input: DescribeStorageSystemResourcesRequest): DescribeStorageSystemResourcesResponse

    /**
     * Provides information about a *task*, which defines where and how DataSync transfers your data.
     */
    public suspend fun describeTask(input: DescribeTaskRequest): DescribeTaskResponse

    /**
     * Provides information about an execution of your DataSync task. You can use this operation to help monitor the progress of an ongoing data transfer or check the results of the transfer.
     *
     * Some `DescribeTaskExecution` response elements are only relevant to a specific task mode. For information, see [Understanding task mode differences](https://docs.aws.amazon.com/datasync/latest/userguide/choosing-task-mode.html#task-mode-differences) and [Understanding data transfer performance metrics](https://docs.aws.amazon.com/datasync/latest/userguide/transfer-performance-metrics.html).
     */
    public suspend fun describeTaskExecution(input: DescribeTaskExecutionRequest): DescribeTaskExecutionResponse

    /**
     * Creates recommendations about where to migrate your data to in Amazon Web Services. Recommendations are generated based on information that DataSync Discovery collects about your on-premises storage system's resources. For more information, see [Recommendations provided by DataSync Discovery](https://docs.aws.amazon.com/datasync/latest/userguide/discovery-understand-recommendations.html).
     *
     * Once generated, you can view your recommendations by using the [DescribeStorageSystemResources](https://docs.aws.amazon.com/datasync/latest/userguide/API_DescribeStorageSystemResources.html) operation.
     */
    public suspend fun generateRecommendations(input: GenerateRecommendationsRequest): GenerateRecommendationsResponse

    /**
     * Returns a list of DataSync agents that belong to an Amazon Web Services account in the Amazon Web Services Region specified in the request.
     *
     * With pagination, you can reduce the number of agents returned in a response. If you get a truncated list of agents in a response, the response contains a marker that you can specify in your next request to fetch the next page of agents.
     *
     * `ListAgents` is eventually consistent. This means the result of running the operation might not reflect that you just created or deleted an agent. For example, if you create an agent with [CreateAgent](https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateAgent.html) and then immediately run `ListAgents`, that agent might not show up in the list right away. In situations like this, you can always confirm whether an agent has been created (or deleted) by using [DescribeAgent](https://docs.aws.amazon.com/datasync/latest/userguide/API_DescribeAgent.html).
     */
    public suspend fun listAgents(input: ListAgentsRequest = ListAgentsRequest { }): ListAgentsResponse

    /**
     * Provides a list of the existing discovery jobs in the Amazon Web Services Region and Amazon Web Services account where you're using DataSync Discovery.
     */
    public suspend fun listDiscoveryJobs(input: ListDiscoveryJobsRequest = ListDiscoveryJobsRequest { }): ListDiscoveryJobsResponse

    /**
     * Returns a list of source and destination locations.
     *
     * If you have more locations than are returned in a response (that is, the response returns only a truncated list of your agents), the response contains a token that you can specify in your next request to fetch the next page of locations.
     */
    public suspend fun listLocations(input: ListLocationsRequest = ListLocationsRequest { }): ListLocationsResponse

    /**
     * Lists the on-premises storage systems that you're using with DataSync Discovery.
     */
    public suspend fun listStorageSystems(input: ListStorageSystemsRequest = ListStorageSystemsRequest { }): ListStorageSystemsResponse

    /**
     * Returns all the tags associated with an Amazon Web Services resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Returns a list of executions for an DataSync transfer task.
     */
    public suspend fun listTaskExecutions(input: ListTaskExecutionsRequest = ListTaskExecutionsRequest { }): ListTaskExecutionsResponse

    /**
     * Returns a list of the DataSync tasks you created.
     */
    public suspend fun listTasks(input: ListTasksRequest = ListTasksRequest { }): ListTasksResponse

    /**
     * Permanently removes a storage system resource from DataSync Discovery, including the associated discovery jobs, collected data, and recommendations.
     */
    public suspend fun removeStorageSystem(input: RemoveStorageSystemRequest): RemoveStorageSystemResponse

    /**
     * Runs a DataSync discovery job on your on-premises storage system. If you haven't added the storage system to DataSync Discovery yet, do this first by using the [AddStorageSystem](https://docs.aws.amazon.com/datasync/latest/userguide/API_AddStorageSystem.html) operation.
     */
    public suspend fun startDiscoveryJob(input: StartDiscoveryJobRequest): StartDiscoveryJobResponse

    /**
     * Starts an DataSync transfer task. For each task, you can only run one task execution at a time.
     *
     * There are several steps to a task execution. For more information, see [Task execution statuses](https://docs.aws.amazon.com/datasync/latest/userguide/working-with-task-executions.html#understand-task-execution-statuses).
     *
     * If you're planning to transfer data to or from an Amazon S3 location, review [how DataSync can affect your S3 request charges](https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#create-s3-location-s3-requests) and the [DataSync pricing page](http://aws.amazon.com/datasync/pricing/) before you begin.
     */
    public suspend fun startTaskExecution(input: StartTaskExecutionRequest): StartTaskExecutionResponse

    /**
     * Stops a running DataSync discovery job.
     *
     * You can stop a discovery job anytime. A job that's stopped before it's scheduled to end likely will provide you some information about your on-premises storage system resources. To get recommendations for a stopped job, you must use the [GenerateRecommendations](https://docs.aws.amazon.com/datasync/latest/userguide/API_GenerateRecommendations.html) operation.
     */
    public suspend fun stopDiscoveryJob(input: StopDiscoveryJobRequest): StopDiscoveryJobResponse

    /**
     * Applies a *tag* to an Amazon Web Services resource. Tags are key-value pairs that can help you manage, filter, and search for your resources.
     *
     * These include DataSync resources, such as locations, tasks, and task executions.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from an Amazon Web Services resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the name of an DataSync agent.
     */
    public suspend fun updateAgent(input: UpdateAgentRequest): UpdateAgentResponse

    /**
     * Edits a DataSync discovery job configuration.
     */
    public suspend fun updateDiscoveryJob(input: UpdateDiscoveryJobRequest): UpdateDiscoveryJobResponse

    /**
     * Modifies some configurations of the Microsoft Azure Blob Storage transfer location that you're using with DataSync.
     */
    public suspend fun updateLocationAzureBlob(input: UpdateLocationAzureBlobRequest): UpdateLocationAzureBlobResponse

    /**
     * Updates some parameters of a previously created location for a Hadoop Distributed File System cluster.
     */
    public suspend fun updateLocationHdfs(input: UpdateLocationHdfsRequest): UpdateLocationHdfsResponse

    /**
     * Modifies some configurations of the Network File System (NFS) transfer location that you're using with DataSync.
     *
     * For more information, see [Configuring transfers to or from an NFS file server](https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html).
     */
    public suspend fun updateLocationNfs(input: UpdateLocationNfsRequest): UpdateLocationNfsResponse

    /**
     * Updates some parameters of an existing DataSync location for an object storage system.
     */
    public suspend fun updateLocationObjectStorage(input: UpdateLocationObjectStorageRequest): UpdateLocationObjectStorageResponse

    /**
     * Updates some of the parameters of a Server Message Block (SMB) file server location that you can use for DataSync transfers.
     */
    public suspend fun updateLocationSmb(input: UpdateLocationSmbRequest): UpdateLocationSmbResponse

    /**
     * Modifies some configurations of an on-premises storage system resource that you're using with DataSync Discovery.
     */
    public suspend fun updateStorageSystem(input: UpdateStorageSystemRequest): UpdateStorageSystemResponse

    /**
     * Updates the configuration of a *task*, which defines where and how DataSync transfers your data.
     */
    public suspend fun updateTask(input: UpdateTaskRequest): UpdateTaskResponse

    /**
     * Updates the configuration of a running DataSync task execution.
     *
     * Currently, the only `Option` that you can modify with `UpdateTaskExecution` is ` <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_Options.html#DataSync-Type-Options-BytesPerSecond">BytesPerSecond</a> `, which throttles bandwidth for a running or queued task execution.
     */
    public suspend fun updateTaskExecution(input: UpdateTaskExecutionRequest): UpdateTaskExecutionResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun DataSyncClient.withConfig(block: DataSyncClient.Config.Builder.() -> Unit): DataSyncClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultDataSyncClient(newConfig)
}

/**
 * Creates an Amazon Web Services resource for an on-premises storage system that you want DataSync Discovery to collect information about.
 */
public suspend inline fun DataSyncClient.addStorageSystem(crossinline block: AddStorageSystemRequest.Builder.() -> Unit): AddStorageSystemResponse = addStorageSystem(AddStorageSystemRequest.Builder().apply(block).build())

/**
 * Stops an DataSync task execution that's in progress. The transfer of some files are abruptly interrupted. File contents that're transferred to the destination might be incomplete or inconsistent with the source files.
 *
 * However, if you start a new task execution using the same task and allow it to finish, file content on the destination will be complete and consistent. This applies to other unexpected failures that interrupt a task execution. In all of these cases, DataSync successfully completes the transfer when you start the next task execution.
 */
public suspend inline fun DataSyncClient.cancelTaskExecution(crossinline block: CancelTaskExecutionRequest.Builder.() -> Unit): CancelTaskExecutionResponse = cancelTaskExecution(CancelTaskExecutionRequest.Builder().apply(block).build())

/**
 * Activates an DataSync agent that you deploy in your storage environment. The activation process associates the agent with your Amazon Web Services account.
 *
 * If you haven't deployed an agent yet, see [Do I need a DataSync agent?](https://docs.aws.amazon.com/datasync/latest/userguide/do-i-need-datasync-agent.html)
 */
public suspend inline fun DataSyncClient.createAgent(crossinline block: CreateAgentRequest.Builder.() -> Unit): CreateAgentResponse = createAgent(CreateAgentRequest.Builder().apply(block).build())

/**
 * Creates a transfer *location* for a Microsoft Azure Blob Storage container. DataSync can use this location as a transfer source or destination.
 *
 * Before you begin, make sure you know [how DataSync accesses Azure Blob Storage](https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-access) and works with [access tiers](https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-access-tiers) and [blob types](https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#blob-types). You also need a [DataSync agent](https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-creating-agent) that can connect to your container.
 */
public suspend inline fun DataSyncClient.createLocationAzureBlob(crossinline block: CreateLocationAzureBlobRequest.Builder.() -> Unit): CreateLocationAzureBlobResponse = createLocationAzureBlob(CreateLocationAzureBlobRequest.Builder().apply(block).build())

/**
 * Creates a transfer *location* for an Amazon EFS file system. DataSync can use this location as a source or destination for transferring data.
 *
 * Before you begin, make sure that you understand how DataSync [accesses Amazon EFS file systems](https://docs.aws.amazon.com/datasync/latest/userguide/create-efs-location.html#create-efs-location-access).
 */
public suspend inline fun DataSyncClient.createLocationEfs(crossinline block: CreateLocationEfsRequest.Builder.() -> Unit): CreateLocationEfsResponse = createLocationEfs(CreateLocationEfsRequest.Builder().apply(block).build())

/**
 * Creates a transfer *location* for an Amazon FSx for Lustre file system. DataSync can use this location as a source or destination for transferring data.
 *
 * Before you begin, make sure that you understand how DataSync [accesses FSx for Lustre file systems](https://docs.aws.amazon.com/datasync/latest/userguide/create-lustre-location.html#create-lustre-location-access).
 */
public suspend inline fun DataSyncClient.createLocationFsxLustre(crossinline block: CreateLocationFsxLustreRequest.Builder.() -> Unit): CreateLocationFsxLustreResponse = createLocationFsxLustre(CreateLocationFsxLustreRequest.Builder().apply(block).build())

/**
 * Creates a transfer *location* for an Amazon FSx for NetApp ONTAP file system. DataSync can use this location as a source or destination for transferring data.
 *
 * Before you begin, make sure that you understand how DataSync [accesses FSx for ONTAP file systems](https://docs.aws.amazon.com/datasync/latest/userguide/create-ontap-location.html#create-ontap-location-access).
 */
public suspend inline fun DataSyncClient.createLocationFsxOntap(crossinline block: CreateLocationFsxOntapRequest.Builder.() -> Unit): CreateLocationFsxOntapResponse = createLocationFsxOntap(CreateLocationFsxOntapRequest.Builder().apply(block).build())

/**
 * Creates a transfer *location* for an Amazon FSx for OpenZFS file system. DataSync can use this location as a source or destination for transferring data.
 *
 * Before you begin, make sure that you understand how DataSync [accesses FSx for OpenZFS file systems](https://docs.aws.amazon.com/datasync/latest/userguide/create-openzfs-location.html#create-openzfs-access).
 *
 * Request parameters related to `SMB` aren't supported with the `CreateLocationFsxOpenZfs` operation.
 */
public suspend inline fun DataSyncClient.createLocationFsxOpenZfs(crossinline block: CreateLocationFsxOpenZfsRequest.Builder.() -> Unit): CreateLocationFsxOpenZfsResponse = createLocationFsxOpenZfs(CreateLocationFsxOpenZfsRequest.Builder().apply(block).build())

/**
 * Creates a transfer *location* for an Amazon FSx for Windows File Server file system. DataSync can use this location as a source or destination for transferring data.
 *
 * Before you begin, make sure that you understand how DataSync [accesses FSx for Windows File Server file systems](https://docs.aws.amazon.com/datasync/latest/userguide/create-fsx-location.html#create-fsx-location-access).
 */
public suspend inline fun DataSyncClient.createLocationFsxWindows(crossinline block: CreateLocationFsxWindowsRequest.Builder.() -> Unit): CreateLocationFsxWindowsResponse = createLocationFsxWindows(CreateLocationFsxWindowsRequest.Builder().apply(block).build())

/**
 * Creates a transfer *location* for a Hadoop Distributed File System (HDFS). DataSync can use this location as a source or destination for transferring data.
 *
 * Before you begin, make sure that you understand how DataSync [accesses HDFS clusters](https://docs.aws.amazon.com/datasync/latest/userguide/create-hdfs-location.html#accessing-hdfs).
 */
public suspend inline fun DataSyncClient.createLocationHdfs(crossinline block: CreateLocationHdfsRequest.Builder.() -> Unit): CreateLocationHdfsResponse = createLocationHdfs(CreateLocationHdfsRequest.Builder().apply(block).build())

/**
 * Creates a transfer *location* for a Network File System (NFS) file server. DataSync can use this location as a source or destination for transferring data.
 *
 * Before you begin, make sure that you understand how DataSync [accesses NFS file servers](https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#accessing-nfs).
 *
 * If you're copying data to or from an Snowcone device, you can also use `CreateLocationNfs` to create your transfer location. For more information, see [Configuring transfers with Snowcone](https://docs.aws.amazon.com/datasync/latest/userguide/nfs-on-snowcone.html).
 */
public suspend inline fun DataSyncClient.createLocationNfs(crossinline block: CreateLocationNfsRequest.Builder.() -> Unit): CreateLocationNfsResponse = createLocationNfs(CreateLocationNfsRequest.Builder().apply(block).build())

/**
 * Creates a transfer *location* for an object storage system. DataSync can use this location as a source or destination for transferring data.
 *
 * Before you begin, make sure that you understand the [prerequisites](https://docs.aws.amazon.com/datasync/latest/userguide/create-object-location.html#create-object-location-prerequisites) for DataSync to work with object storage systems.
 */
public suspend inline fun DataSyncClient.createLocationObjectStorage(crossinline block: CreateLocationObjectStorageRequest.Builder.() -> Unit): CreateLocationObjectStorageResponse = createLocationObjectStorage(CreateLocationObjectStorageRequest.Builder().apply(block).build())

/**
 * Creates a transfer *location* for an Amazon S3 bucket. DataSync can use this location as a source or destination for transferring data.
 *
 * Before you begin, make sure that you read the following topics:
 * + [Storage class considerations with Amazon S3 locations](https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes)
 * + [Evaluating S3 request costs when using DataSync](https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#create-s3-location-s3-requests)
 *  For more information, see [Configuring transfers with Amazon S3](https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html).
 */
public suspend inline fun DataSyncClient.createLocationS3(crossinline block: CreateLocationS3Request.Builder.() -> Unit): CreateLocationS3Response = createLocationS3(CreateLocationS3Request.Builder().apply(block).build())

/**
 * Creates a transfer *location* for a Server Message Block (SMB) file server. DataSync can use this location as a source or destination for transferring data.
 *
 * Before you begin, make sure that you understand how DataSync [accesses SMB file servers](https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#configuring-smb).
 */
public suspend inline fun DataSyncClient.createLocationSmb(crossinline block: CreateLocationSmbRequest.Builder.() -> Unit): CreateLocationSmbResponse = createLocationSmb(CreateLocationSmbRequest.Builder().apply(block).build())

/**
 * Configures a *task*, which defines where and how DataSync transfers your data.
 *
 * A task includes a source location, destination location, and transfer options (such as bandwidth limits, scheduling, and more).
 *
 * If you're planning to transfer data to or from an Amazon S3 location, review [how DataSync can affect your S3 request charges](https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#create-s3-location-s3-requests) and the [DataSync pricing page](http://aws.amazon.com/datasync/pricing/) before you begin.
 */
public suspend inline fun DataSyncClient.createTask(crossinline block: CreateTaskRequest.Builder.() -> Unit): CreateTaskResponse = createTask(CreateTaskRequest.Builder().apply(block).build())

/**
 * Removes an DataSync agent resource from your Amazon Web Services account.
 *
 * Keep in mind that this operation (which can't be undone) doesn't remove the agent's virtual machine (VM) or Amazon EC2 instance from your storage environment. For next steps, you can delete the VM or instance from your storage environment or reuse it to [activate a new agent](https://docs.aws.amazon.com/datasync/latest/userguide/activate-agent.html).
 */
public suspend inline fun DataSyncClient.deleteAgent(crossinline block: DeleteAgentRequest.Builder.() -> Unit): DeleteAgentResponse = deleteAgent(DeleteAgentRequest.Builder().apply(block).build())

/**
 * Deletes a transfer location resource from DataSync.
 */
public suspend inline fun DataSyncClient.deleteLocation(crossinline block: DeleteLocationRequest.Builder.() -> Unit): DeleteLocationResponse = deleteLocation(DeleteLocationRequest.Builder().apply(block).build())

/**
 * Deletes a transfer task resource from DataSync.
 */
public suspend inline fun DataSyncClient.deleteTask(crossinline block: DeleteTaskRequest.Builder.() -> Unit): DeleteTaskResponse = deleteTask(DeleteTaskRequest.Builder().apply(block).build())

/**
 * Returns information about an DataSync agent, such as its name, service endpoint type, and status.
 */
public suspend inline fun DataSyncClient.describeAgent(crossinline block: DescribeAgentRequest.Builder.() -> Unit): DescribeAgentResponse = describeAgent(DescribeAgentRequest.Builder().apply(block).build())

/**
 * Returns information about a DataSync discovery job.
 */
public suspend inline fun DataSyncClient.describeDiscoveryJob(crossinline block: DescribeDiscoveryJobRequest.Builder.() -> Unit): DescribeDiscoveryJobResponse = describeDiscoveryJob(DescribeDiscoveryJobRequest.Builder().apply(block).build())

/**
 * Provides details about how an DataSync transfer location for Microsoft Azure Blob Storage is configured.
 */
public suspend inline fun DataSyncClient.describeLocationAzureBlob(crossinline block: DescribeLocationAzureBlobRequest.Builder.() -> Unit): DescribeLocationAzureBlobResponse = describeLocationAzureBlob(DescribeLocationAzureBlobRequest.Builder().apply(block).build())

/**
 * Provides details about how an DataSync transfer location for an Amazon EFS file system is configured.
 */
public suspend inline fun DataSyncClient.describeLocationEfs(crossinline block: DescribeLocationEfsRequest.Builder.() -> Unit): DescribeLocationEfsResponse = describeLocationEfs(DescribeLocationEfsRequest.Builder().apply(block).build())

/**
 * Provides details about how an DataSync transfer location for an Amazon FSx for Lustre file system is configured.
 */
public suspend inline fun DataSyncClient.describeLocationFsxLustre(crossinline block: DescribeLocationFsxLustreRequest.Builder.() -> Unit): DescribeLocationFsxLustreResponse = describeLocationFsxLustre(DescribeLocationFsxLustreRequest.Builder().apply(block).build())

/**
 * Provides details about how an DataSync transfer location for an Amazon FSx for NetApp ONTAP file system is configured.
 *
 * If your location uses SMB, the `DescribeLocationFsxOntap` operation doesn't actually return a `Password`.
 */
public suspend inline fun DataSyncClient.describeLocationFsxOntap(crossinline block: DescribeLocationFsxOntapRequest.Builder.() -> Unit): DescribeLocationFsxOntapResponse = describeLocationFsxOntap(DescribeLocationFsxOntapRequest.Builder().apply(block).build())

/**
 * Provides details about how an DataSync transfer location for an Amazon FSx for OpenZFS file system is configured.
 *
 * Response elements related to `SMB` aren't supported with the `DescribeLocationFsxOpenZfs` operation.
 */
public suspend inline fun DataSyncClient.describeLocationFsxOpenZfs(crossinline block: DescribeLocationFsxOpenZfsRequest.Builder.() -> Unit): DescribeLocationFsxOpenZfsResponse = describeLocationFsxOpenZfs(DescribeLocationFsxOpenZfsRequest.Builder().apply(block).build())

/**
 * Provides details about how an DataSync transfer location for an Amazon FSx for Windows File Server file system is configured.
 */
public suspend inline fun DataSyncClient.describeLocationFsxWindows(crossinline block: DescribeLocationFsxWindowsRequest.Builder.() -> Unit): DescribeLocationFsxWindowsResponse = describeLocationFsxWindows(DescribeLocationFsxWindowsRequest.Builder().apply(block).build())

/**
 * Provides details about how an DataSync transfer location for a Hadoop Distributed File System (HDFS) is configured.
 */
public suspend inline fun DataSyncClient.describeLocationHdfs(crossinline block: DescribeLocationHdfsRequest.Builder.() -> Unit): DescribeLocationHdfsResponse = describeLocationHdfs(DescribeLocationHdfsRequest.Builder().apply(block).build())

/**
 * Provides details about how an DataSync transfer location for a Network File System (NFS) file server is configured.
 */
public suspend inline fun DataSyncClient.describeLocationNfs(crossinline block: DescribeLocationNfsRequest.Builder.() -> Unit): DescribeLocationNfsResponse = describeLocationNfs(DescribeLocationNfsRequest.Builder().apply(block).build())

/**
 * Provides details about how an DataSync transfer location for an object storage system is configured.
 */
public suspend inline fun DataSyncClient.describeLocationObjectStorage(crossinline block: DescribeLocationObjectStorageRequest.Builder.() -> Unit): DescribeLocationObjectStorageResponse = describeLocationObjectStorage(DescribeLocationObjectStorageRequest.Builder().apply(block).build())

/**
 * Provides details about how an DataSync transfer location for an S3 bucket is configured.
 */
public suspend inline fun DataSyncClient.describeLocationS3(crossinline block: DescribeLocationS3Request.Builder.() -> Unit): DescribeLocationS3Response = describeLocationS3(DescribeLocationS3Request.Builder().apply(block).build())

/**
 * Provides details about how an DataSync transfer location for a Server Message Block (SMB) file server is configured.
 */
public suspend inline fun DataSyncClient.describeLocationSmb(crossinline block: DescribeLocationSmbRequest.Builder.() -> Unit): DescribeLocationSmbResponse = describeLocationSmb(DescribeLocationSmbRequest.Builder().apply(block).build())

/**
 * Returns information about an on-premises storage system that you're using with DataSync Discovery.
 */
public suspend inline fun DataSyncClient.describeStorageSystem(crossinline block: DescribeStorageSystemRequest.Builder.() -> Unit): DescribeStorageSystemResponse = describeStorageSystem(DescribeStorageSystemRequest.Builder().apply(block).build())

/**
 * Returns information, including performance data and capacity usage, which DataSync Discovery collects about a specific resource in your-premises storage system.
 */
public suspend inline fun DataSyncClient.describeStorageSystemResourceMetrics(crossinline block: DescribeStorageSystemResourceMetricsRequest.Builder.() -> Unit): DescribeStorageSystemResourceMetricsResponse = describeStorageSystemResourceMetrics(DescribeStorageSystemResourceMetricsRequest.Builder().apply(block).build())

/**
 * Returns information that DataSync Discovery collects about resources in your on-premises storage system.
 */
public suspend inline fun DataSyncClient.describeStorageSystemResources(crossinline block: DescribeStorageSystemResourcesRequest.Builder.() -> Unit): DescribeStorageSystemResourcesResponse = describeStorageSystemResources(DescribeStorageSystemResourcesRequest.Builder().apply(block).build())

/**
 * Provides information about a *task*, which defines where and how DataSync transfers your data.
 */
public suspend inline fun DataSyncClient.describeTask(crossinline block: DescribeTaskRequest.Builder.() -> Unit): DescribeTaskResponse = describeTask(DescribeTaskRequest.Builder().apply(block).build())

/**
 * Provides information about an execution of your DataSync task. You can use this operation to help monitor the progress of an ongoing data transfer or check the results of the transfer.
 *
 * Some `DescribeTaskExecution` response elements are only relevant to a specific task mode. For information, see [Understanding task mode differences](https://docs.aws.amazon.com/datasync/latest/userguide/choosing-task-mode.html#task-mode-differences) and [Understanding data transfer performance metrics](https://docs.aws.amazon.com/datasync/latest/userguide/transfer-performance-metrics.html).
 */
public suspend inline fun DataSyncClient.describeTaskExecution(crossinline block: DescribeTaskExecutionRequest.Builder.() -> Unit): DescribeTaskExecutionResponse = describeTaskExecution(DescribeTaskExecutionRequest.Builder().apply(block).build())

/**
 * Creates recommendations about where to migrate your data to in Amazon Web Services. Recommendations are generated based on information that DataSync Discovery collects about your on-premises storage system's resources. For more information, see [Recommendations provided by DataSync Discovery](https://docs.aws.amazon.com/datasync/latest/userguide/discovery-understand-recommendations.html).
 *
 * Once generated, you can view your recommendations by using the [DescribeStorageSystemResources](https://docs.aws.amazon.com/datasync/latest/userguide/API_DescribeStorageSystemResources.html) operation.
 */
public suspend inline fun DataSyncClient.generateRecommendations(crossinline block: GenerateRecommendationsRequest.Builder.() -> Unit): GenerateRecommendationsResponse = generateRecommendations(GenerateRecommendationsRequest.Builder().apply(block).build())

/**
 * Returns a list of DataSync agents that belong to an Amazon Web Services account in the Amazon Web Services Region specified in the request.
 *
 * With pagination, you can reduce the number of agents returned in a response. If you get a truncated list of agents in a response, the response contains a marker that you can specify in your next request to fetch the next page of agents.
 *
 * `ListAgents` is eventually consistent. This means the result of running the operation might not reflect that you just created or deleted an agent. For example, if you create an agent with [CreateAgent](https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateAgent.html) and then immediately run `ListAgents`, that agent might not show up in the list right away. In situations like this, you can always confirm whether an agent has been created (or deleted) by using [DescribeAgent](https://docs.aws.amazon.com/datasync/latest/userguide/API_DescribeAgent.html).
 */
public suspend inline fun DataSyncClient.listAgents(crossinline block: ListAgentsRequest.Builder.() -> Unit): ListAgentsResponse = listAgents(ListAgentsRequest.Builder().apply(block).build())

/**
 * Provides a list of the existing discovery jobs in the Amazon Web Services Region and Amazon Web Services account where you're using DataSync Discovery.
 */
public suspend inline fun DataSyncClient.listDiscoveryJobs(crossinline block: ListDiscoveryJobsRequest.Builder.() -> Unit): ListDiscoveryJobsResponse = listDiscoveryJobs(ListDiscoveryJobsRequest.Builder().apply(block).build())

/**
 * Returns a list of source and destination locations.
 *
 * If you have more locations than are returned in a response (that is, the response returns only a truncated list of your agents), the response contains a token that you can specify in your next request to fetch the next page of locations.
 */
public suspend inline fun DataSyncClient.listLocations(crossinline block: ListLocationsRequest.Builder.() -> Unit): ListLocationsResponse = listLocations(ListLocationsRequest.Builder().apply(block).build())

/**
 * Lists the on-premises storage systems that you're using with DataSync Discovery.
 */
public suspend inline fun DataSyncClient.listStorageSystems(crossinline block: ListStorageSystemsRequest.Builder.() -> Unit): ListStorageSystemsResponse = listStorageSystems(ListStorageSystemsRequest.Builder().apply(block).build())

/**
 * Returns all the tags associated with an Amazon Web Services resource.
 */
public suspend inline fun DataSyncClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Returns a list of executions for an DataSync transfer task.
 */
public suspend inline fun DataSyncClient.listTaskExecutions(crossinline block: ListTaskExecutionsRequest.Builder.() -> Unit): ListTaskExecutionsResponse = listTaskExecutions(ListTaskExecutionsRequest.Builder().apply(block).build())

/**
 * Returns a list of the DataSync tasks you created.
 */
public suspend inline fun DataSyncClient.listTasks(crossinline block: ListTasksRequest.Builder.() -> Unit): ListTasksResponse = listTasks(ListTasksRequest.Builder().apply(block).build())

/**
 * Permanently removes a storage system resource from DataSync Discovery, including the associated discovery jobs, collected data, and recommendations.
 */
public suspend inline fun DataSyncClient.removeStorageSystem(crossinline block: RemoveStorageSystemRequest.Builder.() -> Unit): RemoveStorageSystemResponse = removeStorageSystem(RemoveStorageSystemRequest.Builder().apply(block).build())

/**
 * Runs a DataSync discovery job on your on-premises storage system. If you haven't added the storage system to DataSync Discovery yet, do this first by using the [AddStorageSystem](https://docs.aws.amazon.com/datasync/latest/userguide/API_AddStorageSystem.html) operation.
 */
public suspend inline fun DataSyncClient.startDiscoveryJob(crossinline block: StartDiscoveryJobRequest.Builder.() -> Unit): StartDiscoveryJobResponse = startDiscoveryJob(StartDiscoveryJobRequest.Builder().apply(block).build())

/**
 * Starts an DataSync transfer task. For each task, you can only run one task execution at a time.
 *
 * There are several steps to a task execution. For more information, see [Task execution statuses](https://docs.aws.amazon.com/datasync/latest/userguide/working-with-task-executions.html#understand-task-execution-statuses).
 *
 * If you're planning to transfer data to or from an Amazon S3 location, review [how DataSync can affect your S3 request charges](https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#create-s3-location-s3-requests) and the [DataSync pricing page](http://aws.amazon.com/datasync/pricing/) before you begin.
 */
public suspend inline fun DataSyncClient.startTaskExecution(crossinline block: StartTaskExecutionRequest.Builder.() -> Unit): StartTaskExecutionResponse = startTaskExecution(StartTaskExecutionRequest.Builder().apply(block).build())

/**
 * Stops a running DataSync discovery job.
 *
 * You can stop a discovery job anytime. A job that's stopped before it's scheduled to end likely will provide you some information about your on-premises storage system resources. To get recommendations for a stopped job, you must use the [GenerateRecommendations](https://docs.aws.amazon.com/datasync/latest/userguide/API_GenerateRecommendations.html) operation.
 */
public suspend inline fun DataSyncClient.stopDiscoveryJob(crossinline block: StopDiscoveryJobRequest.Builder.() -> Unit): StopDiscoveryJobResponse = stopDiscoveryJob(StopDiscoveryJobRequest.Builder().apply(block).build())

/**
 * Applies a *tag* to an Amazon Web Services resource. Tags are key-value pairs that can help you manage, filter, and search for your resources.
 *
 * These include DataSync resources, such as locations, tasks, and task executions.
 */
public suspend inline fun DataSyncClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from an Amazon Web Services resource.
 */
public suspend inline fun DataSyncClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the name of an DataSync agent.
 */
public suspend inline fun DataSyncClient.updateAgent(crossinline block: UpdateAgentRequest.Builder.() -> Unit): UpdateAgentResponse = updateAgent(UpdateAgentRequest.Builder().apply(block).build())

/**
 * Edits a DataSync discovery job configuration.
 */
public suspend inline fun DataSyncClient.updateDiscoveryJob(crossinline block: UpdateDiscoveryJobRequest.Builder.() -> Unit): UpdateDiscoveryJobResponse = updateDiscoveryJob(UpdateDiscoveryJobRequest.Builder().apply(block).build())

/**
 * Modifies some configurations of the Microsoft Azure Blob Storage transfer location that you're using with DataSync.
 */
public suspend inline fun DataSyncClient.updateLocationAzureBlob(crossinline block: UpdateLocationAzureBlobRequest.Builder.() -> Unit): UpdateLocationAzureBlobResponse = updateLocationAzureBlob(UpdateLocationAzureBlobRequest.Builder().apply(block).build())

/**
 * Updates some parameters of a previously created location for a Hadoop Distributed File System cluster.
 */
public suspend inline fun DataSyncClient.updateLocationHdfs(crossinline block: UpdateLocationHdfsRequest.Builder.() -> Unit): UpdateLocationHdfsResponse = updateLocationHdfs(UpdateLocationHdfsRequest.Builder().apply(block).build())

/**
 * Modifies some configurations of the Network File System (NFS) transfer location that you're using with DataSync.
 *
 * For more information, see [Configuring transfers to or from an NFS file server](https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html).
 */
public suspend inline fun DataSyncClient.updateLocationNfs(crossinline block: UpdateLocationNfsRequest.Builder.() -> Unit): UpdateLocationNfsResponse = updateLocationNfs(UpdateLocationNfsRequest.Builder().apply(block).build())

/**
 * Updates some parameters of an existing DataSync location for an object storage system.
 */
public suspend inline fun DataSyncClient.updateLocationObjectStorage(crossinline block: UpdateLocationObjectStorageRequest.Builder.() -> Unit): UpdateLocationObjectStorageResponse = updateLocationObjectStorage(UpdateLocationObjectStorageRequest.Builder().apply(block).build())

/**
 * Updates some of the parameters of a Server Message Block (SMB) file server location that you can use for DataSync transfers.
 */
public suspend inline fun DataSyncClient.updateLocationSmb(crossinline block: UpdateLocationSmbRequest.Builder.() -> Unit): UpdateLocationSmbResponse = updateLocationSmb(UpdateLocationSmbRequest.Builder().apply(block).build())

/**
 * Modifies some configurations of an on-premises storage system resource that you're using with DataSync Discovery.
 */
public suspend inline fun DataSyncClient.updateStorageSystem(crossinline block: UpdateStorageSystemRequest.Builder.() -> Unit): UpdateStorageSystemResponse = updateStorageSystem(UpdateStorageSystemRequest.Builder().apply(block).build())

/**
 * Updates the configuration of a *task*, which defines where and how DataSync transfers your data.
 */
public suspend inline fun DataSyncClient.updateTask(crossinline block: UpdateTaskRequest.Builder.() -> Unit): UpdateTaskResponse = updateTask(UpdateTaskRequest.Builder().apply(block).build())

/**
 * Updates the configuration of a running DataSync task execution.
 *
 * Currently, the only `Option` that you can modify with `UpdateTaskExecution` is ` <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_Options.html#DataSync-Type-Options-BytesPerSecond">BytesPerSecond</a> `, which throttles bandwidth for a running or queued task execution.
 */
public suspend inline fun DataSyncClient.updateTaskExecution(crossinline block: UpdateTaskExecutionRequest.Builder.() -> Unit): UpdateTaskExecutionResponse = updateTaskExecution(UpdateTaskExecutionRequest.Builder().apply(block).build())
