// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.serde

import aws.sdk.kotlin.services.datasync.model.DataSyncException
import aws.sdk.kotlin.services.datasync.model.DescribeTaskResponse
import aws.sdk.kotlin.services.datasync.model.FilterRule
import aws.sdk.kotlin.services.datasync.model.Options
import aws.sdk.kotlin.services.datasync.model.TaskReportConfig
import aws.sdk.kotlin.services.datasync.model.TaskSchedule
import aws.sdk.kotlin.services.datasync.model.TaskStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class DescribeTaskOperationDeserializer: HttpDeserialize<DescribeTaskResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeTaskResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeTaskError(context, call)
        }
        val builder = DescribeTaskResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeTaskOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeTaskError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DataSyncException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        else -> DataSyncException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeTaskOperationBody(builder: DescribeTaskResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CLOUDWATCHLOGGROUPARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CloudWatchLogGroupArn"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val CURRENTTASKEXECUTIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CurrentTaskExecutionArn"))
    val DESTINATIONLOCATIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DestinationLocationArn"))
    val DESTINATIONNETWORKINTERFACEARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DestinationNetworkInterfaceArns"))
    val ERRORCODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ErrorCode"))
    val ERRORDETAIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ErrorDetail"))
    val EXCLUDES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Excludes"))
    val INCLUDES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Includes"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val OPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Options"))
    val SCHEDULE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Schedule"))
    val SOURCELOCATIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SourceLocationArn"))
    val SOURCENETWORKINTERFACEARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SourceNetworkInterfaceArns"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val TASKARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TaskArn"))
    val TASKREPORTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TaskReportConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLOUDWATCHLOGGROUPARN_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(CURRENTTASKEXECUTIONARN_DESCRIPTOR)
        field(DESTINATIONLOCATIONARN_DESCRIPTOR)
        field(DESTINATIONNETWORKINTERFACEARNS_DESCRIPTOR)
        field(ERRORCODE_DESCRIPTOR)
        field(ERRORDETAIL_DESCRIPTOR)
        field(EXCLUDES_DESCRIPTOR)
        field(INCLUDES_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(OPTIONS_DESCRIPTOR)
        field(SCHEDULE_DESCRIPTOR)
        field(SOURCELOCATIONARN_DESCRIPTOR)
        field(SOURCENETWORKINTERFACEARNS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TASKARN_DESCRIPTOR)
        field(TASKREPORTCONFIG_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CLOUDWATCHLOGGROUPARN_DESCRIPTOR.index -> builder.cloudWatchLogGroupArn = deserializeString()
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                CURRENTTASKEXECUTIONARN_DESCRIPTOR.index -> builder.currentTaskExecutionArn = deserializeString()
                DESTINATIONLOCATIONARN_DESCRIPTOR.index -> builder.destinationLocationArn = deserializeString()
                DESTINATIONNETWORKINTERFACEARNS_DESCRIPTOR.index -> builder.destinationNetworkInterfaceArns =
                    deserializer.deserializeList(DESTINATIONNETWORKINTERFACEARNS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ERRORCODE_DESCRIPTOR.index -> builder.errorCode = deserializeString()
                ERRORDETAIL_DESCRIPTOR.index -> builder.errorDetail = deserializeString()
                EXCLUDES_DESCRIPTOR.index -> builder.excludes =
                    deserializer.deserializeList(EXCLUDES_DESCRIPTOR) {
                        val col0 = mutableListOf<FilterRule>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFilterRuleDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                INCLUDES_DESCRIPTOR.index -> builder.includes =
                    deserializer.deserializeList(INCLUDES_DESCRIPTOR) {
                        val col0 = mutableListOf<FilterRule>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFilterRuleDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                OPTIONS_DESCRIPTOR.index -> builder.options = deserializeOptionsDocument(deserializer)
                SCHEDULE_DESCRIPTOR.index -> builder.schedule = deserializeTaskScheduleDocument(deserializer)
                SOURCELOCATIONARN_DESCRIPTOR.index -> builder.sourceLocationArn = deserializeString()
                SOURCENETWORKINTERFACEARNS_DESCRIPTOR.index -> builder.sourceNetworkInterfaceArns =
                    deserializer.deserializeList(SOURCENETWORKINTERFACEARNS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { TaskStatus.fromValue(it) }
                TASKARN_DESCRIPTOR.index -> builder.taskArn = deserializeString()
                TASKREPORTCONFIG_DESCRIPTOR.index -> builder.taskReportConfig = deserializeTaskReportConfigDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
