// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.serde

import aws.sdk.kotlin.services.datasync.model.DataSyncException
import aws.sdk.kotlin.services.datasync.model.DescribeTaskExecutionResponse
import aws.sdk.kotlin.services.datasync.model.FilterRule
import aws.sdk.kotlin.services.datasync.model.Options
import aws.sdk.kotlin.services.datasync.model.ReportResult
import aws.sdk.kotlin.services.datasync.model.TaskExecutionResultDetail
import aws.sdk.kotlin.services.datasync.model.TaskExecutionStatus
import aws.sdk.kotlin.services.datasync.model.TaskReportConfig
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class DescribeTaskExecutionOperationDeserializer: HttpDeserialize<DescribeTaskExecutionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeTaskExecutionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeTaskExecutionError(context, call)
        }
        val builder = DescribeTaskExecutionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeTaskExecutionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeTaskExecutionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DataSyncException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        else -> DataSyncException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeTaskExecutionOperationBody(builder: DescribeTaskExecutionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BYTESCOMPRESSED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("BytesCompressed"))
    val BYTESTRANSFERRED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("BytesTransferred"))
    val BYTESWRITTEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("BytesWritten"))
    val ESTIMATEDBYTESTOTRANSFER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("EstimatedBytesToTransfer"))
    val ESTIMATEDFILESTODELETE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("EstimatedFilesToDelete"))
    val ESTIMATEDFILESTOTRANSFER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("EstimatedFilesToTransfer"))
    val EXCLUDES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Excludes"))
    val FILESDELETED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("FilesDeleted"))
    val FILESSKIPPED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("FilesSkipped"))
    val FILESTRANSFERRED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("FilesTransferred"))
    val FILESVERIFIED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("FilesVerified"))
    val INCLUDES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Includes"))
    val OPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Options"))
    val REPORTRESULT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ReportResult"))
    val RESULT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Result"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("StartTime"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val TASKEXECUTIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TaskExecutionArn"))
    val TASKREPORTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TaskReportConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BYTESCOMPRESSED_DESCRIPTOR)
        field(BYTESTRANSFERRED_DESCRIPTOR)
        field(BYTESWRITTEN_DESCRIPTOR)
        field(ESTIMATEDBYTESTOTRANSFER_DESCRIPTOR)
        field(ESTIMATEDFILESTODELETE_DESCRIPTOR)
        field(ESTIMATEDFILESTOTRANSFER_DESCRIPTOR)
        field(EXCLUDES_DESCRIPTOR)
        field(FILESDELETED_DESCRIPTOR)
        field(FILESSKIPPED_DESCRIPTOR)
        field(FILESTRANSFERRED_DESCRIPTOR)
        field(FILESVERIFIED_DESCRIPTOR)
        field(INCLUDES_DESCRIPTOR)
        field(OPTIONS_DESCRIPTOR)
        field(REPORTRESULT_DESCRIPTOR)
        field(RESULT_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TASKEXECUTIONARN_DESCRIPTOR)
        field(TASKREPORTCONFIG_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BYTESCOMPRESSED_DESCRIPTOR.index -> builder.bytesCompressed = deserializeLong()
                BYTESTRANSFERRED_DESCRIPTOR.index -> builder.bytesTransferred = deserializeLong()
                BYTESWRITTEN_DESCRIPTOR.index -> builder.bytesWritten = deserializeLong()
                ESTIMATEDBYTESTOTRANSFER_DESCRIPTOR.index -> builder.estimatedBytesToTransfer = deserializeLong()
                ESTIMATEDFILESTODELETE_DESCRIPTOR.index -> builder.estimatedFilesToDelete = deserializeLong()
                ESTIMATEDFILESTOTRANSFER_DESCRIPTOR.index -> builder.estimatedFilesToTransfer = deserializeLong()
                EXCLUDES_DESCRIPTOR.index -> builder.excludes =
                    deserializer.deserializeList(EXCLUDES_DESCRIPTOR) {
                        val col0 = mutableListOf<FilterRule>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFilterRuleDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FILESDELETED_DESCRIPTOR.index -> builder.filesDeleted = deserializeLong()
                FILESSKIPPED_DESCRIPTOR.index -> builder.filesSkipped = deserializeLong()
                FILESTRANSFERRED_DESCRIPTOR.index -> builder.filesTransferred = deserializeLong()
                FILESVERIFIED_DESCRIPTOR.index -> builder.filesVerified = deserializeLong()
                INCLUDES_DESCRIPTOR.index -> builder.includes =
                    deserializer.deserializeList(INCLUDES_DESCRIPTOR) {
                        val col0 = mutableListOf<FilterRule>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFilterRuleDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                OPTIONS_DESCRIPTOR.index -> builder.options = deserializeOptionsDocument(deserializer)
                REPORTRESULT_DESCRIPTOR.index -> builder.reportResult = deserializeReportResultDocument(deserializer)
                RESULT_DESCRIPTOR.index -> builder.result = deserializeTaskExecutionResultDetailDocument(deserializer)
                STARTTIME_DESCRIPTOR.index -> builder.startTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { TaskExecutionStatus.fromValue(it) }
                TASKEXECUTIONARN_DESCRIPTOR.index -> builder.taskExecutionArn = deserializeString()
                TASKREPORTCONFIG_DESCRIPTOR.index -> builder.taskReportConfig = deserializeTaskReportConfigDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
