// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.serde

import aws.sdk.kotlin.services.datasync.model.DataSyncException
import aws.sdk.kotlin.services.datasync.model.DescribeLocationSmbResponse
import aws.sdk.kotlin.services.datasync.model.SmbMountOptions
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class DescribeLocationSmbOperationDeserializer: HttpDeserialize<DescribeLocationSmbResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeLocationSmbResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeLocationSmbError(context, call)
        }
        val builder = DescribeLocationSmbResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeLocationSmbOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeLocationSmbError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DataSyncException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        else -> DataSyncException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeLocationSmbOperationBody(builder: DescribeLocationSmbResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AGENTARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AgentArns"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DOMAIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Domain"))
    val LOCATIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LocationArn"))
    val LOCATIONURI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LocationUri"))
    val MOUNTOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("MountOptions"))
    val USER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("User"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AGENTARNS_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DOMAIN_DESCRIPTOR)
        field(LOCATIONARN_DESCRIPTOR)
        field(LOCATIONURI_DESCRIPTOR)
        field(MOUNTOPTIONS_DESCRIPTOR)
        field(USER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AGENTARNS_DESCRIPTOR.index -> builder.agentArns =
                    deserializer.deserializeList(AGENTARNS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DOMAIN_DESCRIPTOR.index -> builder.domain = deserializeString()
                LOCATIONARN_DESCRIPTOR.index -> builder.locationArn = deserializeString()
                LOCATIONURI_DESCRIPTOR.index -> builder.locationUri = deserializeString()
                MOUNTOPTIONS_DESCRIPTOR.index -> builder.mountOptions = deserializeSmbMountOptionsDocument(deserializer)
                USER_DESCRIPTOR.index -> builder.user = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
