// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.serde

import aws.sdk.kotlin.services.datasync.model.DataSyncException
import aws.sdk.kotlin.services.datasync.model.DescribeLocationHdfsResponse
import aws.sdk.kotlin.services.datasync.model.HdfsAuthenticationType
import aws.sdk.kotlin.services.datasync.model.HdfsNameNode
import aws.sdk.kotlin.services.datasync.model.QopConfiguration
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class DescribeLocationHdfsOperationDeserializer: HttpDeserialize<DescribeLocationHdfsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeLocationHdfsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeLocationHdfsError(context, call)
        }
        val builder = DescribeLocationHdfsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeLocationHdfsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeLocationHdfsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DataSyncException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        else -> DataSyncException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeLocationHdfsOperationBody(builder: DescribeLocationHdfsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AGENTARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AgentArns"))
    val AUTHENTICATIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("AuthenticationType"))
    val BLOCKSIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("BlockSize"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val KERBEROSPRINCIPAL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KerberosPrincipal"))
    val KMSKEYPROVIDERURI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKeyProviderUri"))
    val LOCATIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LocationArn"))
    val LOCATIONURI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LocationUri"))
    val NAMENODES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("NameNodes"))
    val QOPCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("QopConfiguration"))
    val REPLICATIONFACTOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("ReplicationFactor"))
    val SIMPLEUSER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SimpleUser"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AGENTARNS_DESCRIPTOR)
        field(AUTHENTICATIONTYPE_DESCRIPTOR)
        field(BLOCKSIZE_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(KERBEROSPRINCIPAL_DESCRIPTOR)
        field(KMSKEYPROVIDERURI_DESCRIPTOR)
        field(LOCATIONARN_DESCRIPTOR)
        field(LOCATIONURI_DESCRIPTOR)
        field(NAMENODES_DESCRIPTOR)
        field(QOPCONFIGURATION_DESCRIPTOR)
        field(REPLICATIONFACTOR_DESCRIPTOR)
        field(SIMPLEUSER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AGENTARNS_DESCRIPTOR.index -> builder.agentArns =
                    deserializer.deserializeList(AGENTARNS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                AUTHENTICATIONTYPE_DESCRIPTOR.index -> builder.authenticationType = deserializeString().let { HdfsAuthenticationType.fromValue(it) }
                BLOCKSIZE_DESCRIPTOR.index -> builder.blockSize = deserializeInt()
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                KERBEROSPRINCIPAL_DESCRIPTOR.index -> builder.kerberosPrincipal = deserializeString()
                KMSKEYPROVIDERURI_DESCRIPTOR.index -> builder.kmsKeyProviderUri = deserializeString()
                LOCATIONARN_DESCRIPTOR.index -> builder.locationArn = deserializeString()
                LOCATIONURI_DESCRIPTOR.index -> builder.locationUri = deserializeString()
                NAMENODES_DESCRIPTOR.index -> builder.nameNodes =
                    deserializer.deserializeList(NAMENODES_DESCRIPTOR) {
                        val col0 = mutableListOf<HdfsNameNode>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeHdfsNameNodeDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                QOPCONFIGURATION_DESCRIPTOR.index -> builder.qopConfiguration = deserializeQopConfigurationDocument(deserializer)
                REPLICATIONFACTOR_DESCRIPTOR.index -> builder.replicationFactor = deserializeInt()
                SIMPLEUSER_DESCRIPTOR.index -> builder.simpleUser = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
