// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.serde

import aws.sdk.kotlin.services.datasync.model.CreateLocationFsxWindowsResponse
import aws.sdk.kotlin.services.datasync.model.DataSyncException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateLocationFsxWindowsOperationDeserializer: HttpDeserialize<CreateLocationFsxWindowsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateLocationFsxWindowsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateLocationFsxWindowsError(context, call)
        }
        val builder = CreateLocationFsxWindowsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateLocationFsxWindowsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateLocationFsxWindowsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DataSyncException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        else -> DataSyncException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateLocationFsxWindowsOperationBody(builder: CreateLocationFsxWindowsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LOCATIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LocationArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LOCATIONARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LOCATIONARN_DESCRIPTOR.index -> builder.locationArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
