// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model



/**
 * UpdateTaskResponse
 */
public class UpdateTaskRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the resource name of the Amazon CloudWatch log group.
     */
    public val cloudWatchLogGroupArn: kotlin.String? = builder.cloudWatchLogGroupArn
    /**
     * Specifies a list of filter rules that exclude specific data during your transfer. For more information and examples, see [Filtering data transferred by DataSync](https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html).
     */
    public val excludes: List<FilterRule>? = builder.excludes
    /**
     * Specifies a list of filter rules that include specific data during your transfer. For more information and examples, see [Filtering data transferred by DataSync](https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html).
     */
    public val includes: List<FilterRule>? = builder.includes
    /**
     * The name of the task to update.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Indicates how your transfer task is configured. These options include how DataSync handles files, objects, and their associated metadata during your transfer. You also can specify how to verify data integrity, set bandwidth limits for your task, among other options.
     *
     * Each option has a default value. Unless you need to, you don't have to configure any of these options before starting your task.
     */
    public val options: aws.sdk.kotlin.services.datasync.model.Options? = builder.options
    /**
     * Specifies a schedule used to periodically transfer files from a source to a destination location. You can configure your task to execute hourly, daily, weekly or on specific days of the week. You control when in the day or hour you want the task to execute. The time you specify is UTC time. For more information, see [Scheduling your task](https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html).
     */
    public val schedule: aws.sdk.kotlin.services.datasync.model.TaskSchedule? = builder.schedule
    /**
     * The Amazon Resource Name (ARN) of the resource name of the task to update.
     */
    public val taskArn: kotlin.String? = builder.taskArn
    /**
     * Specifies how you want to configure a task report, which provides detailed information about for your DataSync transfer.
     */
    public val taskReportConfig: aws.sdk.kotlin.services.datasync.model.TaskReportConfig? = builder.taskReportConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.UpdateTaskRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateTaskRequest(")
        append("cloudWatchLogGroupArn=$cloudWatchLogGroupArn,")
        append("excludes=$excludes,")
        append("includes=$includes,")
        append("name=$name,")
        append("options=$options,")
        append("schedule=$schedule,")
        append("taskArn=$taskArn,")
        append("taskReportConfig=$taskReportConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchLogGroupArn?.hashCode() ?: 0
        result = 31 * result + (excludes?.hashCode() ?: 0)
        result = 31 * result + (includes?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (options?.hashCode() ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        result = 31 * result + (taskArn?.hashCode() ?: 0)
        result = 31 * result + (taskReportConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateTaskRequest

        if (cloudWatchLogGroupArn != other.cloudWatchLogGroupArn) return false
        if (excludes != other.excludes) return false
        if (includes != other.includes) return false
        if (name != other.name) return false
        if (options != other.options) return false
        if (schedule != other.schedule) return false
        if (taskArn != other.taskArn) return false
        if (taskReportConfig != other.taskReportConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.UpdateTaskRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the resource name of the Amazon CloudWatch log group.
         */
        public var cloudWatchLogGroupArn: kotlin.String? = null
        /**
         * Specifies a list of filter rules that exclude specific data during your transfer. For more information and examples, see [Filtering data transferred by DataSync](https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html).
         */
        public var excludes: List<FilterRule>? = null
        /**
         * Specifies a list of filter rules that include specific data during your transfer. For more information and examples, see [Filtering data transferred by DataSync](https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html).
         */
        public var includes: List<FilterRule>? = null
        /**
         * The name of the task to update.
         */
        public var name: kotlin.String? = null
        /**
         * Indicates how your transfer task is configured. These options include how DataSync handles files, objects, and their associated metadata during your transfer. You also can specify how to verify data integrity, set bandwidth limits for your task, among other options.
         *
         * Each option has a default value. Unless you need to, you don't have to configure any of these options before starting your task.
         */
        public var options: aws.sdk.kotlin.services.datasync.model.Options? = null
        /**
         * Specifies a schedule used to periodically transfer files from a source to a destination location. You can configure your task to execute hourly, daily, weekly or on specific days of the week. You control when in the day or hour you want the task to execute. The time you specify is UTC time. For more information, see [Scheduling your task](https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html).
         */
        public var schedule: aws.sdk.kotlin.services.datasync.model.TaskSchedule? = null
        /**
         * The Amazon Resource Name (ARN) of the resource name of the task to update.
         */
        public var taskArn: kotlin.String? = null
        /**
         * Specifies how you want to configure a task report, which provides detailed information about for your DataSync transfer.
         */
        public var taskReportConfig: aws.sdk.kotlin.services.datasync.model.TaskReportConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.UpdateTaskRequest) : this() {
            this.cloudWatchLogGroupArn = x.cloudWatchLogGroupArn
            this.excludes = x.excludes
            this.includes = x.includes
            this.name = x.name
            this.options = x.options
            this.schedule = x.schedule
            this.taskArn = x.taskArn
            this.taskReportConfig = x.taskReportConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.UpdateTaskRequest = UpdateTaskRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.Options] inside the given [block]
         */
        public fun options(block: aws.sdk.kotlin.services.datasync.model.Options.Builder.() -> kotlin.Unit) {
            this.options = aws.sdk.kotlin.services.datasync.model.Options.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.TaskSchedule] inside the given [block]
         */
        public fun schedule(block: aws.sdk.kotlin.services.datasync.model.TaskSchedule.Builder.() -> kotlin.Unit) {
            this.schedule = aws.sdk.kotlin.services.datasync.model.TaskSchedule.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.TaskReportConfig] inside the given [block]
         */
        public fun taskReportConfig(block: aws.sdk.kotlin.services.datasync.model.TaskReportConfig.Builder.() -> kotlin.Unit) {
            this.taskReportConfig = aws.sdk.kotlin.services.datasync.model.TaskReportConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
