// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model



public class UpdateStorageSystemRequest private constructor(builder: Builder) {
    /**
     * Specifies the Amazon Resource Name (ARN) of the DataSync agent that connects to and reads your on-premises storage system. You can only specify one ARN.
     */
    public val agentArns: List<String>? = builder.agentArns
    /**
     * Specifies the ARN of the Amazon CloudWatch log group for monitoring and logging discovery job events.
     */
    public val cloudWatchLogGroupArn: kotlin.String? = builder.cloudWatchLogGroupArn
    /**
     * Specifies the user name and password for accessing your on-premises storage system's management interface.
     */
    public val credentials: aws.sdk.kotlin.services.datasync.model.Credentials? = builder.credentials
    /**
     * Specifies a familiar name for your on-premises storage system.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Specifies the server name and network port required to connect with your on-premises storage system's management interface.
     */
    public val serverConfiguration: aws.sdk.kotlin.services.datasync.model.DiscoveryServerConfiguration? = builder.serverConfiguration
    /**
     * Specifies the ARN of the on-premises storage system that you want reconfigure.
     */
    public val storageSystemArn: kotlin.String? = builder.storageSystemArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.UpdateStorageSystemRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateStorageSystemRequest(")
        append("agentArns=$agentArns,")
        append("cloudWatchLogGroupArn=$cloudWatchLogGroupArn,")
        append("credentials=$credentials,")
        append("name=$name,")
        append("serverConfiguration=$serverConfiguration,")
        append("storageSystemArn=$storageSystemArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentArns?.hashCode() ?: 0
        result = 31 * result + (cloudWatchLogGroupArn?.hashCode() ?: 0)
        result = 31 * result + (credentials?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (serverConfiguration?.hashCode() ?: 0)
        result = 31 * result + (storageSystemArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateStorageSystemRequest

        if (agentArns != other.agentArns) return false
        if (cloudWatchLogGroupArn != other.cloudWatchLogGroupArn) return false
        if (credentials != other.credentials) return false
        if (name != other.name) return false
        if (serverConfiguration != other.serverConfiguration) return false
        if (storageSystemArn != other.storageSystemArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.UpdateStorageSystemRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the Amazon Resource Name (ARN) of the DataSync agent that connects to and reads your on-premises storage system. You can only specify one ARN.
         */
        public var agentArns: List<String>? = null
        /**
         * Specifies the ARN of the Amazon CloudWatch log group for monitoring and logging discovery job events.
         */
        public var cloudWatchLogGroupArn: kotlin.String? = null
        /**
         * Specifies the user name and password for accessing your on-premises storage system's management interface.
         */
        public var credentials: aws.sdk.kotlin.services.datasync.model.Credentials? = null
        /**
         * Specifies a familiar name for your on-premises storage system.
         */
        public var name: kotlin.String? = null
        /**
         * Specifies the server name and network port required to connect with your on-premises storage system's management interface.
         */
        public var serverConfiguration: aws.sdk.kotlin.services.datasync.model.DiscoveryServerConfiguration? = null
        /**
         * Specifies the ARN of the on-premises storage system that you want reconfigure.
         */
        public var storageSystemArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.UpdateStorageSystemRequest) : this() {
            this.agentArns = x.agentArns
            this.cloudWatchLogGroupArn = x.cloudWatchLogGroupArn
            this.credentials = x.credentials
            this.name = x.name
            this.serverConfiguration = x.serverConfiguration
            this.storageSystemArn = x.storageSystemArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.UpdateStorageSystemRequest = UpdateStorageSystemRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.Credentials] inside the given [block]
         */
        public fun credentials(block: aws.sdk.kotlin.services.datasync.model.Credentials.Builder.() -> kotlin.Unit) {
            this.credentials = aws.sdk.kotlin.services.datasync.model.Credentials.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.DiscoveryServerConfiguration] inside the given [block]
         */
        public fun serverConfiguration(block: aws.sdk.kotlin.services.datasync.model.DiscoveryServerConfiguration.Builder.() -> kotlin.Unit) {
            this.serverConfiguration = aws.sdk.kotlin.services.datasync.model.DiscoveryServerConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
