// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model



public class UpdateLocationNfsRequest private constructor(builder: Builder) {
    /**
     * Specifies the Amazon Resource Name (ARN) of the NFS transfer location that you want to update.
     */
    public val locationArn: kotlin.String? = builder.locationArn
    /**
     * Specifies how DataSync can access a location using the NFS protocol.
     */
    public val mountOptions: aws.sdk.kotlin.services.datasync.model.NfsMountOptions? = builder.mountOptions
    /**
     * The DataSync agents that are connecting to a Network File System (NFS) location.
     */
    public val onPremConfig: aws.sdk.kotlin.services.datasync.model.OnPremConfig? = builder.onPremConfig
    /**
     * Specifies the export path in your NFS file server that you want DataSync to mount.
     *
     * This path (or a subdirectory of the path) is where DataSync transfers data to or from. For information on configuring an export for DataSync, see [Accessing NFS file servers](https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#accessing-nfs).
     */
    public val subdirectory: kotlin.String? = builder.subdirectory

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.UpdateLocationNfsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateLocationNfsRequest(")
        append("locationArn=$locationArn,")
        append("mountOptions=$mountOptions,")
        append("onPremConfig=$onPremConfig,")
        append("subdirectory=$subdirectory")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = locationArn?.hashCode() ?: 0
        result = 31 * result + (mountOptions?.hashCode() ?: 0)
        result = 31 * result + (onPremConfig?.hashCode() ?: 0)
        result = 31 * result + (subdirectory?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateLocationNfsRequest

        if (locationArn != other.locationArn) return false
        if (mountOptions != other.mountOptions) return false
        if (onPremConfig != other.onPremConfig) return false
        if (subdirectory != other.subdirectory) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.UpdateLocationNfsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the Amazon Resource Name (ARN) of the NFS transfer location that you want to update.
         */
        public var locationArn: kotlin.String? = null
        /**
         * Specifies how DataSync can access a location using the NFS protocol.
         */
        public var mountOptions: aws.sdk.kotlin.services.datasync.model.NfsMountOptions? = null
        /**
         * The DataSync agents that are connecting to a Network File System (NFS) location.
         */
        public var onPremConfig: aws.sdk.kotlin.services.datasync.model.OnPremConfig? = null
        /**
         * Specifies the export path in your NFS file server that you want DataSync to mount.
         *
         * This path (or a subdirectory of the path) is where DataSync transfers data to or from. For information on configuring an export for DataSync, see [Accessing NFS file servers](https://docs.aws.amazon.com/datasync/latest/userguide/create-nfs-location.html#accessing-nfs).
         */
        public var subdirectory: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.UpdateLocationNfsRequest) : this() {
            this.locationArn = x.locationArn
            this.mountOptions = x.mountOptions
            this.onPremConfig = x.onPremConfig
            this.subdirectory = x.subdirectory
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.UpdateLocationNfsRequest = UpdateLocationNfsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.NfsMountOptions] inside the given [block]
         */
        public fun mountOptions(block: aws.sdk.kotlin.services.datasync.model.NfsMountOptions.Builder.() -> kotlin.Unit) {
            this.mountOptions = aws.sdk.kotlin.services.datasync.model.NfsMountOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.OnPremConfig] inside the given [block]
         */
        public fun onPremConfig(block: aws.sdk.kotlin.services.datasync.model.OnPremConfig.Builder.() -> kotlin.Unit) {
            this.onPremConfig = aws.sdk.kotlin.services.datasync.model.OnPremConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
