// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model



public class UpdateLocationAzureBlobRequest private constructor(builder: Builder) {
    /**
     * Specifies the access tier that you want your objects or files transferred into. This only applies when using the location as a transfer destination. For more information, see [Access tiers](https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-access-tiers).
     */
    public val accessTier: aws.sdk.kotlin.services.datasync.model.AzureAccessTier? = builder.accessTier
    /**
     * Specifies the Amazon Resource Name (ARN) of the DataSync agent that can connect with your Azure Blob Storage container.
     *
     * You can specify more than one agent. For more information, see [Using multiple agents for your transfer](https://docs.aws.amazon.com/datasync/latest/userguide/multiple-agents.html).
     */
    public val agentArns: List<String>? = builder.agentArns
    /**
     * Specifies the authentication method DataSync uses to access your Azure Blob Storage. DataSync can access blob storage using a shared access signature (SAS).
     */
    public val authenticationType: aws.sdk.kotlin.services.datasync.model.AzureBlobAuthenticationType? = builder.authenticationType
    /**
     * Specifies the type of blob that you want your objects or files to be when transferring them into Azure Blob Storage. Currently, DataSync only supports moving data into Azure Blob Storage as block blobs. For more information on blob types, see the [Azure Blob Storage documentation](https://learn.microsoft.com/en-us/rest/api/storageservices/understanding-block-blobs--append-blobs--and-page-blobs).
     */
    public val blobType: aws.sdk.kotlin.services.datasync.model.AzureBlobType? = builder.blobType
    /**
     * Specifies the ARN of the Azure Blob Storage transfer location that you're updating.
     */
    public val locationArn: kotlin.String? = builder.locationArn
    /**
     * Specifies the SAS configuration that allows DataSync to access your Azure Blob Storage.
     */
    public val sasConfiguration: aws.sdk.kotlin.services.datasync.model.AzureBlobSasConfiguration? = builder.sasConfiguration
    /**
     * Specifies path segments if you want to limit your transfer to a virtual directory in your container (for example, `/my/images`).
     */
    public val subdirectory: kotlin.String? = builder.subdirectory

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.UpdateLocationAzureBlobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateLocationAzureBlobRequest(")
        append("accessTier=$accessTier,")
        append("agentArns=$agentArns,")
        append("authenticationType=$authenticationType,")
        append("blobType=$blobType,")
        append("locationArn=$locationArn,")
        append("sasConfiguration=$sasConfiguration,")
        append("subdirectory=$subdirectory")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessTier?.hashCode() ?: 0
        result = 31 * result + (agentArns?.hashCode() ?: 0)
        result = 31 * result + (authenticationType?.hashCode() ?: 0)
        result = 31 * result + (blobType?.hashCode() ?: 0)
        result = 31 * result + (locationArn?.hashCode() ?: 0)
        result = 31 * result + (sasConfiguration?.hashCode() ?: 0)
        result = 31 * result + (subdirectory?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateLocationAzureBlobRequest

        if (accessTier != other.accessTier) return false
        if (agentArns != other.agentArns) return false
        if (authenticationType != other.authenticationType) return false
        if (blobType != other.blobType) return false
        if (locationArn != other.locationArn) return false
        if (sasConfiguration != other.sasConfiguration) return false
        if (subdirectory != other.subdirectory) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.UpdateLocationAzureBlobRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the access tier that you want your objects or files transferred into. This only applies when using the location as a transfer destination. For more information, see [Access tiers](https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-access-tiers).
         */
        public var accessTier: aws.sdk.kotlin.services.datasync.model.AzureAccessTier? = null
        /**
         * Specifies the Amazon Resource Name (ARN) of the DataSync agent that can connect with your Azure Blob Storage container.
         *
         * You can specify more than one agent. For more information, see [Using multiple agents for your transfer](https://docs.aws.amazon.com/datasync/latest/userguide/multiple-agents.html).
         */
        public var agentArns: List<String>? = null
        /**
         * Specifies the authentication method DataSync uses to access your Azure Blob Storage. DataSync can access blob storage using a shared access signature (SAS).
         */
        public var authenticationType: aws.sdk.kotlin.services.datasync.model.AzureBlobAuthenticationType? = null
        /**
         * Specifies the type of blob that you want your objects or files to be when transferring them into Azure Blob Storage. Currently, DataSync only supports moving data into Azure Blob Storage as block blobs. For more information on blob types, see the [Azure Blob Storage documentation](https://learn.microsoft.com/en-us/rest/api/storageservices/understanding-block-blobs--append-blobs--and-page-blobs).
         */
        public var blobType: aws.sdk.kotlin.services.datasync.model.AzureBlobType? = null
        /**
         * Specifies the ARN of the Azure Blob Storage transfer location that you're updating.
         */
        public var locationArn: kotlin.String? = null
        /**
         * Specifies the SAS configuration that allows DataSync to access your Azure Blob Storage.
         */
        public var sasConfiguration: aws.sdk.kotlin.services.datasync.model.AzureBlobSasConfiguration? = null
        /**
         * Specifies path segments if you want to limit your transfer to a virtual directory in your container (for example, `/my/images`).
         */
        public var subdirectory: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.UpdateLocationAzureBlobRequest) : this() {
            this.accessTier = x.accessTier
            this.agentArns = x.agentArns
            this.authenticationType = x.authenticationType
            this.blobType = x.blobType
            this.locationArn = x.locationArn
            this.sasConfiguration = x.sasConfiguration
            this.subdirectory = x.subdirectory
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.UpdateLocationAzureBlobRequest = UpdateLocationAzureBlobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.AzureBlobSasConfiguration] inside the given [block]
         */
        public fun sasConfiguration(block: aws.sdk.kotlin.services.datasync.model.AzureBlobSasConfiguration.Builder.() -> kotlin.Unit) {
            this.sasConfiguration = aws.sdk.kotlin.services.datasync.model.AzureBlobSasConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
