// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model



public class StartDiscoveryJobRequest private constructor(builder: Builder) {
    /**
     * Specifies a client token to make sure requests with this API operation are idempotent. If you don't specify a client token, DataSync generates one for you automatically.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * Specifies in minutes how long you want the discovery job to run.
     *
     * For more accurate recommendations, we recommend a duration of at least 14 days. Longer durations allow time to collect a sufficient number of data points and provide a realistic representation of storage performance and utilization.
     */
    public val collectionDurationMinutes: kotlin.Int? = builder.collectionDurationMinutes
    /**
     * Specifies the Amazon Resource Name (ARN) of the on-premises storage system that you want to run the discovery job on.
     */
    public val storageSystemArn: kotlin.String? = builder.storageSystemArn
    /**
     * Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources.
     */
    public val tags: List<TagListEntry>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.StartDiscoveryJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartDiscoveryJobRequest(")
        append("clientToken=$clientToken,")
        append("collectionDurationMinutes=$collectionDurationMinutes,")
        append("storageSystemArn=$storageSystemArn,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (collectionDurationMinutes ?: 0)
        result = 31 * result + (storageSystemArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartDiscoveryJobRequest

        if (clientToken != other.clientToken) return false
        if (collectionDurationMinutes != other.collectionDurationMinutes) return false
        if (storageSystemArn != other.storageSystemArn) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.StartDiscoveryJobRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies a client token to make sure requests with this API operation are idempotent. If you don't specify a client token, DataSync generates one for you automatically.
         */
        public var clientToken: kotlin.String? = null
        /**
         * Specifies in minutes how long you want the discovery job to run.
         *
         * For more accurate recommendations, we recommend a duration of at least 14 days. Longer durations allow time to collect a sufficient number of data points and provide a realistic representation of storage performance and utilization.
         */
        public var collectionDurationMinutes: kotlin.Int? = null
        /**
         * Specifies the Amazon Resource Name (ARN) of the on-premises storage system that you want to run the discovery job on.
         */
        public var storageSystemArn: kotlin.String? = null
        /**
         * Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources.
         */
        public var tags: List<TagListEntry>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.StartDiscoveryJobRequest) : this() {
            this.clientToken = x.clientToken
            this.collectionDurationMinutes = x.collectionDurationMinutes
            this.storageSystemArn = x.storageSystemArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.StartDiscoveryJobRequest = StartDiscoveryJobRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
