// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model



/**
 * Specifies the Server Message Block (SMB) protocol configuration that DataSync uses to access your Amazon FSx for NetApp ONTAP file system. For more information, see [Accessing FSx for ONTAP file systems](https://docs.aws.amazon.com/datasync/latest/userguide/create-ontap-location.html#create-ontap-location-access).
 */
public class FsxProtocolSmb private constructor(builder: Builder) {
    /**
     * Specifies the fully qualified domain name (FQDN) of the Microsoft Active Directory that your storage virtual machine (SVM) belongs to.
     */
    public val domain: kotlin.String? = builder.domain
    /**
     * Specifies the version of the Server Message Block (SMB) protocol that DataSync uses to access an SMB file server.
     */
    public val mountOptions: aws.sdk.kotlin.services.datasync.model.SmbMountOptions? = builder.mountOptions
    /**
     * Specifies the password of a user who has permission to access your SVM.
     */
    public val password: kotlin.String = requireNotNull(builder.password) { "A non-null value must be provided for password" }
    /**
     * Specifies a user name that can mount the location and access the files, folders, and metadata that you need in the SVM.
     *
     * If you provide a user in your Active Directory, note the following:
     * + If you're using Directory Service for Microsoft Active Directory, the user must be a member of the Amazon Web Services Delegated FSx Administrators group.
     * + If you're using a self-managed Active Directory, the user must be a member of either the Domain Admins group or a custom group that you specified for file system administration when you created your file system.
     *
     * Make sure that the user has the permissions it needs to copy the data you want:
     * + `SE_TCB_NAME`: Required to set object ownership and file metadata. With this privilege, you also can copy NTFS discretionary access lists (DACLs).
     * + `SE_SECURITY_NAME`: May be needed to copy NTFS system access control lists (SACLs). This operation specifically requires the Windows privilege, which is granted to members of the Domain Admins group. If you configure your task to copy SACLs, make sure that the user has the required privileges. For information about copying SACLs, see [Ownership and permissions-related options](https://docs.aws.amazon.com/datasync/latest/userguide/create-task.html#configure-ownership-and-permissions).
     */
    public val user: kotlin.String = requireNotNull(builder.user) { "A non-null value must be provided for user" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.FsxProtocolSmb = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FsxProtocolSmb(")
        append("domain=$domain,")
        append("mountOptions=$mountOptions,")
        append("password=*** Sensitive Data Redacted ***,")
        append("user=$user")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = domain?.hashCode() ?: 0
        result = 31 * result + (mountOptions?.hashCode() ?: 0)
        result = 31 * result + (password.hashCode())
        result = 31 * result + (user.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FsxProtocolSmb

        if (domain != other.domain) return false
        if (mountOptions != other.mountOptions) return false
        if (password != other.password) return false
        if (user != other.user) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.FsxProtocolSmb = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the fully qualified domain name (FQDN) of the Microsoft Active Directory that your storage virtual machine (SVM) belongs to.
         */
        public var domain: kotlin.String? = null
        /**
         * Specifies the version of the Server Message Block (SMB) protocol that DataSync uses to access an SMB file server.
         */
        public var mountOptions: aws.sdk.kotlin.services.datasync.model.SmbMountOptions? = null
        /**
         * Specifies the password of a user who has permission to access your SVM.
         */
        public var password: kotlin.String? = null
        /**
         * Specifies a user name that can mount the location and access the files, folders, and metadata that you need in the SVM.
         *
         * If you provide a user in your Active Directory, note the following:
         * + If you're using Directory Service for Microsoft Active Directory, the user must be a member of the Amazon Web Services Delegated FSx Administrators group.
         * + If you're using a self-managed Active Directory, the user must be a member of either the Domain Admins group or a custom group that you specified for file system administration when you created your file system.
         *
         * Make sure that the user has the permissions it needs to copy the data you want:
         * + `SE_TCB_NAME`: Required to set object ownership and file metadata. With this privilege, you also can copy NTFS discretionary access lists (DACLs).
         * + `SE_SECURITY_NAME`: May be needed to copy NTFS system access control lists (SACLs). This operation specifically requires the Windows privilege, which is granted to members of the Domain Admins group. If you configure your task to copy SACLs, make sure that the user has the required privileges. For information about copying SACLs, see [Ownership and permissions-related options](https://docs.aws.amazon.com/datasync/latest/userguide/create-task.html#configure-ownership-and-permissions).
         */
        public var user: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.FsxProtocolSmb) : this() {
            this.domain = x.domain
            this.mountOptions = x.mountOptions
            this.password = x.password
            this.user = x.user
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.FsxProtocolSmb = FsxProtocolSmb(this)

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.SmbMountOptions] inside the given [block]
         */
        public fun mountOptions(block: aws.sdk.kotlin.services.datasync.model.SmbMountOptions.Builder.() -> kotlin.Unit) {
            this.mountOptions = aws.sdk.kotlin.services.datasync.model.SmbMountOptions.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (password == null) password = ""
            if (user == null) user = ""
            return this
        }
    }
}
