// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * DescribeTaskResponse
 */
public class DescribeTaskResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that was used to monitor and log events in the task.
     *
     * For more information on these groups, see Working with Log Groups and Log Streams in the *Amazon CloudWatch User Guide*.
     */
    public val cloudWatchLogGroupArn: kotlin.String? = builder.cloudWatchLogGroupArn
    /**
     * The time that the task was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The Amazon Resource Name (ARN) of the task execution that is transferring files.
     */
    public val currentTaskExecutionArn: kotlin.String? = builder.currentTaskExecutionArn
    /**
     * The Amazon Resource Name (ARN) of the Amazon Web Services storage resource's location.
     */
    public val destinationLocationArn: kotlin.String? = builder.destinationLocationArn
    /**
     * The Amazon Resource Names (ARNs) of the network interfaces created for your destination location. For more information, see [Network interface requirements](https://docs.aws.amazon.com/datasync/latest/userguide/datasync-network.html#required-network-interfaces).
     */
    public val destinationNetworkInterfaceArns: List<String>? = builder.destinationNetworkInterfaceArns
    /**
     * Errors that DataSync encountered during execution of the task. You can use this error code to help troubleshoot issues.
     */
    public val errorCode: kotlin.String? = builder.errorCode
    /**
     * Detailed description of an error that was encountered during the task execution. You can use this information to help troubleshoot issues.
     */
    public val errorDetail: kotlin.String? = builder.errorDetail
    /**
     * A list of filter rules that exclude specific data during your transfer. For more information and examples, see [Filtering data transferred by DataSync](https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html).
     */
    public val excludes: List<FilterRule>? = builder.excludes
    /**
     * A list of filter rules that include specific data during your transfer. For more information and examples, see [Filtering data transferred by DataSync](https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html).
     */
    public val includes: List<FilterRule>? = builder.includes
    /**
     * The name of the task that was described.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The configuration options that control the behavior of the `StartTaskExecution` operation. Some options include preserving file or object metadata and verifying data integrity.
     *
     * You can override these options for each task execution. For more information, see [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html).
     */
    public val options: aws.sdk.kotlin.services.datasync.model.Options? = builder.options
    /**
     * The schedule used to periodically transfer files from a source to a destination location.
     */
    public val schedule: aws.sdk.kotlin.services.datasync.model.TaskSchedule? = builder.schedule
    /**
     * The Amazon Resource Name (ARN) of the source file system's location.
     */
    public val sourceLocationArn: kotlin.String? = builder.sourceLocationArn
    /**
     * The Amazon Resource Names (ARNs) of the network interfaces created for your source location. For more information, see [Network interface requirements](https://docs.aws.amazon.com/datasync/latest/userguide/datasync-network.html#required-network-interfaces).
     */
    public val sourceNetworkInterfaceArns: List<String>? = builder.sourceNetworkInterfaceArns
    /**
     * The status of the task that was described.
     *
     * For detailed information about task execution statuses, see Understanding Task Statuses in the *DataSync User Guide*.
     */
    public val status: aws.sdk.kotlin.services.datasync.model.TaskStatus? = builder.status
    /**
     * The Amazon Resource Name (ARN) of the task that was described.
     */
    public val taskArn: kotlin.String? = builder.taskArn
    /**
     * The configuration of your task report. For more information, see [Creating a task report](https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html).
     */
    public val taskReportConfig: aws.sdk.kotlin.services.datasync.model.TaskReportConfig? = builder.taskReportConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.DescribeTaskResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeTaskResponse(")
        append("cloudWatchLogGroupArn=$cloudWatchLogGroupArn,")
        append("creationTime=$creationTime,")
        append("currentTaskExecutionArn=$currentTaskExecutionArn,")
        append("destinationLocationArn=$destinationLocationArn,")
        append("destinationNetworkInterfaceArns=$destinationNetworkInterfaceArns,")
        append("errorCode=$errorCode,")
        append("errorDetail=$errorDetail,")
        append("excludes=$excludes,")
        append("includes=$includes,")
        append("name=$name,")
        append("options=$options,")
        append("schedule=$schedule,")
        append("sourceLocationArn=$sourceLocationArn,")
        append("sourceNetworkInterfaceArns=$sourceNetworkInterfaceArns,")
        append("status=$status,")
        append("taskArn=$taskArn,")
        append("taskReportConfig=$taskReportConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchLogGroupArn?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (currentTaskExecutionArn?.hashCode() ?: 0)
        result = 31 * result + (destinationLocationArn?.hashCode() ?: 0)
        result = 31 * result + (destinationNetworkInterfaceArns?.hashCode() ?: 0)
        result = 31 * result + (errorCode?.hashCode() ?: 0)
        result = 31 * result + (errorDetail?.hashCode() ?: 0)
        result = 31 * result + (excludes?.hashCode() ?: 0)
        result = 31 * result + (includes?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (options?.hashCode() ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        result = 31 * result + (sourceLocationArn?.hashCode() ?: 0)
        result = 31 * result + (sourceNetworkInterfaceArns?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (taskArn?.hashCode() ?: 0)
        result = 31 * result + (taskReportConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeTaskResponse

        if (cloudWatchLogGroupArn != other.cloudWatchLogGroupArn) return false
        if (creationTime != other.creationTime) return false
        if (currentTaskExecutionArn != other.currentTaskExecutionArn) return false
        if (destinationLocationArn != other.destinationLocationArn) return false
        if (destinationNetworkInterfaceArns != other.destinationNetworkInterfaceArns) return false
        if (errorCode != other.errorCode) return false
        if (errorDetail != other.errorDetail) return false
        if (excludes != other.excludes) return false
        if (includes != other.includes) return false
        if (name != other.name) return false
        if (options != other.options) return false
        if (schedule != other.schedule) return false
        if (sourceLocationArn != other.sourceLocationArn) return false
        if (sourceNetworkInterfaceArns != other.sourceNetworkInterfaceArns) return false
        if (status != other.status) return false
        if (taskArn != other.taskArn) return false
        if (taskReportConfig != other.taskReportConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.DescribeTaskResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that was used to monitor and log events in the task.
         *
         * For more information on these groups, see Working with Log Groups and Log Streams in the *Amazon CloudWatch User Guide*.
         */
        public var cloudWatchLogGroupArn: kotlin.String? = null
        /**
         * The time that the task was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the task execution that is transferring files.
         */
        public var currentTaskExecutionArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon Web Services storage resource's location.
         */
        public var destinationLocationArn: kotlin.String? = null
        /**
         * The Amazon Resource Names (ARNs) of the network interfaces created for your destination location. For more information, see [Network interface requirements](https://docs.aws.amazon.com/datasync/latest/userguide/datasync-network.html#required-network-interfaces).
         */
        public var destinationNetworkInterfaceArns: List<String>? = null
        /**
         * Errors that DataSync encountered during execution of the task. You can use this error code to help troubleshoot issues.
         */
        public var errorCode: kotlin.String? = null
        /**
         * Detailed description of an error that was encountered during the task execution. You can use this information to help troubleshoot issues.
         */
        public var errorDetail: kotlin.String? = null
        /**
         * A list of filter rules that exclude specific data during your transfer. For more information and examples, see [Filtering data transferred by DataSync](https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html).
         */
        public var excludes: List<FilterRule>? = null
        /**
         * A list of filter rules that include specific data during your transfer. For more information and examples, see [Filtering data transferred by DataSync](https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html).
         */
        public var includes: List<FilterRule>? = null
        /**
         * The name of the task that was described.
         */
        public var name: kotlin.String? = null
        /**
         * The configuration options that control the behavior of the `StartTaskExecution` operation. Some options include preserving file or object metadata and verifying data integrity.
         *
         * You can override these options for each task execution. For more information, see [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html).
         */
        public var options: aws.sdk.kotlin.services.datasync.model.Options? = null
        /**
         * The schedule used to periodically transfer files from a source to a destination location.
         */
        public var schedule: aws.sdk.kotlin.services.datasync.model.TaskSchedule? = null
        /**
         * The Amazon Resource Name (ARN) of the source file system's location.
         */
        public var sourceLocationArn: kotlin.String? = null
        /**
         * The Amazon Resource Names (ARNs) of the network interfaces created for your source location. For more information, see [Network interface requirements](https://docs.aws.amazon.com/datasync/latest/userguide/datasync-network.html#required-network-interfaces).
         */
        public var sourceNetworkInterfaceArns: List<String>? = null
        /**
         * The status of the task that was described.
         *
         * For detailed information about task execution statuses, see Understanding Task Statuses in the *DataSync User Guide*.
         */
        public var status: aws.sdk.kotlin.services.datasync.model.TaskStatus? = null
        /**
         * The Amazon Resource Name (ARN) of the task that was described.
         */
        public var taskArn: kotlin.String? = null
        /**
         * The configuration of your task report. For more information, see [Creating a task report](https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html).
         */
        public var taskReportConfig: aws.sdk.kotlin.services.datasync.model.TaskReportConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.DescribeTaskResponse) : this() {
            this.cloudWatchLogGroupArn = x.cloudWatchLogGroupArn
            this.creationTime = x.creationTime
            this.currentTaskExecutionArn = x.currentTaskExecutionArn
            this.destinationLocationArn = x.destinationLocationArn
            this.destinationNetworkInterfaceArns = x.destinationNetworkInterfaceArns
            this.errorCode = x.errorCode
            this.errorDetail = x.errorDetail
            this.excludes = x.excludes
            this.includes = x.includes
            this.name = x.name
            this.options = x.options
            this.schedule = x.schedule
            this.sourceLocationArn = x.sourceLocationArn
            this.sourceNetworkInterfaceArns = x.sourceNetworkInterfaceArns
            this.status = x.status
            this.taskArn = x.taskArn
            this.taskReportConfig = x.taskReportConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.DescribeTaskResponse = DescribeTaskResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.Options] inside the given [block]
         */
        public fun options(block: aws.sdk.kotlin.services.datasync.model.Options.Builder.() -> kotlin.Unit) {
            this.options = aws.sdk.kotlin.services.datasync.model.Options.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.TaskSchedule] inside the given [block]
         */
        public fun schedule(block: aws.sdk.kotlin.services.datasync.model.TaskSchedule.Builder.() -> kotlin.Unit) {
            this.schedule = aws.sdk.kotlin.services.datasync.model.TaskSchedule.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.TaskReportConfig] inside the given [block]
         */
        public fun taskReportConfig(block: aws.sdk.kotlin.services.datasync.model.TaskReportConfig.Builder.() -> kotlin.Unit) {
            this.taskReportConfig = aws.sdk.kotlin.services.datasync.model.TaskReportConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
