// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * DescribeTaskExecutionResponse
 */
public class DescribeTaskExecutionResponse private constructor(builder: Builder) {
    /**
     * The physical number of bytes transferred over the network after compression was applied. In most cases, this number is less than `BytesTransferred` unless the data isn't compressible.
     */
    public val bytesCompressed: kotlin.Long = builder.bytesCompressed
    /**
     * The total number of bytes that are involved in the transfer. For the number of bytes sent over the network, see `BytesCompressed`.
     */
    public val bytesTransferred: kotlin.Long = builder.bytesTransferred
    /**
     * The number of logical bytes written to the destination location.
     */
    public val bytesWritten: kotlin.Long = builder.bytesWritten
    /**
     * The estimated physical number of bytes that will transfer over the network.
     */
    public val estimatedBytesToTransfer: kotlin.Long = builder.estimatedBytesToTransfer
    /**
     * The expected number of files, objects, and directories that DataSync will delete in your destination location. If you don't [configure your task](https://docs.aws.amazon.com/datasync/latest/userguide/configure-metadata.html) to delete data in the destination that isn't in the source, the value is always `0`.
     */
    public val estimatedFilesToDelete: kotlin.Long = builder.estimatedFilesToDelete
    /**
     * The expected number of files, objects, and directories that DataSync will transfer over the network. This value is calculated during the task execution's `PREPARING` phase before the `TRANSFERRING` phase. The calculation is based on comparing the content of the source and destination locations and finding the difference that needs to be transferred.
     */
    public val estimatedFilesToTransfer: kotlin.Long = builder.estimatedFilesToTransfer
    /**
     * A list of filter rules that exclude specific data during your transfer. For more information and examples, see [Filtering data transferred by DataSync](https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html).
     */
    public val excludes: List<FilterRule>? = builder.excludes
    /**
     * The number of files, objects, and directories that DataSync deleted in your destination location. If you don't [configure your task](https://docs.aws.amazon.com/datasync/latest/userguide/configure-metadata.html) to delete data in the destination that isn't in the source, the value is always `0`.
     */
    public val filesDeleted: kotlin.Long = builder.filesDeleted
    /**
     * The number of files, objects, and directories that DataSync skipped during your transfer.
     */
    public val filesSkipped: kotlin.Long = builder.filesSkipped
    /**
     * The actual number of files, objects, and directories that DataSync transferred over the network. This value is updated periodically during the task execution's `TRANSFERRING` phase when something is read from the source and sent over the network.
     *
     * If DataSync fails to transfer something, this value can be less than `EstimatedFilesToTransfer`. In some cases, this value can also be greater than `EstimatedFilesToTransfer`. This element is implementation-specific for some location types, so don't use it as an exact indication of what transferred or to monitor your task execution.
     */
    public val filesTransferred: kotlin.Long = builder.filesTransferred
    /**
     * The number of files, objects, and directories that DataSync verified during your transfer.
     *
     * When you configure your task to [verify only the data that's transferred](https://docs.aws.amazon.com/datasync/latest/userguide/configure-data-verification-options.html), DataSync doesn't verify directories in some situations or files that fail to transfer.
     */
    public val filesVerified: kotlin.Long = builder.filesVerified
    /**
     * A list of filter rules that include specific data during your transfer. For more information and examples, see [Filtering data transferred by DataSync](https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html).
     */
    public val includes: List<FilterRule>? = builder.includes
    /**
     * Indicates how your transfer task is configured. These options include how DataSync handles files, objects, and their associated metadata during your transfer. You also can specify how to verify data integrity, set bandwidth limits for your task, among other options.
     *
     * Each option has a default value. Unless you need to, you don't have to configure any of these options before starting your task.
     */
    public val options: aws.sdk.kotlin.services.datasync.model.Options? = builder.options
    /**
     * Indicates whether DataSync generated a complete [task report](https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html) for your transfer.
     */
    public val reportResult: aws.sdk.kotlin.services.datasync.model.ReportResult? = builder.reportResult
    /**
     * The result of the task execution.
     */
    public val result: aws.sdk.kotlin.services.datasync.model.TaskExecutionResultDetail? = builder.result
    /**
     * The time when the task execution started.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The status of the task execution.
     */
    public val status: aws.sdk.kotlin.services.datasync.model.TaskExecutionStatus? = builder.status
    /**
     * The ARN of the task execution that you wanted information about. `TaskExecutionArn` is hierarchical and includes `TaskArn` for the task that was executed.
     *
     * For example, a `TaskExecution` value with the ARN `arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2/execution/exec-08ef1e88ec491019b` executed the task with the ARN `arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2`.
     */
    public val taskExecutionArn: kotlin.String? = builder.taskExecutionArn
    /**
     * The configuration of your task report, which provides detailed information about for your DataSync transfer.
     */
    public val taskReportConfig: aws.sdk.kotlin.services.datasync.model.TaskReportConfig? = builder.taskReportConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.DescribeTaskExecutionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeTaskExecutionResponse(")
        append("bytesCompressed=$bytesCompressed,")
        append("bytesTransferred=$bytesTransferred,")
        append("bytesWritten=$bytesWritten,")
        append("estimatedBytesToTransfer=$estimatedBytesToTransfer,")
        append("estimatedFilesToDelete=$estimatedFilesToDelete,")
        append("estimatedFilesToTransfer=$estimatedFilesToTransfer,")
        append("excludes=$excludes,")
        append("filesDeleted=$filesDeleted,")
        append("filesSkipped=$filesSkipped,")
        append("filesTransferred=$filesTransferred,")
        append("filesVerified=$filesVerified,")
        append("includes=$includes,")
        append("options=$options,")
        append("reportResult=$reportResult,")
        append("result=$result,")
        append("startTime=$startTime,")
        append("status=$status,")
        append("taskExecutionArn=$taskExecutionArn,")
        append("taskReportConfig=$taskReportConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bytesCompressed.hashCode()
        result = 31 * result + (bytesTransferred.hashCode())
        result = 31 * result + (bytesWritten.hashCode())
        result = 31 * result + (estimatedBytesToTransfer.hashCode())
        result = 31 * result + (estimatedFilesToDelete.hashCode())
        result = 31 * result + (estimatedFilesToTransfer.hashCode())
        result = 31 * result + (excludes?.hashCode() ?: 0)
        result = 31 * result + (filesDeleted.hashCode())
        result = 31 * result + (filesSkipped.hashCode())
        result = 31 * result + (filesTransferred.hashCode())
        result = 31 * result + (filesVerified.hashCode())
        result = 31 * result + (includes?.hashCode() ?: 0)
        result = 31 * result + (options?.hashCode() ?: 0)
        result = 31 * result + (reportResult?.hashCode() ?: 0)
        result = 31 * result + (result?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (taskExecutionArn?.hashCode() ?: 0)
        result = 31 * result + (taskReportConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeTaskExecutionResponse

        if (bytesCompressed != other.bytesCompressed) return false
        if (bytesTransferred != other.bytesTransferred) return false
        if (bytesWritten != other.bytesWritten) return false
        if (estimatedBytesToTransfer != other.estimatedBytesToTransfer) return false
        if (estimatedFilesToDelete != other.estimatedFilesToDelete) return false
        if (estimatedFilesToTransfer != other.estimatedFilesToTransfer) return false
        if (excludes != other.excludes) return false
        if (filesDeleted != other.filesDeleted) return false
        if (filesSkipped != other.filesSkipped) return false
        if (filesTransferred != other.filesTransferred) return false
        if (filesVerified != other.filesVerified) return false
        if (includes != other.includes) return false
        if (options != other.options) return false
        if (reportResult != other.reportResult) return false
        if (result != other.result) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (taskExecutionArn != other.taskExecutionArn) return false
        if (taskReportConfig != other.taskReportConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.DescribeTaskExecutionResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The physical number of bytes transferred over the network after compression was applied. In most cases, this number is less than `BytesTransferred` unless the data isn't compressible.
         */
        public var bytesCompressed: kotlin.Long = 0L
        /**
         * The total number of bytes that are involved in the transfer. For the number of bytes sent over the network, see `BytesCompressed`.
         */
        public var bytesTransferred: kotlin.Long = 0L
        /**
         * The number of logical bytes written to the destination location.
         */
        public var bytesWritten: kotlin.Long = 0L
        /**
         * The estimated physical number of bytes that will transfer over the network.
         */
        public var estimatedBytesToTransfer: kotlin.Long = 0L
        /**
         * The expected number of files, objects, and directories that DataSync will delete in your destination location. If you don't [configure your task](https://docs.aws.amazon.com/datasync/latest/userguide/configure-metadata.html) to delete data in the destination that isn't in the source, the value is always `0`.
         */
        public var estimatedFilesToDelete: kotlin.Long = 0L
        /**
         * The expected number of files, objects, and directories that DataSync will transfer over the network. This value is calculated during the task execution's `PREPARING` phase before the `TRANSFERRING` phase. The calculation is based on comparing the content of the source and destination locations and finding the difference that needs to be transferred.
         */
        public var estimatedFilesToTransfer: kotlin.Long = 0L
        /**
         * A list of filter rules that exclude specific data during your transfer. For more information and examples, see [Filtering data transferred by DataSync](https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html).
         */
        public var excludes: List<FilterRule>? = null
        /**
         * The number of files, objects, and directories that DataSync deleted in your destination location. If you don't [configure your task](https://docs.aws.amazon.com/datasync/latest/userguide/configure-metadata.html) to delete data in the destination that isn't in the source, the value is always `0`.
         */
        public var filesDeleted: kotlin.Long = 0L
        /**
         * The number of files, objects, and directories that DataSync skipped during your transfer.
         */
        public var filesSkipped: kotlin.Long = 0L
        /**
         * The actual number of files, objects, and directories that DataSync transferred over the network. This value is updated periodically during the task execution's `TRANSFERRING` phase when something is read from the source and sent over the network.
         *
         * If DataSync fails to transfer something, this value can be less than `EstimatedFilesToTransfer`. In some cases, this value can also be greater than `EstimatedFilesToTransfer`. This element is implementation-specific for some location types, so don't use it as an exact indication of what transferred or to monitor your task execution.
         */
        public var filesTransferred: kotlin.Long = 0L
        /**
         * The number of files, objects, and directories that DataSync verified during your transfer.
         *
         * When you configure your task to [verify only the data that's transferred](https://docs.aws.amazon.com/datasync/latest/userguide/configure-data-verification-options.html), DataSync doesn't verify directories in some situations or files that fail to transfer.
         */
        public var filesVerified: kotlin.Long = 0L
        /**
         * A list of filter rules that include specific data during your transfer. For more information and examples, see [Filtering data transferred by DataSync](https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html).
         */
        public var includes: List<FilterRule>? = null
        /**
         * Indicates how your transfer task is configured. These options include how DataSync handles files, objects, and their associated metadata during your transfer. You also can specify how to verify data integrity, set bandwidth limits for your task, among other options.
         *
         * Each option has a default value. Unless you need to, you don't have to configure any of these options before starting your task.
         */
        public var options: aws.sdk.kotlin.services.datasync.model.Options? = null
        /**
         * Indicates whether DataSync generated a complete [task report](https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html) for your transfer.
         */
        public var reportResult: aws.sdk.kotlin.services.datasync.model.ReportResult? = null
        /**
         * The result of the task execution.
         */
        public var result: aws.sdk.kotlin.services.datasync.model.TaskExecutionResultDetail? = null
        /**
         * The time when the task execution started.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the task execution.
         */
        public var status: aws.sdk.kotlin.services.datasync.model.TaskExecutionStatus? = null
        /**
         * The ARN of the task execution that you wanted information about. `TaskExecutionArn` is hierarchical and includes `TaskArn` for the task that was executed.
         *
         * For example, a `TaskExecution` value with the ARN `arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2/execution/exec-08ef1e88ec491019b` executed the task with the ARN `arn:aws:datasync:us-east-1:111222333444:task/task-0208075f79cedf4a2`.
         */
        public var taskExecutionArn: kotlin.String? = null
        /**
         * The configuration of your task report, which provides detailed information about for your DataSync transfer.
         */
        public var taskReportConfig: aws.sdk.kotlin.services.datasync.model.TaskReportConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.DescribeTaskExecutionResponse) : this() {
            this.bytesCompressed = x.bytesCompressed
            this.bytesTransferred = x.bytesTransferred
            this.bytesWritten = x.bytesWritten
            this.estimatedBytesToTransfer = x.estimatedBytesToTransfer
            this.estimatedFilesToDelete = x.estimatedFilesToDelete
            this.estimatedFilesToTransfer = x.estimatedFilesToTransfer
            this.excludes = x.excludes
            this.filesDeleted = x.filesDeleted
            this.filesSkipped = x.filesSkipped
            this.filesTransferred = x.filesTransferred
            this.filesVerified = x.filesVerified
            this.includes = x.includes
            this.options = x.options
            this.reportResult = x.reportResult
            this.result = x.result
            this.startTime = x.startTime
            this.status = x.status
            this.taskExecutionArn = x.taskExecutionArn
            this.taskReportConfig = x.taskReportConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.DescribeTaskExecutionResponse = DescribeTaskExecutionResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.Options] inside the given [block]
         */
        public fun options(block: aws.sdk.kotlin.services.datasync.model.Options.Builder.() -> kotlin.Unit) {
            this.options = aws.sdk.kotlin.services.datasync.model.Options.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.ReportResult] inside the given [block]
         */
        public fun reportResult(block: aws.sdk.kotlin.services.datasync.model.ReportResult.Builder.() -> kotlin.Unit) {
            this.reportResult = aws.sdk.kotlin.services.datasync.model.ReportResult.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.TaskExecutionResultDetail] inside the given [block]
         */
        public fun result(block: aws.sdk.kotlin.services.datasync.model.TaskExecutionResultDetail.Builder.() -> kotlin.Unit) {
            this.result = aws.sdk.kotlin.services.datasync.model.TaskExecutionResultDetail.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.TaskReportConfig] inside the given [block]
         */
        public fun taskReportConfig(block: aws.sdk.kotlin.services.datasync.model.TaskReportConfig.Builder.() -> kotlin.Unit) {
            this.taskReportConfig = aws.sdk.kotlin.services.datasync.model.TaskReportConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
