// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model

import aws.smithy.kotlin.runtime.time.Instant

public class DescribeStorageSystemResponse private constructor(builder: Builder) {
    /**
     * The ARN of the DataSync agent that connects to and reads from your on-premises storage system.
     */
    public val agentArns: List<String>? = builder.agentArns
    /**
     * The ARN of the Amazon CloudWatch log group that's used to monitor and log discovery job events.
     */
    public val cloudWatchLogGroupArn: kotlin.String? = builder.cloudWatchLogGroupArn
    /**
     * Indicates whether your DataSync agent can connect to your on-premises storage system.
     */
    public val connectivityStatus: aws.sdk.kotlin.services.datasync.model.StorageSystemConnectivityStatus? = builder.connectivityStatus
    /**
     * The time when you added the on-premises storage system to DataSync Discovery.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * Describes the connectivity error that the DataSync agent is encountering with your on-premises storage system.
     */
    public val errorMessage: kotlin.String? = builder.errorMessage
    /**
     * The name that you gave your on-premises storage system when adding it to DataSync Discovery.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The ARN of the secret that stores your on-premises storage system's credentials. DataSync Discovery stores these credentials in [Secrets Manager](https://docs.aws.amazon.com/datasync/latest/userguide/discovery-configure-storage.html#discovery-add-storage).
     */
    public val secretsManagerArn: kotlin.String? = builder.secretsManagerArn
    /**
     * The server name and network port required to connect with your on-premises storage system's management interface.
     */
    public val serverConfiguration: aws.sdk.kotlin.services.datasync.model.DiscoveryServerConfiguration? = builder.serverConfiguration
    /**
     * The ARN of the on-premises storage system that the discovery job looked at.
     */
    public val storageSystemArn: kotlin.String? = builder.storageSystemArn
    /**
     * The type of on-premises storage system.
     *
     * DataSync Discovery currently only supports NetApp Fabric-Attached Storage (FAS) and All Flash FAS (AFF) systems running ONTAP 9.7 or later.
     */
    public val systemType: aws.sdk.kotlin.services.datasync.model.DiscoverySystemType? = builder.systemType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.DescribeStorageSystemResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeStorageSystemResponse(")
        append("agentArns=$agentArns,")
        append("cloudWatchLogGroupArn=$cloudWatchLogGroupArn,")
        append("connectivityStatus=$connectivityStatus,")
        append("creationTime=$creationTime,")
        append("errorMessage=$errorMessage,")
        append("name=$name,")
        append("secretsManagerArn=$secretsManagerArn,")
        append("serverConfiguration=$serverConfiguration,")
        append("storageSystemArn=$storageSystemArn,")
        append("systemType=$systemType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentArns?.hashCode() ?: 0
        result = 31 * result + (cloudWatchLogGroupArn?.hashCode() ?: 0)
        result = 31 * result + (connectivityStatus?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (errorMessage?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (secretsManagerArn?.hashCode() ?: 0)
        result = 31 * result + (serverConfiguration?.hashCode() ?: 0)
        result = 31 * result + (storageSystemArn?.hashCode() ?: 0)
        result = 31 * result + (systemType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeStorageSystemResponse

        if (agentArns != other.agentArns) return false
        if (cloudWatchLogGroupArn != other.cloudWatchLogGroupArn) return false
        if (connectivityStatus != other.connectivityStatus) return false
        if (creationTime != other.creationTime) return false
        if (errorMessage != other.errorMessage) return false
        if (name != other.name) return false
        if (secretsManagerArn != other.secretsManagerArn) return false
        if (serverConfiguration != other.serverConfiguration) return false
        if (storageSystemArn != other.storageSystemArn) return false
        if (systemType != other.systemType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.DescribeStorageSystemResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the DataSync agent that connects to and reads from your on-premises storage system.
         */
        public var agentArns: List<String>? = null
        /**
         * The ARN of the Amazon CloudWatch log group that's used to monitor and log discovery job events.
         */
        public var cloudWatchLogGroupArn: kotlin.String? = null
        /**
         * Indicates whether your DataSync agent can connect to your on-premises storage system.
         */
        public var connectivityStatus: aws.sdk.kotlin.services.datasync.model.StorageSystemConnectivityStatus? = null
        /**
         * The time when you added the on-premises storage system to DataSync Discovery.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Describes the connectivity error that the DataSync agent is encountering with your on-premises storage system.
         */
        public var errorMessage: kotlin.String? = null
        /**
         * The name that you gave your on-premises storage system when adding it to DataSync Discovery.
         */
        public var name: kotlin.String? = null
        /**
         * The ARN of the secret that stores your on-premises storage system's credentials. DataSync Discovery stores these credentials in [Secrets Manager](https://docs.aws.amazon.com/datasync/latest/userguide/discovery-configure-storage.html#discovery-add-storage).
         */
        public var secretsManagerArn: kotlin.String? = null
        /**
         * The server name and network port required to connect with your on-premises storage system's management interface.
         */
        public var serverConfiguration: aws.sdk.kotlin.services.datasync.model.DiscoveryServerConfiguration? = null
        /**
         * The ARN of the on-premises storage system that the discovery job looked at.
         */
        public var storageSystemArn: kotlin.String? = null
        /**
         * The type of on-premises storage system.
         *
         * DataSync Discovery currently only supports NetApp Fabric-Attached Storage (FAS) and All Flash FAS (AFF) systems running ONTAP 9.7 or later.
         */
        public var systemType: aws.sdk.kotlin.services.datasync.model.DiscoverySystemType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.DescribeStorageSystemResponse) : this() {
            this.agentArns = x.agentArns
            this.cloudWatchLogGroupArn = x.cloudWatchLogGroupArn
            this.connectivityStatus = x.connectivityStatus
            this.creationTime = x.creationTime
            this.errorMessage = x.errorMessage
            this.name = x.name
            this.secretsManagerArn = x.secretsManagerArn
            this.serverConfiguration = x.serverConfiguration
            this.storageSystemArn = x.storageSystemArn
            this.systemType = x.systemType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.DescribeStorageSystemResponse = DescribeStorageSystemResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.DiscoveryServerConfiguration] inside the given [block]
         */
        public fun serverConfiguration(block: aws.sdk.kotlin.services.datasync.model.DiscoveryServerConfiguration.Builder.() -> kotlin.Unit) {
            this.serverConfiguration = aws.sdk.kotlin.services.datasync.model.DiscoveryServerConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
