// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * DescribeLocationS3Response
 */
public class DescribeLocationS3Response private constructor(builder: Builder) {
    /**
     * If you are using DataSync on an Amazon Web Services Outpost, the Amazon Resource Name (ARNs) of the EC2 agents deployed on your Outpost. For more information about launching a DataSync agent on an Amazon Web Services Outpost, see [Deploy your DataSync agent on Outposts](https://docs.aws.amazon.com/datasync/latest/userguide/deploy-agents.html#outposts-agent).
     */
    public val agentArns: List<String>? = builder.agentArns
    /**
     * The time that the Amazon S3 bucket location was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The Amazon Resource Name (ARN) of the Amazon S3 bucket or access point.
     */
    public val locationArn: kotlin.String? = builder.locationArn
    /**
     * The URL of the Amazon S3 location that was described.
     */
    public val locationUri: kotlin.String? = builder.locationUri
    /**
     * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role used to access an Amazon S3 bucket.
     *
     * For detailed information about using such a role, see Creating a Location for Amazon S3 in the *DataSync User Guide*.
     */
    public val s3Config: aws.sdk.kotlin.services.datasync.model.S3Config? = builder.s3Config
    /**
     * The Amazon S3 storage class that you chose to store your files in when this location is used as a task destination. For more information about S3 storage classes, see [Amazon S3 Storage Classes](http://aws.amazon.com/s3/storage-classes/). Some storage classes have behaviors that can affect your S3 storage cost. For detailed information, see [Considerations when working with S3 storage classes in DataSync](https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes).
     */
    public val s3StorageClass: aws.sdk.kotlin.services.datasync.model.S3StorageClass? = builder.s3StorageClass

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.DescribeLocationS3Response = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeLocationS3Response(")
        append("agentArns=$agentArns,")
        append("creationTime=$creationTime,")
        append("locationArn=$locationArn,")
        append("locationUri=$locationUri,")
        append("s3Config=$s3Config,")
        append("s3StorageClass=$s3StorageClass")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentArns?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (locationArn?.hashCode() ?: 0)
        result = 31 * result + (locationUri?.hashCode() ?: 0)
        result = 31 * result + (s3Config?.hashCode() ?: 0)
        result = 31 * result + (s3StorageClass?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeLocationS3Response

        if (agentArns != other.agentArns) return false
        if (creationTime != other.creationTime) return false
        if (locationArn != other.locationArn) return false
        if (locationUri != other.locationUri) return false
        if (s3Config != other.s3Config) return false
        if (s3StorageClass != other.s3StorageClass) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.DescribeLocationS3Response = Builder(this).apply(block).build()

    public class Builder {
        /**
         * If you are using DataSync on an Amazon Web Services Outpost, the Amazon Resource Name (ARNs) of the EC2 agents deployed on your Outpost. For more information about launching a DataSync agent on an Amazon Web Services Outpost, see [Deploy your DataSync agent on Outposts](https://docs.aws.amazon.com/datasync/latest/userguide/deploy-agents.html#outposts-agent).
         */
        public var agentArns: List<String>? = null
        /**
         * The time that the Amazon S3 bucket location was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon S3 bucket or access point.
         */
        public var locationArn: kotlin.String? = null
        /**
         * The URL of the Amazon S3 location that was described.
         */
        public var locationUri: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role used to access an Amazon S3 bucket.
         *
         * For detailed information about using such a role, see Creating a Location for Amazon S3 in the *DataSync User Guide*.
         */
        public var s3Config: aws.sdk.kotlin.services.datasync.model.S3Config? = null
        /**
         * The Amazon S3 storage class that you chose to store your files in when this location is used as a task destination. For more information about S3 storage classes, see [Amazon S3 Storage Classes](http://aws.amazon.com/s3/storage-classes/). Some storage classes have behaviors that can affect your S3 storage cost. For detailed information, see [Considerations when working with S3 storage classes in DataSync](https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes).
         */
        public var s3StorageClass: aws.sdk.kotlin.services.datasync.model.S3StorageClass? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.DescribeLocationS3Response) : this() {
            this.agentArns = x.agentArns
            this.creationTime = x.creationTime
            this.locationArn = x.locationArn
            this.locationUri = x.locationUri
            this.s3Config = x.s3Config
            this.s3StorageClass = x.s3StorageClass
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.DescribeLocationS3Response = DescribeLocationS3Response(this)

        /**
         * construct an [aws.sdk.kotlin.services.datasync.model.S3Config] inside the given [block]
         */
        public fun s3Config(block: aws.sdk.kotlin.services.datasync.model.S3Config.Builder.() -> kotlin.Unit) {
            this.s3Config = aws.sdk.kotlin.services.datasync.model.S3Config.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
