// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datasync.model



/**
 * The credentials that provide DataSync Discovery read access to your on-premises storage system's management interface.
 *
 * DataSync Discovery stores these credentials in [Secrets Manager](https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html). For more information, see [Accessing your on-premises storage system](https://docs.aws.amazon.com/datasync/latest/userguide/discovery-configure-storage.html).
 */
public class Credentials private constructor(builder: Builder) {
    /**
     * Specifies the password for your storage system's management interface.
     */
    public val password: kotlin.String = requireNotNull(builder.password) { "A non-null value must be provided for password" }
    /**
     * Specifies the user name for your storage system's management interface.
     */
    public val username: kotlin.String = requireNotNull(builder.username) { "A non-null value must be provided for username" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.datasync.model.Credentials = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Credentials(")
        append("password=*** Sensitive Data Redacted ***,")
        append("username=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = password.hashCode()
        result = 31 * result + (username.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Credentials

        if (password != other.password) return false
        if (username != other.username) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.datasync.model.Credentials = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the password for your storage system's management interface.
         */
        public var password: kotlin.String? = null
        /**
         * Specifies the user name for your storage system's management interface.
         */
        public var username: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.datasync.model.Credentials) : this() {
            this.password = x.password
            this.username = x.username
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.datasync.model.Credentials = Credentials(this)

        internal fun correctErrors(): Builder {
            if (password == null) password = ""
            if (username == null) username = ""
            return this
        }
    }
}
